/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.db;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainEcUtil;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBFile;
import com.mmmhis.domain.db.DBHandle;
import com.mmmhis.domain.ec.EcUtil;
import java.nio.charset.Charset;

public final class DBLPrimitive {
    public static final String DbLOAD_PARENT = "..";
    public static final String DbLOAD_PREV = "<";
    public static final String DbLOAD_NEXT = ">";
    public static final String DbLOAD_CHILD = ":";
    public static final String DbLOAD_SELF = ".";
    public static final String DbLOAD_LAST = ">>";
    DBHandle frame;
    int fp;
    byte[] unmappedCl;
    DomainByteArrayFileMap mappedCl;
    int clIndex;
    int tagIndex;
    int currIndex;
    DomainString name;
    DBControl dbControl;

    public DBLPrimitive(DBControl dbControl) {
        this.dbControl = dbControl;
        this.frame = new DBHandle();
        this.tagIndex = -1;
    }

    public DBLPrimitive(DBLPrimitive prim) {
        this.frame = new DBHandle(prim.frame);
        this.fp = prim.fp;
        this.mappedCl = prim.mappedCl;
        this.unmappedCl = prim.unmappedCl;
        this.tagIndex = prim.tagIndex;
    }

    int reset() {
        this.frame.reset();
        this.fp = 0;
        this.mappedCl = null;
        this.unmappedCl = null;
        this.tagIndex = -1;
        this.currIndex = -1;
        if (this.name != null) {
            this.name.reset();
        }
        return 0;
    }

    public int loadPrimitive(String path, DomainString value, boolean section) throws DomainException {
        int status;
        block18: {
            DBLPrimitive save;
            boolean read;
            block17: {
                int index = 0;
                boolean root = false;
                read = false;
                int pathLen = path.length();
                save = new DBLPrimitive(this);
                int size = pathLen + 2;
                if (pathLen > 0 && path.charAt(index) == '/') {
                    root = true;
                    ++index;
                } else if (this.tagIndex == -1) {
                    root = true;
                }
                int n = status = section ? 108 : 106;
                while (index < pathLen && path.charAt(index) != '\u0000') {
                    int end;
                    int pathDelIndex = end = path.indexOf(47, index);
                    if (end == -1) {
                        end = pathLen;
                        if (!section) {
                            status = this.findTag(path.substring(index), value);
                            if (status != 0) break block17;
                            break block18;
                        }
                    }
                    status = 0;
                    if (root) {
                        this.reset();
                        read = true;
                        if (this.dbControl.getGateway(path.substring(index, end), this.frame, null, 2) != 0) {
                            status = 108;
                            break block17;
                        }
                    } else {
                        if (this.findFrame(path.substring(index, end)) != 0) {
                            status = 108;
                            break block17;
                        }
                        read = true;
                        this.dbControl.getFrame(this.frame);
                    }
                    this.initPointers();
                    index = index + (end - index) + 1;
                    root = false;
                }
                if (section) break block18;
            }
            if (read) {
                this.reset();
                this.frame = save.frame;
                this.mappedCl = save.mappedCl;
                this.unmappedCl = save.unmappedCl;
                this.clIndex = save.clIndex;
                this.fp = save.fp;
                this.name = save.name;
                if (this.name != null) {
                    this.dbControl.getFrame(this.frame);
                    this.initPointers();
                }
            }
        }
        return status;
    }

    void initPointers() {
        int ptr;
        int end = ptr = this.frame.bufIndex;
        if (this.frame.mappedBuf != null) {
            while (this.frame.mappedBuf.getByte(end) != 0) {
                ++end;
            }
            this.name = new DomainString(this.frame.mappedBuf, ptr, end - ptr);
            ptr = end + 1;
            int[] count = new int[1];
            this.fp = DomainEcNumber.EcGetNumber(this.frame.mappedBuf, ptr, count);
            int pos = DomainEcNumber.EcGetNumber(this.frame.mappedBuf, ptr += count[0], count);
            this.mappedCl = this.frame.mappedBuf;
            this.clIndex = (ptr += count[0]) + pos;
        } else {
            while (this.frame.unmappedBuf[end] != 0) {
                ++end;
            }
            this.name = new DomainString(this.frame.unmappedBuf, ptr, end - ptr);
            ptr = end + 1;
            int[] count = new int[1];
            this.fp = DomainEcNumber.EcGetNumber(this.frame.unmappedBuf, ptr, count);
            int pos = DomainEcNumber.EcGetNumber(this.frame.unmappedBuf, ptr += count[0], count);
            this.unmappedCl = this.frame.unmappedBuf;
            this.clIndex = (ptr += count[0]) + pos;
        }
        this.currIndex = ptr + 1;
        this.tagIndex = ptr + 1;
    }

    int findTag(String aTag, DomainString value) {
        if (this.dbControl.list[this.frame.fd] == null || !this.dbControl.list[this.frame.fd].open) {
            return 106;
        }
        if (this.tagIndex == -1) {
            return 106;
        }
        int index = this.tagIndex;
        if (this.mappedCl != null) {
            while (this.mappedCl.getByte(index) != 0) {
                int end;
                for (end = index; end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0; ++end) {
                }
                String tmpTag = new String(this.mappedCl.getBytes(index, end - index));
                index = ++end;
                while (end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0) {
                    ++end;
                }
                value.setValue(this.mappedCl, index, end - index);
                index = ++end;
                if (!aTag.equals(tmpTag)) continue;
                this.currIndex = end;
                return 0;
            }
        } else {
            while (this.unmappedCl[index] != 0) {
                int end;
                for (end = index; end < this.unmappedCl.length && this.unmappedCl[end] != 0; ++end) {
                }
                DomainString ds = new DomainString(this.unmappedCl, index, end - index);
                ds.decode(this.dbControl.getFile(this.frame.fd).getEncoding());
                String tmpTag = ds.toString();
                index = ++end;
                while (end < this.unmappedCl.length && this.unmappedCl[end] != 0) {
                    ++end;
                }
                value.setValue(this.unmappedCl, index, end - index);
                value.decode(this.dbControl.getFile(this.frame.fd).getEncoding());
                index = ++end;
                if (!aTag.equals(tmpTag)) continue;
                this.currIndex = end;
                return 0;
            }
        }
        return 106;
    }

    int lpFirstSection(DomainString section) throws DomainException {
        return this.lpGetRelativeFrame(DbLOAD_CHILD, section);
    }

    int lpNextSection(DomainString section) throws DomainException {
        return this.lpGetRelativeFrame(DbLOAD_NEXT, section);
    }

    int lpPrevSection(DomainString section) throws DomainException {
        return this.lpGetRelativeFrame(DbLOAD_PREV, section);
    }

    int lpLastSection(DomainString section) throws DomainException {
        return this.lpGetRelativeFrame(DbLOAD_LAST, section);
    }

    int lpGetRelativeFrame(String section, DomainString returnSection) throws DomainException {
        if ((this.unmappedCl != null || this.mappedCl != null) && this.findFrame(section) == 0) {
            this.dbControl.getFrame(this.frame);
            this.initPointers();
            returnSection.setValue(this.name);
            return 0;
        }
        return 108;
    }

    int findFrame(String name) throws DomainException {
        int results;
        boolean[] branch = new boolean[1];
        DBFile file = this.dbControl.getFile(this.frame.fd);
        if (!file.open) {
            return 3;
        }
        int[] ptr = new int[]{0};
        if (this.mappedCl != null) {
            while ((results = DomainEcUtil.ecIndex(name.getBytes(), this.mappedCl, this.clIndex, ptr, null, branch)) == 0) {
                this.frame.ptr = ptr[0];
                if (branch[0]) {
                    this.dbControl.getFrame(this.frame);
                    this.mappedCl = this.frame.mappedBuf;
                    this.clIndex = this.frame.bufIndex;
                    continue;
                }
                break;
            }
        } else {
            byte[] localName;
            while ((results = DomainEcUtil.ecIndex(localName = EcUtil.getConvertedCharSet(name.getBytes(), Charset.defaultCharset().name()), this.unmappedCl, this.clIndex, ptr, null, branch, file.getEncoding())) == 0) {
                this.frame.ptr = ptr[0];
                if (branch[0]) {
                    this.dbControl.getFrame(this.frame);
                    this.unmappedCl = this.frame.unmappedBuf;
                    this.clIndex = this.frame.bufIndex;
                    continue;
                }
                break;
            }
        }
        return results;
    }

    public int lpNext(DomainString tag, DomainString value) {
        if (this.dbControl.list[this.frame.fd] == null || !this.dbControl.list[this.frame.fd].open) {
            return 106;
        }
        if (this.currIndex != 0) {
            int index = this.currIndex;
            if (this.mappedCl != null) {
                if (this.mappedCl.getByte(index) != 0) {
                    int end;
                    for (end = index; end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0; ++end) {
                    }
                    tag.setValue(this.mappedCl, index, end - index);
                    index = ++end;
                    while (end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0) {
                        ++end;
                    }
                    value.setValue(this.mappedCl, index, end - index);
                    this.currIndex = index = ++end;
                    return 0;
                }
            } else if (this.unmappedCl[index] != 0) {
                int end;
                for (end = index; end < this.unmappedCl.length && this.unmappedCl[end] != 0; ++end) {
                }
                tag.setValue(this.unmappedCl, index, end - index);
                index = ++end;
                while (end < this.unmappedCl.length && this.unmappedCl[end] != 0) {
                    ++end;
                }
                value.setValue(this.unmappedCl, index, end - index);
                this.currIndex = index = ++end;
                return 0;
            }
        }
        return 106;
    }

    public int lpPrev(DomainString tag, DomainString value) {
        int index;
        if (this.dbControl.list[this.frame.fd] == null || !this.dbControl.list[this.frame.fd].open) {
            return 106;
        }
        if (this.currIndex != 0 && (index = this.currIndex) != this.tagIndex) {
            --index;
            if (this.mappedCl != null) {
                while (this.mappedCl.getByte(--index) != 0) {
                }
                while (this.mappedCl.getByte(--index) != 0) {
                }
            } else {
                while (this.unmappedCl[--index] != 0) {
                }
                while (this.unmappedCl[--index] != 0) {
                }
            }
            if (++index != this.tagIndex) {
                this.currIndex = index--;
                if (this.mappedCl != null) {
                    int begin;
                    int end;
                    while (this.mappedCl.getByte(--index) != 0) {
                    }
                    for (end = begin = index + 1; end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0; ++end) {
                    }
                    value.setValue(this.mappedCl, begin, end - begin);
                    while (this.mappedCl.getByte(--index) != 0) {
                    }
                    for (end = begin = index + 1; end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0; ++end) {
                    }
                    tag.setValue(this.mappedCl, begin, end - begin);
                } else {
                    int begin;
                    int end;
                    while (this.unmappedCl[--index] != 0) {
                    }
                    for (end = begin = index + 1; end < this.unmappedCl.length && this.unmappedCl[end] != 0; ++end) {
                    }
                    value.setValue(this.unmappedCl, begin, end - begin);
                    while (this.unmappedCl[--index] != 0) {
                    }
                    for (end = begin = index + 1; end < this.unmappedCl.length && this.unmappedCl[end] != 0; ++end) {
                    }
                    tag.setValue(this.unmappedCl, begin, end - begin);
                }
                return 0;
            }
        }
        return 106;
    }

    public int lpFirst(DomainString tag, DomainString value) {
        this.currIndex = this.tagIndex;
        return this.lpNext(tag, value);
    }

    public int lpLast(DomainString tag, DomainString value) {
        if (this.dbControl.list[this.frame.fd] == null || !this.dbControl.list[this.frame.fd].open) {
            return 106;
        }
        int index = this.currIndex;
        if (this.mappedCl != null) {
            if (index == 0 || this.mappedCl.getByte(index) == 0) {
                index = this.tagIndex;
            }
            if (index != 0 && this.mappedCl.getByte(index) != 0) {
                while (this.mappedCl.getByte(index) != 0) {
                    int end;
                    for (end = index; end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0; ++end) {
                    }
                    tag.setValue(this.mappedCl, index, end - index);
                    index = ++end;
                    while (end < this.mappedCl.length() && this.mappedCl.getByte(end) != 0) {
                        ++end;
                    }
                    value.setValue(this.mappedCl, index, end - index);
                    this.currIndex = index = ++end;
                }
                return 0;
            }
        } else {
            if (index == 0 || this.unmappedCl[index] == 0) {
                index = this.tagIndex;
            }
            if (index != 0 && this.unmappedCl[index] != 0) {
                while (this.unmappedCl[index] != 0) {
                    int end;
                    for (end = index; end < this.unmappedCl.length && this.unmappedCl[end] != 0; ++end) {
                    }
                    tag.setValue(this.unmappedCl, index, end - index);
                    index = ++end;
                    while (end < this.unmappedCl.length && this.unmappedCl[end] != 0) {
                        ++end;
                    }
                    value.setValue(this.unmappedCl, index, end - index);
                    this.currIndex = index = ++end;
                }
                return 0;
            }
        }
        return 106;
    }
}

