/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.ec;

import com.mmmhis.domain.ec.EcUtil;

public class EcDecodedByteString {
    private int initialIndex;
    private byte[] source;
    private byte[] local;
    private String encoding;

    public EcDecodedByteString(byte[] buffer, int index, String bufferEncoding) throws IllegalArgumentException {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        this.source = buffer;
        this.initialIndex = index;
        this.encoding = bufferEncoding;
        this.local = null;
    }

    public byte get(int index) throws IndexOutOfBoundsException {
        int localIndex = index - this.initialIndex;
        this.convertUpTo(index);
        return this.local[localIndex];
    }

    private void convertUpTo(int index) throws IndexOutOfBoundsException {
        int sourceEnd;
        int localStart = index - this.initialIndex;
        if (this.local != null && localStart < this.local.length) {
            return;
        }
        for (sourceEnd = index; sourceEnd < this.source.length - 1 && (this.source[sourceEnd] & 0xFF) > 3; ++sourceEnd) {
        }
        if (sourceEnd < this.source.length - 2) {
            ++sourceEnd;
        }
        localStart = this.local == null ? 0 : this.local.length;
        int sourceStart = localStart + this.initialIndex;
        int convertSize = sourceEnd - sourceStart;
        int bufSize = EcDecodedByteString.getEnhancedBufferSize(sourceEnd - this.initialIndex);
        if (this.initialIndex + bufSize > this.source.length) {
            bufSize = this.source.length - this.initialIndex;
        }
        convertSize += bufSize - (sourceEnd - this.initialIndex);
        byte[] result = new byte[bufSize];
        if (this.local != null) {
            System.arraycopy(this.local, 0, result, 0, this.local.length);
        }
        System.arraycopy(this.source, sourceStart, result, localStart, convertSize);
        EcUtil.convertCharSet(result, localStart, convertSize, this.encoding);
        this.local = result;
    }

    private static int getEnhancedBufferSize(int suggestedSize) {
        int hunkSize = 64;
        int delta = 64 - suggestedSize % 64;
        return suggestedSize + delta;
    }
}

