/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.ec;

import java.util.ArrayList;

public class EcQuark {
    public static final int EcNULLQUARK = 0;
    static final int QUANTUMSHIFT = 8;
    static final int QUANTUMMASK = 255;
    static final int CHUNKPER = 8;
    static final int CHUNKMASK = 2047;
    static final int QUANTSIZE = 256;
    int nextQuark = 1;
    int quarkMask = 0;
    int[] quarkTable;
    int quarkRehash;
    STRING[][] stringTable;
    int nextUniq = -1;
    ArrayList list = new ArrayList();

    public int makeSignature(String name, int length) {
        char c;
        int sig = 0;
        int index = 0;
        char[] buf = name.toCharArray();
        while (length-- > 0 && (c = buf[index++]) != '\u0000') {
            sig = (sig << 1) + c;
        }
        return sig;
    }

    private int hash(int sig) {
        return sig & this.quarkMask;
    }

    private int rehashVal(int sig) {
        return sig % this.quarkRehash + 2 | 1;
    }

    private int rehash(int idx, int rehash) {
        return idx + rehash & this.quarkMask;
    }

    private String getName(int q) {
        return this.stringTable[q >> 8][q & 0xFF].name;
    }

    private void setName(int q, String str) {
        if (this.stringTable[q >> 8][q & 0xFF] == null) {
            this.stringTable[q >> 8][q & 0xFF] = new STRING();
        }
        this.stringTable[q >> 8][q & 0xFF].name = str;
    }

    private int getSig(int q) {
        return this.stringTable[q >> 8][q & 0xFF].sig;
    }

    private void setSig(int q, int sig) {
        this.stringTable[q >> 8][q & 0xFF].sig = sig;
    }

    private int getNextQuark() {
        return this.nextQuark++;
    }

    void expandQuarkTable() {
        int newmask;
        int oldmask = this.quarkMask;
        if (oldmask != 0) {
            newmask = (oldmask << 1) + 1;
        } else {
            this.stringTable = new STRING[8][];
            this.stringTable[0] = new STRING[256];
            this.setName(0, "");
            newmask = 255;
        }
        int[] oldentries = this.quarkTable;
        this.quarkTable = new int[newmask + 1];
        this.quarkMask = newmask;
        this.quarkRehash = this.quarkMask - 2;
        if (oldentries != null) {
            for (int oldidx = 0; oldidx <= oldmask; ++oldidx) {
                int q = oldentries[oldidx];
                if (q == 0) continue;
                int sig = this.getSig(q);
                int newidx = this.hash(sig);
                int rehash = this.rehashVal(sig);
                while (this.quarkTable[newidx] != 0) {
                    newidx = this.rehash(newidx, rehash);
                }
                this.quarkTable[newidx] = q;
            }
        }
    }

    public int stringToQuarkPrimitive(String name, int length, boolean create) {
        int q;
        if (this.quarkTable == null) {
            this.expandQuarkTable();
        }
        if (name == null || name.length() == 0) {
            return 0;
        }
        int sig = this.makeSignature(name, length);
        while (true) {
            int rehash = this.rehashVal(sig);
            int idx = this.hash(sig);
            while ((q = this.quarkTable[idx]) != 0) {
                String tmpName = this.getName(q);
                if (sig == this.getSig(q) && tmpName.startsWith(name) && length >= tmpName.length()) {
                    return q;
                }
                idx = this.rehash(idx, rehash);
            }
            if (this.nextUniq == this.nextQuark) {
                return 0;
            }
            if (this.nextQuark + (this.nextQuark >> 2) <= this.quarkMask) break;
            this.expandQuarkTable();
        }
        if (create) {
            q = this.getNextQuark();
            if ((q & 0xFF) == 0) {
                if ((q & 0x7FF) == 0) {
                    STRING[][] stringTable2 = this.stringTable;
                    stringTable2 = new STRING[(q >> 8) + 8][];
                    System.arraycopy(this.stringTable, 0, stringTable2, 0, this.stringTable.length);
                    this.stringTable = stringTable2;
                }
                this.stringTable[q >> 8] = new STRING[256];
            }
            String local = new String(name.toCharArray(), 0, length);
            this.setName(q, local);
            this.setSig(q, sig);
            this.quarkTable[idx] = q;
        } else {
            q = 0;
        }
        return q;
    }

    public int stringToQuark(String name) {
        return this.stringToQuarkPrimitive(name, name.length(), true);
    }

    public Integer stringToQuark_org(String name) {
        Integer quark;
        if (this.list.contains(name)) {
            quark = new Integer(this.list.indexOf(name));
        } else {
            quark = new Integer(this.list.size());
            this.list.add(name);
        }
        return quark;
    }

    public String quarkToString(Integer quark) {
        return (String)this.list.get(quark);
    }

    public int findQuark(String name) {
        return this.stringToQuarkPrimitive(name, name.length(), false);
    }

    public Integer findQuark_org(String name) {
        Integer quark = null;
        if (this.list.contains(name)) {
            quark = new Integer(this.list.indexOf(name));
        }
        return quark;
    }

    class STRING {
        int sig;
        String name;

        STRING() {
        }
    }
}

