/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.ec;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.ec.EcIndex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;

public final class EcUtil {
    public static final int EcNULLQUARK = 0;
    public static final int EcCHARSET_IS0 = 0;
    public static final int EcCHARSET_EBC = 1;
    public static final int EcCHARSET_860 = 2;
    public static final int EcCHARSET_437 = 3;
    public static final int EcCHARSET_ASC = 4;
    public static final int EcCHARSET_DEFAULT = 0;
    public static final int DSL_GATEWAY = 1;
    public static final int DSL_DICTIONARY = 2;
    public static final int DSL_EBCDIC = 4;
    public static final int DSL_ATTRIBUTE = 8;
    public static final int DSL_LOADFRAME = 16;
    public static final int DSL_HTMLFRAME = 32;
    public static final int DSL_IMAGEFRAME = 64;
    public static final int DSL_PC860 = 128;
    public static final int DSL_PC437 = 256;
    public static final int DSL_ASCII = 512;
    public static final int DSL_TABLE = 1024;
    public static final int DSL_SUPPLEMENT = 2048;
    public static final int DSL_C = 4096;
    public static final int DSL_COBOL = 8192;
    public static final int DSL_CODELIST = 16384;
    public static final int DSL_REFERENCE = 32768;
    public static final String CopyrightYear = "2011";
    public static final String EcMMMCopyright = "This is an unpublished work containing 3M confidential and proprietary\ninformation. Disclosure, use, or reproduction without the written\nauthorization of 3M is prohibited. If publication occurs, the \nfollowing notice applies:\n\nCopyright \u00c2\u00a9 2011, 3M.  All rights reserved.\n";
    public static final int[] EcISO_to_EBCDIC = new int[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 60, 61, 50, 38, 23, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 186, 224, 187, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 79, 208, 161, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 64, 64, 64, 64, 64, 64, 0, 64, 64, 0, 64, 64, 64, 64, 64, 74, 64, 64, 79, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 193, 193, 193, 193, 193, 193, 193, 195, 197, 197, 197, 197, 201, 201, 201, 201, 196, 213, 214, 214, 214, 214, 214, 167, 214, 228, 228, 228, 228, 232, 151, 194, 129, 129, 129, 129, 129, 129, 129, 131, 133, 133, 133, 133, 137, 137, 137, 137, 132, 149, 150, 150, 150, 150, 150, 64, 150, 164, 164, 164, 164, 168, 151, 168};
    public static final int[] EcEBCDIC_to_ISO = new int[]{0, 1, 2, 3, 0, 9, 0, 127, 0, 0, 0, 11, 12, 13, 14, 15, 16, 17, 18, 0, 0, 10, 8, 23, 24, 25, 0, 0, 28, 29, 30, 31, 0, 0, 0, 0, 0, 10, 22, 27, 0, 0, 0, 0, 0, 5, 6, 7, 0, 0, 21, 0, 0, 0, 0, 4, 0, 0, 0, 0, 19, 20, 0, 26, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 46, 60, 40, 43, 124, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 36, 42, 41, 59, 0, 45, 47, 0, 0, 0, 0, 0, 0, 0, 0, 124, 44, 37, 95, 62, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 58, 35, 64, 39, 61, 34, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 0, 0, 0, 0, 0, 0, 0, 106, 107, 108, 109, 110, 111, 112, 113, 114, 0, 0, 0, 0, 0, 0, 0, 126, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 0, 0, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 93, 0, 0, 0, 0, 123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 0, 0, 0, 0, 0, 0, 125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 0, 0, 0, 0, 0, 0, 92, 0, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0};
    public static final int[] EcISO_to_PC860 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 32, 173, 155, 156, 95, 89, 124, 95, 34, 95, 166, 174, 170, 45, 95, 45, 248, 241, 253, 95, 39, 230, 95, 250, 44, 95, 167, 175, 172, 171, 95, 168, 65, 145, 143, 142, 65, 134, 95, 128, 146, 144, 137, 69, 152, 139, 73, 73, 68, 165, 169, 159, 140, 153, 79, 42, 237, 157, 150, 85, 154, 89, 80, 225, 133, 160, 131, 132, 97, 97, 95, 135, 138, 130, 136, 101, 141, 161, 105, 105, 100, 164, 149, 162, 147, 148, 111, 246, 232, 151, 163, 117, 129, 121, 112, 121};
    public static final int[] EcPC860_to_ISO = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 199, 252, 233, 226, 227, 224, 197, 231, 234, 202, 232, 205, 212, 236, 195, 194, 201, 193, 200, 244, 245, 242, 218, 249, 204, 213, 220, 162, 163, 217, 95, 211, 225, 237, 243, 250, 241, 209, 170, 186, 191, 210, 172, 189, 188, 161, 171, 187, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 223, 95, 95, 95, 95, 181, 95, 95, 95, 95, 95, 95, 216, 95, 95, 95, 177, 95, 95, 95, 95, 247, 95, 176, 95, 183, 95, 110, 178, 95, 32};
    public static final int[] EcISO_to_PC437 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 32, 173, 155, 156, 95, 157, 124, 95, 34, 95, 166, 174, 170, 45, 95, 45, 248, 241, 253, 95, 39, 230, 95, 250, 44, 95, 167, 175, 172, 171, 95, 168, 65, 65, 65, 65, 142, 143, 146, 128, 69, 144, 69, 69, 73, 73, 73, 73, 68, 165, 79, 79, 79, 79, 153, 42, 237, 85, 85, 85, 154, 89, 80, 225, 133, 160, 131, 97, 132, 134, 145, 135, 138, 130, 136, 137, 141, 161, 140, 139, 100, 164, 149, 162, 147, 111, 148, 246, 232, 151, 163, 150, 129, 121, 112, 152};
    public static final int[] EcPC437_to_ISO = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197, 201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 162, 163, 165, 95, 102, 225, 237, 243, 250, 241, 209, 170, 186, 191, 95, 172, 189, 188, 161, 171, 187, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 223, 95, 95, 95, 95, 181, 95, 95, 95, 95, 95, 95, 216, 95, 95, 95, 177, 95, 95, 95, 95, 247, 95, 176, 183, 183, 95, 95, 178, 95, 32};
    public static final int[] EcISO_to_ASCII = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 32, 173, 155, 156, 95, 157, 124, 95, 34, 95, 166, 174, 170, 45, 95, 95, 248, 241, 253, 95, 39, 230, 95, 250, 44, 95, 167, 175, 172, 171, 95, 168, 65, 65, 65, 65, 142, 143, 146, 128, 69, 144, 69, 69, 73, 73, 73, 73, 68, 165, 79, 79, 79, 79, 153, 42, 237, 85, 85, 85, 154, 89, 80, 225, 133, 160, 131, 97, 132, 134, 145, 135, 138, 130, 136, 137, 141, 161, 140, 139, 100, 164, 149, 162, 147, 111, 148, 246, 237, 151, 163, 150, 129, 121, 112, 152};
    public static final int[] EcASCII_to_ISO = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197, 201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 162, 163, 165, 95, 102, 225, 237, 243, 250, 241, 209, 170, 186, 191, 95, 172, 189, 188, 161, 171, 187, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 223, 95, 95, 95, 95, 181, 95, 95, 95, 95, 95, 95, 216, 95, 95, 95, 177, 95, 95, 95, 95, 247, 95, 176, 183, 183, 95, 95, 178, 95, 32};
    public static final int EcNUMSIZE = 5;
    public static final int EcG_EXTBIT = 128;
    public static final int EcG_SIGNBIT = 64;
    public static final int EcG_COUNTMASK = 56;
    public static final int EcG_SEEDMASK = 7;

    public static int strlen(byte[] buffer, int index) {
        int len = 0;
        while (index < buffer.length && buffer[index++] != 0) {
            ++len;
        }
        return len;
    }

    public static int strlen(DomainByteArrayFileMap buffer, int index) {
        int len = 0;
        while (index < buffer.length() && buffer.getByte(index++) != 0) {
            ++len;
        }
        return len;
    }

    public static int strcpy(byte[] destBuffer, int destIndex, byte[] srcBuffer, int srcIndex) {
        int len = EcUtil.strlen(srcBuffer, srcIndex);
        System.arraycopy(srcBuffer, srcIndex, destBuffer, destIndex, len);
        destBuffer[destIndex + len] = 0;
        return destIndex;
    }

    public static int strcpy(DomainByteArrayFileMap destBuffer, int destIndex, byte[] srcBuffer, int srcIndex) {
        int len = EcUtil.strlen(srcBuffer, srcIndex);
        DomainByteArrayFileMap.arraycopy(srcBuffer, srcIndex, destBuffer, destIndex, len);
        destBuffer.putByte(destIndex + len, (byte)0);
        return destIndex;
    }

    public static char[] convertCharSet(char[] buffer, int index, int[] table) {
        while (buffer[index] != '\u0000') {
            buffer[index] = (char)table[buffer[index]];
            ++index;
        }
        return buffer;
    }

    public static byte[] convertCharSet(byte[] buffer, int index, int[] table) {
        while (buffer[index] != 0) {
            buffer[index] = (byte)table[buffer[index] & 0xFF];
            ++index;
        }
        return buffer;
    }

    public static void convertCharSet(byte[] buffer, int startIndex, int length, String sourceEncoding) {
        if (sourceEncoding == null) {
            return;
        }
        try {
            Charset cs = Charset.forName(sourceEncoding);
            CharsetDecoder decoder = cs.newDecoder();
            CharBuffer cb = decoder.decode(ByteBuffer.wrap(buffer, startIndex, length));
            char[] chars = new char[cb.length()];
            cb.get(chars);
            for (int i2 = 0; i2 < chars.length; ++i2) {
                buffer[i2 + startIndex] = (byte)chars[i2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getConvertedCharSet(byte[] buffer, String sourceEncoding) {
        if (sourceEncoding == null) {
            return (byte[])buffer.clone();
        }
        try {
            Charset cs = Charset.forName(sourceEncoding);
            CharsetDecoder decoder = cs.newDecoder();
            CharBuffer cb = decoder.decode(ByteBuffer.wrap(buffer));
            char[] chars = new char[cb.length()];
            cb.get(chars);
            byte[] result = new byte[chars.length];
            for (int i2 = 0; i2 < chars.length; ++i2) {
                result[i2] = (byte)chars[i2];
            }
            return result;
        }
        catch (Exception exception) {
            return (byte[])buffer.clone();
        }
    }

    public static int putNumber(byte[] buffer, int index, long val) {
        int localIndex = index;
        if (val < 128L && val >= 0L) {
            buffer[index] = (byte)val;
            return 1;
        }
        buffer[index] = -128;
        if (val < 0L) {
            int n = index;
            buffer[n] = (byte)(buffer[n] | 0x40);
            val = -val;
        }
        long mask = 0xFF000000L;
        int bytes = 4;
        while ((mask & val) == 0L) {
            mask >>= 8;
            --bytes;
        }
        int byteval = (int)(mask & val) >> (bytes - 1) * 8;
        if (byteval <= 7) {
            int n = index;
            buffer[n] = (byte)(buffer[n] | byteval);
            mask >>= 8;
            --bytes;
        }
        int n = index++;
        buffer[n] = (byte)(buffer[n] | bytes << 3);
        while (bytes > 0) {
            buffer[index++] = (byte)((mask & val) >> --bytes * 8);
            mask >>= 8;
        }
        return index - localIndex;
    }

    public static int putNumberWide(byte[] buffer, int index, long val) {
        byte[] localBuffer = buffer;
        int localIndex = index;
        buffer[index] = -128;
        if (val < 0L) {
            int n = index;
            buffer[n] = (byte)(buffer[n] | 0x40);
            val = -val;
        }
        long mask = 0xFF000000L;
        int bytes = 4;
        int n = index++;
        buffer[n] = (byte)(buffer[n] | bytes << 3);
        while (bytes > 0) {
            buffer[index++] = (byte)((mask & val) >> --bytes * 8);
            mask >>= 8;
        }
        return index - localIndex;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                String line;
                int count = 0;
                EcIndex[] list = new EcIndex[1000];
                byte[][] buffer = new byte[1][];
                int[] len = new int[1];
                BufferedReader reader = new BufferedReader(new FileReader(new File(args[0])));
                while ((line = reader.readLine()) != null) {
                    if (count > 1000) {
                        System.err.println("Too many indices.");
                    }
                    list[count] = new EcIndex(line + "\n", count++);
                }
                EcUtil.buildIndexTree(list, 0, count, buffer, len, false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void buildIndexTree(EcIndex[] array, int arrIndex, int count, byte[][] buffer, int[] len, boolean branch) {
        int maxLen = EcUtil.getLongestTermLength(array, arrIndex, count);
        EcIndex[] tmpArray = new EcIndex[count];
        System.arraycopy(array, arrIndex, tmpArray, 0, count);
        Arrays.sort(tmpArray, 0, count, new EcIndex());
        System.arraycopy(tmpArray, 0, array, arrIndex, count);
        CLTree root = EcUtil.buildTree(array, arrIndex, count);
        EcUtil.treeDup(buffer, len, root, branch ? maxLen + 1 : 0);
        root = null;
    }

    static CLTree buildTree(EcIndex[] array, int arrIndex, int count) {
        CLTree root = null;
        for (int i2 = 0; i2 < count; ++i2) {
            EcIndex src = array[arrIndex + i2];
            root = EcUtil.buildInnerTree(root, src.first.toCharArray(), src.index);
        }
        return root;
    }

    static CLTree buildInnerTree(CLTree root, char[] curr, long index) {
        int type = 1;
        CLTree next = root;
        CLTree last = null;
        int currIndex = 0;
        while (next != null) {
            last = next;
            if (next.token == curr[currIndex]) {
                type = 1;
                next = next.child;
                ++currIndex;
                continue;
            }
            type = 2;
            next = next.sibling;
        }
        do {
            next = new CLTree();
            if (last != null) {
                if (type == 1) {
                    last.child = next;
                } else {
                    last.sibling = next;
                }
            } else {
                root = next;
            }
            if (currIndex < curr.length) {
                next.token = curr[currIndex];
            } else {
                next.token = (char)3;
                next.index = index;
            }
            last = next;
            type = 1;
        } while (currIndex++ < curr.length);
        return root;
    }

    static void treeDup(byte[][] buffer, int[] size, CLTree root, int branch) {
        int len = EcUtil.getTreeSize(root) + 1;
        byte[] local = new byte[len];
        int localIndex = 0;
        local[localIndex] = (byte)branch;
        size[0] = EcUtil.optimizeTree(root, local, localIndex + 1, false);
        size[0] = size[0] + 1;
        buffer[0] = local;
    }

    static int optimizeTree(CLTree root, byte[] buffer, int index, boolean sibling) {
        int width;
        CLTree lptr;
        int save;
        if (root == null) {
            return 0;
        }
        CLTree local = root;
        int ptr = index;
        if (sibling) {
            buffer[ptr++] = 1;
            save = ptr += 5;
        } else {
            save = ptr;
        }
        if (local.sibling == null && local.child != null && local.child.sibling == null) {
            buffer[ptr++] = 2;
            lptr = root;
            while (lptr != null) {
                local = lptr;
                buffer[ptr++] = (byte)local.token;
                if (local.token == '\u0003') {
                    ptr += EcUtil.putNumber(buffer, ptr, local.index);
                }
                if (local.child != null && local.child.sibling == null) {
                    lptr = local.child;
                    continue;
                }
                break;
            }
        } else {
            lptr = root;
            while (local != null) {
                buffer[ptr++] = (byte)local.token;
                if (local.token == '\u0003') {
                    ptr += EcUtil.putNumber(buffer, ptr, local.index);
                }
                local = local.sibling;
            }
        }
        buffer[ptr++] = 0;
        local = lptr;
        int len = ptr - save;
        while (local != null) {
            width = EcUtil.optimizeTree(local.child, buffer, ptr, local.sibling != null);
            ptr += width;
            len += width;
            local = local.sibling;
        }
        if (sibling) {
            width = EcUtil.putNumber(buffer, index + 1, len);
            System.arraycopy(buffer, save, buffer, index + width + 1, len);
            len += width + 1;
        }
        return len;
    }

    static void printInterTree(CLTree root, int tab) {
        for (int i2 = 0; i2 < tab; ++i2) {
            System.err.print(" ");
        }
        CLTree local = root;
        while (local != null) {
            switch (local.token) {
                case '\u0003': {
                    System.err.print("<eot>");
                    System.err.print("[" + root.index + "]");
                    break;
                }
                default: {
                    System.err.print(local.token);
                }
            }
            local = local.sibling;
        }
        System.err.print("\n");
        local = root;
        while (local != null) {
            EcUtil.printInterTree(local.child, tab + 2);
            local = local.sibling;
        }
    }

    static void dump(byte[] buffer, int len) {
        int[] offset = new int[1];
        int index = 0;
        int endbuf = index + len;
        System.err.print("<" + buffer[index++] + ">");
        int count = 4;
        while (index < endbuf) {
            switch (buffer[index]) {
                case 3: {
                    System.err.print("<e:" + DomainEcNumber.EcGetNumber(buffer, ++index, offset) + ">");
                    index += offset[0];
                    count += 10;
                    break;
                }
                case 2: {
                    ++index;
                    System.err.print("<c>");
                    count += 3;
                    break;
                }
                case 1: {
                    System.err.print("<s:" + DomainEcNumber.EcGetNumber(buffer, ++index, offset) + ">");
                    index += offset[0];
                    count += 10;
                    break;
                }
                case 0: {
                    ++index;
                    System.err.print("<n>");
                    count += 3;
                    break;
                }
                default: {
                    System.err.print((char)buffer[index++]);
                }
            }
            if (count <= 70) continue;
            System.err.print("\n");
            count = 0;
        }
        System.err.print("\n");
    }

    static int getTreeSize(CLTree root) {
        int len = 1;
        if (root != null) {
            len += EcUtil.getTreeSize(root.child);
            if (root.sibling != null) {
                len += 4;
                len += EcUtil.getTreeSize(root.sibling);
            } else {
                ++len;
            }
            if (root.token == '\u0003') {
                len += 4;
            }
        }
        return len;
    }

    static int getLongestTermLength(EcIndex[] array, int arrIndex, int count) {
        int len = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            if (array[arrIndex + i2].first.length() <= len) continue;
            len = array[arrIndex + i2].first.length();
        }
        return len;
    }

    static class CLTree {
        char token;
        long index;
        CLTree child;
        CLTree sibling;

        CLTree() {
        }
    }
}

