/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainBitString;
import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.table.TBLLookupStack;
import com.mmmhis.domain.table.TBLPage;
import com.mmmhis.domain.table.TBLTable;
import java.util.Arrays;

public class TBLRow {
    protected TBLTable tbl;
    protected TBLFile file;
    protected boolean positioned;
    protected int mPageOff;
    protected int mRowOff;
    protected int row;
    public byte[] buffer;
    public byte[] brbuf;
    public byte[] savebuf;
    public String[] strings;

    public TBLRow(TBLTable tt) {
        this.tbl = tt;
        this.file = tt.getFile();
        this.reset();
    }

    public void reset() {
        this.positioned = false;
        this.mPageOff = 0;
        this.mRowOff = 0;
        this.row = 0;
        int lrecl = this.tbl.getRowLength();
        this.buffer = new byte[lrecl];
        Arrays.fill(this.buffer, (byte)0);
        this.savebuf = new byte[lrecl];
        Arrays.fill(this.savebuf, (byte)0);
        this.brbuf = new byte[this.tbl.getBranchLength()];
        Arrays.fill(this.brbuf, (byte)0);
        this.resetStrings();
    }

    public void resetStrings() {
        int sc = this.tbl.getStrCount();
        if (sc <= 0) {
            this.strings = null;
        } else {
            this.strings = new String[sc];
            Arrays.fill(this.strings, null);
        }
    }

    public int getStringSpace() {
        int sc = this.tbl.getStrCount();
        int size = 0;
        for (int i2 = 0; i2 < sc; ++i2) {
            if (this.strings[i2] != null) {
                size += this.strings[i2].length();
            }
            ++size;
        }
        return size;
    }

    boolean recordFitsInPage(TBLPage blk, boolean leaf) {
        int lrecl = leaf ? this.tbl.getRowLength() : this.tbl.getBranchLength();
        int tslen = leaf ? this.getStringSpace() : 0;
        int need = lrecl + tslen;
        int rused = blk.getPageRowData();
        int sused = blk.getPageStrings();
        int avail = 4080 - rused - sused;
        return need <= avail;
    }

    void putRecordInPage(TBLPage blk, int location, boolean leaf) throws DomainException {
        int strptr;
        int sused;
        int rused;
        int avail;
        int tslen;
        int lrecl = leaf ? this.tbl.getRowLength() : this.tbl.getBranchLength();
        int need = lrecl + (tslen = leaf ? this.getStringSpace() : 0);
        if (need > (avail = 4080 - (rused = blk.getPageRowData()) - (sused = blk.getPageStrings()))) {
            throw new DomainException("No space in record");
        }
        int endRecs = 16 + rused;
        int toShift = endRecs - location;
        if (blk.mappedBuffer != null) {
            if (toShift > 0) {
                DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, location, blk.mappedBuffer, location + lrecl, toShift);
            }
            if (leaf) {
                DomainByteArrayFileMap.arraycopy(this.buffer, 0, blk.mappedBuffer, location, lrecl);
                if (tslen > 0) {
                    strptr = location + this.tbl.getStrOffset();
                    TBLTable.putShort(blk.mappedBuffer, strptr, (short)(sused += tslen));
                    TBLTable.putShort(blk.mappedBuffer, strptr + 2, (short)tslen);
                    int sc = this.tbl.getStrCount();
                    strptr = 4096 - sused;
                    for (int i2 = 0; i2 < sc; ++i2) {
                        int len;
                        String instr = this.strings[i2];
                        int n = len = instr == null ? 0 : instr.length();
                        if (len > 0) {
                            byte[] ba = instr.getBytes();
                            DomainByteArrayFileMap.arraycopy(ba, 0, blk.mappedBuffer, strptr, len);
                        }
                        blk.mappedBuffer.putByte(strptr + len, (byte)0);
                        strptr += len + 1;
                    }
                    blk.setStrings(sused);
                }
            } else {
                DomainByteArrayFileMap.arraycopy(this.brbuf, 0, blk.mappedBuffer, location, lrecl);
            }
        } else {
            if (toShift > 0) {
                System.arraycopy(blk.unmappedBuffer, location, blk.unmappedBuffer, location + lrecl, toShift);
            }
            if (leaf) {
                System.arraycopy(this.buffer, 0, blk.unmappedBuffer, location, lrecl);
                if (tslen > 0) {
                    strptr = location + this.tbl.getStrOffset();
                    TBLTable.putShort(blk.unmappedBuffer, strptr, (short)(sused += tslen));
                    TBLTable.putShort(blk.unmappedBuffer, strptr + 2, (short)tslen);
                    int sc = this.tbl.getStrCount();
                    strptr = 4096 - sused;
                    for (int i3 = 0; i3 < sc; ++i3) {
                        int len;
                        String instr = this.strings[i3];
                        int n = len = instr == null ? 0 : instr.length();
                        if (len > 0) {
                            byte[] ba = instr.getBytes();
                            System.arraycopy(ba, 0, blk.unmappedBuffer, strptr, len);
                        }
                        blk.unmappedBuffer[strptr + len] = 0;
                        strptr += len + 1;
                    }
                    blk.setStrings(sused);
                }
            } else {
                System.arraycopy(this.brbuf, 0, blk.unmappedBuffer, location, lrecl);
            }
        }
        int nrecs = blk.getPageRecords();
        blk.setRecords(++nrecs, leaf);
        blk.setRowData(rused += lrecl);
        blk.modifiedPage();
    }

    void getRecordFromPage(TBLPage blk, int location, boolean leaf) throws DomainException {
        block8: {
            block7: {
                if (blk.mappedBuffer == null) break block7;
                if (!leaf) {
                    DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, location, this.brbuf, 0, this.tbl.getBranchLength());
                    return;
                }
                DomainByteArrayFileMap.arraycopy(blk.mappedBuffer, location, this.buffer, 0, this.tbl.getRowLength());
                this.resetStrings();
                int strCount = this.tbl.getStrCount();
                if (strCount <= 0) break block8;
                int strptr = location + this.tbl.getStrOffset();
                int sused = TBLTable.getShort(blk.mappedBuffer, strptr) & Short.MAX_VALUE;
                strptr = 4096 - sused;
                for (int i2 = 0; i2 < strCount; ++i2) {
                    int end;
                    for (end = strptr; end < blk.mappedBuffer.length() && blk.mappedBuffer.getByte(end) != 0; ++end) {
                    }
                    int len = end - strptr;
                    this.strings[i2] = new String(blk.mappedBuffer.getBytes(strptr, len));
                    strptr += len + 1;
                }
                break block8;
            }
            if (!leaf) {
                System.arraycopy(blk.unmappedBuffer, location, this.brbuf, 0, this.tbl.getBranchLength());
                return;
            }
            System.arraycopy(blk.unmappedBuffer, location, this.buffer, 0, this.tbl.getRowLength());
            this.resetStrings();
            int strCount = this.tbl.getStrCount();
            if (strCount > 0) {
                int strptr = location + this.tbl.getStrOffset();
                int sused = TBLTable.getShort(blk.unmappedBuffer, strptr) & Short.MAX_VALUE;
                strptr = 4096 - sused;
                for (int i3 = 0; i3 < strCount; ++i3) {
                    int end;
                    for (end = strptr; end < blk.unmappedBuffer.length && blk.unmappedBuffer[end] != 0; ++end) {
                    }
                    int len = end - strptr;
                    this.strings[i3] = new String(blk.unmappedBuffer, strptr, len);
                    strptr += len + 1;
                }
            }
        }
    }

    void loadRecord() throws DomainException {
        TBLPage blk = this.file.absolutePage(this.mPageOff);
        this.row = blk.body + this.mRowOff;
        this.getRecordFromPage(blk, this.row, true);
    }

    public void replace() {
        if (!this.positioned) {
            return;
        }
        TBLPage blk = this.file.absolutePage(this.mPageOff);
        this.row = blk.body + this.mRowOff;
        if (blk.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(this.buffer, 0, blk.mappedBuffer, this.row, this.tbl.getRowLength());
        } else {
            System.arraycopy(this.buffer, 0, blk.unmappedBuffer, this.row, this.tbl.getRowLength());
        }
        blk.modifiedPage();
    }

    public int first() throws DomainException {
        this.positioned = false;
        TBLPage blk = this.file.absolutePage(this.tbl.getRootOffset());
        while (blk.getPageRecords() != 0) {
            if (blk.isLeaf()) {
                this.mPageOff = blk.getBlockOffset();
                this.mRowOff = 0;
                this.positioned = true;
                this.loadRecord();
                return 0;
            }
            blk = this.file.absolutePage(blk.getPageLower());
        }
        return 6;
    }

    public int last() throws DomainException {
        this.positioned = false;
        TBLPage blk = this.file.absolutePage(this.tbl.getRootOffset());
        int nrec;
        while ((nrec = blk.getPageRecords()) != 0) {
            if (blk.isLeaf()) {
                int lrecl = this.tbl.getRowLength();
                this.mPageOff = blk.getBlockOffset();
                this.mRowOff = (nrec - 1) * lrecl;
                this.positioned = true;
                this.loadRecord();
                return 0;
            }
            int rowoff = nrec * this.tbl.getBranchLength() + 16;
            int blkoff = blk.mappedBuffer != null ? (int)TBLTable.getLong(blk.mappedBuffer, rowoff - 4) : (int)TBLTable.getLong(blk.unmappedBuffer, rowoff - 4);
            blk = this.file.absolutePage(blkoff);
        }
        return 6;
    }

    public int after() throws DomainException {
        if (!this.positioned) {
            return 32;
        }
        this.mRowOff += this.tbl.getRowLength();
        while (true) {
            TBLPage blk;
            int endoff;
            if (this.mRowOff < (endoff = (blk = this.file.absolutePage(this.mPageOff)).getPageRecords() * this.tbl.getRowLength())) {
                this.loadRecord();
                return 0;
            }
            int offset = blk.getPageForward();
            if (offset == 0) {
                this.mPageOff = 0;
                this.mRowOff = 0;
                this.positioned = false;
                return 15;
            }
            this.mPageOff = offset;
            this.mRowOff = 0;
        }
    }

    public int before() throws DomainException {
        if (!this.positioned) {
            return 32;
        }
        int lrecl = this.tbl.getRowLength();
        while (true) {
            if (this.mRowOff >= lrecl) {
                this.mRowOff -= lrecl;
                this.loadRecord();
                return 0;
            }
            TBLPage blk = this.file.absolutePage(this.mPageOff);
            int offset = blk.getPageLower();
            if (offset == 0) {
                this.mPageOff = 0;
                this.mRowOff = 0;
                this.positioned = false;
                return 15;
            }
            this.mPageOff = offset;
            this.mRowOff = blk.getPageRecords() * lrecl;
        }
    }

    public int lookup() throws DomainException {
        int rc = 0;
        TBLLookupStack rstack = new TBLLookupStack();
        this.positioned = false;
        rc = this.tbl.getType() == 1 ? this.tbl.lookupDuplicate(this.brbuf, rstack, false) : this.tbl.lookupUnique(this.brbuf, rstack, false);
        if (rc > 2) {
            return rc;
        }
        this.mPageOff = rstack.pageOffset[rstack.ix];
        this.mRowOff = rstack.dataOffset[rstack.ix];
        this.loadRecord();
        if (rc <= 1) {
            this.positioned = true;
        }
        return rc;
    }

    public int insert() throws DomainException {
        int irc;
        System.arraycopy(this.buffer, 0, this.brbuf, 0, this.tbl.getBranchLength());
        int rc = 0;
        TBLLookupStack rstack = new TBLLookupStack();
        this.positioned = false;
        if (this.tbl.getType() == 1) {
            rc = this.tbl.lookupDuplicate(this.brbuf, rstack, true);
            if (rc > 2) {
                return rc;
            }
        } else {
            rc = this.tbl.lookupUnique(this.brbuf, rstack, true);
            if (rc == 0) {
                return 4;
            }
        }
        if ((irc = this.tbl.insertBase(this, rstack, rc)) == 0) {
            this.tbl.modifiedTable();
        }
        return irc;
    }

    public int getInteger(int fnum) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return -1;
        }
        short[] metaData = this.tbl.getMetaData();
        int k = (fnum - 1) * 3;
        short off = metaData[k + 1];
        switch (metaData[k]) {
            case 1: {
                return this.buffer[off];
            }
            case 2: {
                return TBLTable.getShort(this.buffer, (int)off);
            }
            case 3: {
                return TBLTable.getMedium(this.buffer, (int)off);
            }
            case 4: {
                return (int)TBLTable.getLong(this.buffer, (int)off);
            }
            case 7: {
                return (int)TBLTable.getLong(this.buffer, (int)off);
            }
        }
        return -1;
    }

    public String getString(int fnum) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return null;
        }
        short[] metaData = this.tbl.getMetaData();
        int k = (fnum - 1) * 3;
        int off = metaData[k + 1];
        switch (metaData[k]) {
            case 5: {
                return this.strings[off];
            }
            case 13: 
            case 21: {
                char b;
                int len;
                StringBuffer sb = new StringBuffer(len);
                int lastNonBlank = 0;
                int used = 0;
                for (len = metaData[k + 2]; len > 0 && (b = (char)this.buffer[off]) != '\u0000'; --len) {
                    sb.append(b);
                    ++off;
                    ++used;
                    if (b == ' ') continue;
                    lastNonBlank = used;
                }
                sb.setLength(lastNonBlank);
                return sb.toString();
            }
        }
        return null;
    }

    public char getChar(int fnum) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return '\u0000';
        }
        short[] metaData = this.tbl.getMetaData();
        int k = (fnum - 1) * 3;
        short off = metaData[k + 1];
        short len = metaData[k + 2];
        switch (metaData[k]) {
            case 5: {
                if (this.strings[off] == null || this.strings[off].length() <= 0) break;
                return this.strings[off].charAt(0);
            }
            case 13: 
            case 21: {
                return (char)this.buffer[off];
            }
        }
        return '\u0000';
    }

    public boolean hasString(int fnum) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return false;
        }
        short[] metaData = this.tbl.getMetaData();
        int k = (fnum - 1) * 3;
        short off = metaData[k + 1];
        short len = metaData[k + 2];
        switch (metaData[k]) {
            case 5: {
                if (this.strings[off] == null || this.strings[off].length() <= 0) break;
                return true;
            }
            case 13: 
            case 21: {
                if (this.buffer[off] == 32) break;
                return true;
            }
        }
        return false;
    }

    public double getFloat(int fnum) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return 0.0;
        }
        short[] metaData = this.tbl.getMetaData();
        int k = (fnum - 1) * 3;
        short off = metaData[k + 1];
        switch (metaData[k]) {
            case 6: 
            case 9: {
                return TBLTable.getDouble(this.buffer, (int)off);
            }
        }
        return 0.0;
    }

    public DomainBitString getBitString(int fnum) {
        int k;
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return null;
        }
        short[] metaData = this.tbl.getMetaData();
        if (metaData[k = (fnum - 1) * 3] != 17) {
            return null;
        }
        short off = metaData[k + 1];
        short len = metaData[k + 2];
        return new DomainBitString(this.buffer, off, len);
    }

    public void setBit(int fnum, int bnum, boolean bval) {
        int k;
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return;
        }
        short[] metaData = this.tbl.getMetaData();
        if (metaData[k = (fnum - 1) * 3] != 17) {
            return;
        }
        short off = metaData[k + 1];
        short len = metaData[k + 2];
        if (bnum < 0 || bnum >= len * 8) {
            return;
        }
        int bix = off + bnum / 8;
        int boff = bnum % 8;
        int btest = this.buffer[bix] & 0xFF;
        btest = bval ? (btest |= DomainBitString.mask[boff]) : (btest &= DomainBitString.unmask[boff]);
        this.buffer[bix] = (byte)btest;
    }

    public void emptyKey() {
        this.brbuf = new byte[this.tbl.getBranchLength()];
        Arrays.fill(this.brbuf, (byte)0);
    }

    public void putIntegerKey(int fnum, int kval) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return;
        }
        short[] metaData = this.tbl.getMetaData();
        int k = (fnum - 1) * 3;
        short off = metaData[k + 1];
        switch (metaData[k]) {
            case 1: {
                this.brbuf[off] = (byte)kval;
                break;
            }
            case 2: {
                TBLTable.putShort(this.brbuf, (int)off, (short)kval);
                break;
            }
            case 3: {
                TBLTable.putMedium(this.brbuf, (int)off, kval);
                break;
            }
            case 4: {
                TBLTable.putLong(this.brbuf, (int)off, (long)kval);
                break;
            }
            case 7: {
                TBLTable.putLong(this.brbuf, (int)off, (long)kval);
            }
        }
    }

    public void putStringKey(int fnum, String sval) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return;
        }
        int k = (fnum - 1) * 3;
        short[] metaData = this.tbl.getMetaData();
        int off = metaData[k + 1];
        int len = metaData[k + 2];
        switch (metaData[k]) {
            case 13: 
            case 21: {
                if (sval == null) {
                    Arrays.fill(this.brbuf, off, off + len, (byte)32);
                    break;
                }
                byte[] sbuf = sval.getBytes();
                int i2 = 0;
                for (int slen = sbuf.length; slen > 0 && len > 0; --len, --slen) {
                    this.brbuf[off++] = sbuf[i2++];
                }
                while (len > 0) {
                    this.brbuf[off++] = 32;
                    --len;
                }
                break;
            }
        }
    }

    public void putCharKey(int fnum, char cval) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return;
        }
        int k = (fnum - 1) * 3;
        short[] metaData = this.tbl.getMetaData();
        short off = metaData[k + 1];
        short len = metaData[k + 2];
        switch (metaData[k]) {
            case 13: 
            case 21: {
                this.brbuf[off] = (byte)cval;
                if (len <= 1) break;
                Arrays.fill(this.brbuf, off + 1, off + len, (byte)32);
            }
        }
    }

    public void putInteger(int fnum, int kval) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return;
        }
        short[] metaData = this.tbl.getMetaData();
        int k = (fnum - 1) * 3;
        short off = metaData[k + 1];
        switch (metaData[k]) {
            case 1: {
                this.buffer[off] = (byte)kval;
                break;
            }
            case 2: {
                TBLTable.putShort(this.buffer, (int)off, (short)kval);
                break;
            }
            case 3: {
                TBLTable.putMedium(this.buffer, (int)off, kval);
                break;
            }
            case 4: {
                TBLTable.putLong(this.buffer, (int)off, (long)kval);
                break;
            }
            case 7: {
                TBLTable.putLong(this.buffer, (int)off, (long)kval);
            }
        }
    }

    public void putString(int fnum, String sval) {
        if (fnum < 1 || fnum > this.tbl.getColumns()) {
            return;
        }
        int k = (fnum - 1) * 3;
        short[] metaData = this.tbl.getMetaData();
        int off = metaData[k + 1];
        int len = metaData[k + 2];
        switch (metaData[k]) {
            case 5: {
                this.strings[off] = sval;
                break;
            }
            case 13: 
            case 21: {
                if (sval == null) {
                    Arrays.fill(this.buffer, off, off + len, (byte)32);
                    break;
                }
                byte[] sbuf = sval.getBytes();
                int i2 = 0;
                for (int slen = sbuf.length; slen > 0 && len > 0; --len, --slen) {
                    this.buffer[off++] = sbuf[i2++];
                }
                while (len > 0) {
                    this.buffer[off++] = 32;
                    --len;
                }
                break;
            }
        }
    }
}

