/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.ec.EcUtil;
import com.mmmhis.domain.table.TBLCursor;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.table.TBLLookupStack;
import com.mmmhis.domain.table.TBLPage;
import com.mmmhis.domain.table.TBLRow;
import com.mmmhis.domain.table.TBLSpace;
import com.mmmhis.domain.table.TBLStruct;
import java.util.Arrays;

public final class TBLTable {
    public static final int TblFind_CREATE = 1;
    public static final int TblFind_TAG = 2;
    public static final int TblFind_INSERT = 4;
    public static final int TblBLKFLAG_DIRTY = 1;
    public static final int TblBLKFLAG_HOLD = 2;
    public static final int TblSAVE_ITEM_VERSN = 5;
    public static final int TblSAVE_ITEM_FILE = 1;
    public static final int TblSAVE_ITEM_SECT = 2;
    public static final int TblSAVE_ITEM_TABLE = 3;
    public static final int TblSAVE_ITEM_LAYOUT = 4;
    public static final int TblSAVE_ITEM_STRUCT = 5;
    public static final int TblSAVE_ITEM_ARRAY = 6;
    public static final int TblSAVE_ITEM_COLUMN = 7;
    public static final int TblSAVE_FILE_ID = 0;
    public static final int TblSAVE_FILE_VERSN = 1;
    public static final int TblSAVE_FILE_PAGE = 2;
    public static final int TblSAVE_FILE_SECT = 4;
    public static final int TblSAVE_FILE_AVAIL = 8;
    public static final int TblSAVE_FILE_LEFT = 12;
    public static final int TblSAVE_FILE_PROTO = 14;
    public static final int TblSAVE_FILE_RECLEN = 18;
    public static final int TblSAVE_SECT_ID = 0;
    public static final int TblSAVE_SECT_NEXT = 1;
    public static final int TblSAVE_SECT_PARENT = 5;
    public static final int TblSAVE_SECT_KIDS = 9;
    public static final int TblSAVE_SECT_TAGS = 13;
    public static final int TblSAVE_SECT_TABLE = 17;
    public static final int TblSAVE_SECT_NAME = 21;
    public static final int TblSAVE_SECT_RECLEN = 22;
    public static final int TblSAVE_TABLE_ID = 0;
    public static final int TblSAVE_TABLE_ROOT = 1;
    public static final int TblSAVE_TABLE_TYPE = 5;
    public static final int TblSAVE_TABLE_LEAF = 6;
    public static final int TblSAVE_TABLE_SOFF = 8;
    public static final int TblSAVE_TABLE_SCNT = 10;
    public static final int TblSAVE_TABLE_BLEN = 12;
    public static final int TblSAVE_TABLE_KLEN = 14;
    public static final int TblSAVE_TABLE_FLAG = 16;
    public static final int TblSAVE_TABLE_SID = 18;
    public static final int TblSAVE_TABLE_RECS = 20;
    public static final int TblSAVE_TABLE_LAYO = 24;
    public static final int TblSAVE_TABLE_MAST = 28;
    public static final int TblSAVE_TABLE_INDX = 32;
    public static final int TblSAVE_TABLE_NCOL = 36;
    public static final int TblSAVE_TABLE_FLEN = 38;
    public static final int TblSAVE_TABLE_FORM = 40;
    public static final int TblSAVE_TABLE_DRECS = 44;
    public static final int TblSAVE_TABLE_RECLEN = 48;
    public static final int TblSAVE_FORMAT_MAX = 1000;
    public static final int TblSAVE_STRU_CODE = 0;
    public static final int TblSAVE_STRU_NEXT = 1;
    public static final int TblSAVE_STRU_BACK = 5;
    public static final int TblSAVE_STRU_COMP = 9;
    public static final int TblSAVE_STRU_TYPE = 13;
    public static final int TblSAVE_STRU_ELEM = 14;
    public static final int SAVE_STRU_OFF = 16;
    public static final int SAVE_STRU_LEN = 18;
    public static final int SAVE_STRU_MASK = 20;
    public static final int SAVE_STRU_DT = 21;
    public static final int SAVE_STRU_ISTR = 22;
    public static final int SAVE_STRU_NSTR = 24;
    public static final int SAVE_STRU_ICOL = 26;
    public static final int SAVE_STRU_NCOL = 28;
    public static final int SAVE_STRU_PREC = 30;
    public static final int SAVE_STRU_SRCO = 31;
    public static final int SAVE_STRU_SRCS = 33;
    public static final int SAVE_STRU_SRCC = 35;
    public static final int SAVE_STRU_NAME = 37;
    public static final int SAVE_STRU_RECLEN = 38;
    public static final int TblDT_END = 0;
    public static final int TblDT_INT1 = 1;
    public static final int TblDT_INT2 = 2;
    public static final int TblDT_INT3 = 3;
    public static final int TblDT_INT4 = 4;
    public static final int TblDT_STRING = 5;
    public static final int TblDT_FLOAT = 6;
    public static final int TblDT_DATE = 7;
    public static final int TblDT_CODE = 8;
    public static final int TblDT_CURRENCY = 9;
    public static final int TblDT_BIT = 10;
    public static final int TblDT_STRUCT = 11;
    public static final int TblDT_ARRAY = 12;
    public static final int TblDT_CHAR = 13;
    public static final int TblDT_RECNO = 14;
    public static final int TblDT_IPART = 15;
    public static final int TblDT_KCHAR = 16;
    public static final int TblDT_BITSTR = 17;
    public static final int TblDT_LAYOUT = 18;
    public static final int TblDT_IXNAME = 19;
    public static final int TblDT_IXCOPY = 20;
    public static final int TblDT_FSTRING = 21;
    public static final int TBL_LOOKUP_MAXDEPTH = 32;
    public static final int TBL_RECNO_BRANCH_LENGTH = 8;
    TBLFile file;
    int rootOffset;
    int address;
    int[] xlate;
    int recCount;
    int delCount;
    int tblType;
    int tblFlags;
    int leafRowLen;
    int brRowLen;
    int strOff;
    int strCount;
    int keyLen;
    int numCols;
    int formLen;
    int strucId;
    int defAddress;
    int colCount;
    byte[] colForm;
    short[] metaData;
    TBLStruct layout;
    TBLStruct curpar;
    TBLTable master;
    TBLTable nextIndex;
    TBLTable lastIndex;
    public static final int TblDont_Save_In_Parent = 0;
    public static final int TblSave_In_Parent_Next = 1;
    public static final int TblSave_In_Parent_Components = 2;

    public TBLTable() {
    }

    public TBLTable(TBLFile tblFile, int defAddr) throws DomainException {
        short flags;
        int indexOff;
        this.file = tblFile;
        this.defAddress = defAddr;
        TBLSpace space = this.file.referSpace(this.defAddress);
        TBLPage recPage = space.page;
        int rec = space.offset;
        if (recPage.mappedBuffer != null) {
            if (recPage.mappedBuffer.getByte(rec + 0) != 3) {
                throw new DomainException("No table in section");
            }
            this.rootOffset = (int)TBLTable.getLong(recPage.mappedBuffer, rec + 1);
            this.leafRowLen = TBLTable.getShort(recPage.mappedBuffer, rec + 6);
            this.strOff = TBLTable.getShort(recPage.mappedBuffer, rec + 8);
            this.strCount = TBLTable.getShort(recPage.mappedBuffer, rec + 10);
            this.recCount = (int)TBLTable.getLong(recPage.mappedBuffer, rec + 20);
            this.formLen = TBLTable.getShort(recPage.mappedBuffer, rec + 38);
            indexOff = (int)TBLTable.getLong(recPage.mappedBuffer, rec + 32);
            flags = TBLTable.getShort(recPage.mappedBuffer, rec + 16);
        } else {
            if (recPage.unmappedBuffer[rec + 0] != 3) {
                throw new DomainException("No table in section");
            }
            this.rootOffset = (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 1);
            this.leafRowLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 6);
            this.strOff = TBLTable.getShort(recPage.unmappedBuffer, rec + 8);
            this.strCount = TBLTable.getShort(recPage.unmappedBuffer, rec + 10);
            this.recCount = (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 20);
            this.formLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 38);
            indexOff = (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 32);
            flags = TBLTable.getShort(recPage.unmappedBuffer, rec + 16);
        }
        if ((flags & 0x80) != 128) {
            throw new DomainException("Table is not clustered");
        }
        if (this.formLen <= 0) {
            throw new DomainException("Table has no format information");
        }
        this.colForm = new byte[this.formLen];
        int need = this.formLen;
        int fmtIndex = 0;
        int fmtAddress = recPage.mappedBuffer != null ? (int)TBLTable.getLong(recPage.mappedBuffer, rec + 40) : (int)TBLTable.getLong(recPage.unmappedBuffer, rec + 40);
        while (need != 0) {
            if (fmtAddress == 0) {
                throw new DomainException("Table format array incomplete");
            }
            space = this.file.referSpace(fmtAddress);
            recPage = space.page;
            rec = space.offset;
            if (rec == 0) {
                throw new DomainException("Table format array corrupted");
            }
            if (recPage.mappedBuffer != null) {
                fmtAddress = (int)TBLTable.getLong(recPage.mappedBuffer, rec);
                if (need <= 1000) {
                    DomainByteArrayFileMap.arraycopy(recPage.mappedBuffer, rec + 4, this.colForm, fmtIndex, need);
                    need = 0;
                    continue;
                }
                DomainByteArrayFileMap.arraycopy(recPage.mappedBuffer, rec + 4, this.colForm, fmtIndex, 1000);
                need -= 1000;
                fmtIndex += 1000;
                continue;
            }
            fmtAddress = (int)TBLTable.getLong(recPage.unmappedBuffer, rec);
            if (need <= 1000) {
                System.arraycopy(recPage.unmappedBuffer, rec + 4, this.colForm, fmtIndex, need);
                need = 0;
                continue;
            }
            System.arraycopy(recPage.unmappedBuffer, rec + 4, this.colForm, fmtIndex, 1000);
            need -= 1000;
            fmtIndex += 1000;
        }
        space = this.file.referSpace(indexOff);
        recPage = space.page;
        rec = space.offset;
        if (recPage.mappedBuffer != null) {
            if (recPage.mappedBuffer.getByte(rec + 0) != 3) {
                throw new DomainException("No index for clustered table");
            }
            this.tblType = recPage.mappedBuffer.getByte(rec + 5);
            this.brRowLen = TBLTable.getShort(recPage.mappedBuffer, rec + 12);
            this.keyLen = TBLTable.getShort(recPage.mappedBuffer, rec + 14);
        } else {
            if (recPage.unmappedBuffer[rec + 0] != 3) {
                throw new DomainException("No index for clustered table");
            }
            this.tblType = recPage.unmappedBuffer[rec + 5];
            this.brRowLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 12);
            this.keyLen = TBLTable.getShort(recPage.unmappedBuffer, rec + 14);
        }
        this.makeMetaData();
    }

    public TBLStruct getLayout() {
        return this.layout;
    }

    public TBLFile getFile() {
        return this.file;
    }

    public int getRecordCount() {
        return this.recCount;
    }

    public int getRootOffset() {
        return this.rootOffset;
    }

    public int getRowLength() {
        return this.leafRowLen;
    }

    public int getBranchLength() {
        return this.brRowLen;
    }

    public int getKeyLength() {
        return this.keyLen;
    }

    public int getColumns() {
        return this.colCount;
    }

    public int getStrOffset() {
        return this.strOff;
    }

    public int getStrCount() {
        return this.strCount;
    }

    public int getType() {
        return this.tblType;
    }

    public boolean isReadOnly() {
        return this.file.isReadOnly();
    }

    public short[] getMetaData() {
        return this.metaData;
    }

    public TBLTable getNextIndex() {
        return this.nextIndex;
    }

    public int getTblFlags() {
        return this.tblFlags;
    }

    public int TblCheckTable() {
        int rc;
        TBLStruct LayOut;
        if ((this.tblFlags & 4) == 0) {
            if (this.layout != this.curpar) {
                return 21;
            }
            LayOut = this.layout;
            rc = LayOut.TblRowLayout();
            if (rc != 0) {
                return rc;
            }
            this.numCols = LayOut.numcol;
            this.strCount = LayOut.numstr;
            this.brRowLen = 8;
            this.keyLen = 4;
            this.strOff = LayOut.length;
            this.leafRowLen = LayOut.length + (this.strCount != 0 ? 4 : 1);
            this.tblFlags |= 4;
            if (this.leafRowLen > this.file.pageSize - 16) {
                return 47;
            }
            rc = this.TblMakeColForm();
            if (rc != 0) {
                return rc;
            }
            this.tblFlags |= 0x10;
        }
        TBLTable indx = this.nextIndex;
        while (indx != null) {
            if ((indx.tblFlags & 4) == 0) {
                LayOut = indx.layout;
                rc = LayOut.TblRowLayout();
                if (rc != 0) {
                    return rc;
                }
                indx.keyLen = LayOut.length;
                TBLStruct key = indx.newTBLStruct(6, new DomainString("Recno"));
                TBLStruct.Add(LayOut, null, LayOut.components, key);
                key.offset = LayOut.length;
                key.datatype = 14;
                key.length = 4;
                LayOut.length += 4;
                indx.numCols = LayOut.numcol;
                indx.leafRowLen = LayOut.length;
                indx.brRowLen = LayOut.length;
                indx.tblFlags |= 4;
                rc = indx.TblMakeColForm();
                if (rc != 0) {
                    return rc;
                }
                indx.tblFlags |= 0x10;
            }
            indx = indx.nextIndex;
        }
        return 0;
    }

    public int TblMakeColForm() throws DomainException {
        int index = 0;
        if (this.numCols == 0) {
            return 41;
        }
        int len = (this.tblFlags & 8) != 0 ? 0 : 2 + this.layout.name.length();
        this.formLen = 4 + len + this.layout.TblFormatCount(len);
        byte[] fmt = new byte[this.formLen];
        this.colForm = fmt;
        fmt[index++] = 18;
        TBLTable.putShort(fmt, index, (short)this.numCols);
        index += 2;
        if (len != 0) {
            fmt[index++] = 19;
            fmt[index++] = (byte)(len -= 2);
            System.arraycopy(this.layout.name.toByteArray(), 0, fmt, index, len);
            index += len;
        }
        if ((index = this.layout.TblFillColForm(fmt, index, len)) != this.formLen - 1) {
            throw new DomainException("ASSERT((fmt - table->colForm) == (table->formLen-1))");
        }
        fmt[index] = 0;
        return 0;
    }

    public int modifiedTable() throws DomainException {
        if ((this.tblFlags & 2) == 2) {
            return 0;
        }
        TBLSpace space = this.file.referSpace(this.address);
        int rec = space.offset;
        TBLPage recPage = space.page;
        if (rec == 0) {
            return 40;
        }
        if (recPage.mappedBuffer != null) {
            TBLTable.putShort(recPage.mappedBuffer, rec + 16, (short)(this.tblFlags & 0x178C));
            if ((this.tblFlags & 0x1000) == 4096) {
                TBLTable.putLong(recPage.mappedBuffer, rec + 20, (long)this.recCount);
                TBLTable.putLong(recPage.mappedBuffer, rec + 44, (long)this.delCount);
            } else {
                TBLTable.putLong(recPage.mappedBuffer, rec + 20, (long)(this.recCount - this.delCount));
            }
        } else {
            TBLTable.putShort(recPage.unmappedBuffer, rec + 16, (short)(this.tblFlags & 0x178C));
            if ((this.tblFlags & 0x1000) == 4096) {
                TBLTable.putLong(recPage.unmappedBuffer, rec + 20, (long)this.recCount);
                TBLTable.putLong(recPage.unmappedBuffer, rec + 44, (long)this.delCount);
            } else {
                TBLTable.putLong(recPage.unmappedBuffer, rec + 20, (long)(this.recCount - this.delCount));
            }
        }
        recPage.modifiedPage();
        return 0;
    }

    public void delete() {
        TBLTable index = this.nextIndex;
        while (index != null) {
            TBLTable next = index.nextIndex;
            if (index.colForm != null) {
                this.colForm = null;
            }
            if (index.layout != null) {
                index.layout.delete();
            }
            index = next;
        }
        if (this.colForm != null) {
            this.colForm = null;
        }
        if ((this.tblFlags & 0x20) == 32) {
            TBLFile tblFile = this.file;
            if (tblFile.dbh != null) {
                tblFile.dbh = null;
            }
            if (tblFile.pageTrans != null) {
                tblFile.pageTrans = null;
            }
            Object var3_3 = null;
        }
        if (this.layout != null) {
            this.layout.delete();
        }
    }

    public TBLTable TblIndexNew(DomainString name) throws DomainException {
        TBLFile tblfile = this.file;
        if (tblfile == null) {
            throw new DomainException("ASSERT(tblfile)");
        }
        TBLTable index = new TBLTable();
        index.file = tblfile;
        index.xlate = this.xlate;
        index.master = this;
        if (this.lastIndex != null) {
            this.lastIndex.nextIndex = index;
        } else {
            this.nextIndex = index;
        }
        this.lastIndex = index;
        if (name != null && name.length() != 0) {
            index.curpar = index.layout = index.newTBLStruct(3, name);
        }
        index.createRoot();
        return index;
    }

    public TBLTable findIndex(String name) {
        int len = name.length();
        char[] nameArr = name.toCharArray();
        TBLTable index = this.nextIndex;
        while (index != null) {
            if (index.layout != null) {
                if (index.layout.name.equals(name)) {
                    return index;
                }
            } else if (index.colForm != null && index.colForm[3] == 19 && index.colForm[4] == (char)len) {
                boolean found = true;
                byte[] idx = EcUtil.getConvertedCharSet(index.colForm, this.file.getEncoding());
                int i2 = 0;
                int j = 5;
                while (i2 < len) {
                    if (idx[j] != nameArr[i2]) {
                        found = false;
                        break;
                    }
                    ++i2;
                    ++j;
                }
                if (found) {
                    return index;
                }
            }
            index = index.nextIndex;
        }
        return null;
    }

    public byte[] getFormatArray() {
        return this.colForm;
    }

    public static int flt2Int(double f, int prec) {
        while (prec > 0) {
            f *= 10.0;
            --prec;
        }
        while (prec < 0) {
            f /= 10.0;
            ++prec;
        }
        return (int)f;
    }

    public static char convertChar(int textChar, int[] cnvt) {
        return (char)(cnvt == null ? textChar : cnvt[textChar & 0xFF]);
    }

    public int lookupDuplicate(byte[] pkey, TBLLookupStack rStack, boolean inserting) throws DomainException {
        return this.lookupDuplicate(null, pkey, rStack, inserting);
    }

    public int lookupDuplicate(DBControl dbControl, byte[] pkey, TBLLookupStack rStack, boolean inserting) throws DomainException {
        int diff = 0;
        int mid = 0;
        boolean zigzag = false;
        TBLFile tblfile = this.file;
        int keyl = (this.tblFlags & 0x80) == 128 ? this.nextIndex.keyLen : this.keyLen;
        int brlen = (this.tblFlags & 0x80) == 128 ? this.nextIndex.brRowLen : this.brRowLen;
        rStack.ix = 0;
        rStack.recno = 0;
        TBLPage cur = tblfile.absolutePage(this.rootOffset);
        while (true) {
            int roff;
            int kptr;
            int lrecl;
            diff = 1;
            int numkeys = cur.getPageRecords();
            int n = lrecl = cur.isLeaf() ? this.leafRowLen : brlen;
            if (numkeys <= 4) {
                if (numkeys == 0) {
                    return 6;
                }
                kptr = cur.body;
                if (cur.mappedBuffer != null) {
                    for (mid = 0; mid < numkeys && (diff = TBLTable.byteCmp(pkey, 0, cur.mappedBuffer, kptr, keyl)) > 0; ++mid) {
                        kptr += lrecl;
                    }
                } else {
                    for (mid = 0; mid < numkeys && (diff = TBLTable.byteCmp(pkey, 0, cur.unmappedBuffer, kptr, keyl)) > 0; ++mid) {
                        kptr += lrecl;
                    }
                }
            } else {
                int bot = 0;
                int top = numkeys;
                if (cur.mappedBuffer != null) {
                    while ((diff = TBLTable.byteCmp(pkey, 0, cur.mappedBuffer, kptr = cur.body + lrecl * (mid = (bot + top) / 2), keyl)) != 0 && top - bot > 1) {
                        if (diff < 0) {
                            top = mid;
                            continue;
                        }
                        bot = mid;
                    }
                    if (diff <= 0) {
                        while (kptr > cur.body && TBLTable.byteCmp(cur.mappedBuffer, kptr, cur.mappedBuffer, kptr - lrecl, keyl) == 0) {
                            kptr -= lrecl;
                        }
                    }
                } else {
                    while ((diff = TBLTable.byteCmp(pkey, 0, cur.unmappedBuffer, kptr = cur.body + lrecl * (mid = (bot + top) / 2), keyl)) != 0 && top - bot > 1) {
                        if (diff < 0) {
                            top = mid;
                            continue;
                        }
                        bot = mid;
                    }
                    if (diff <= 0) {
                        while (kptr > cur.body && TBLTable.byteCmp(cur.unmappedBuffer, kptr, cur.unmappedBuffer, kptr - lrecl, keyl) == 0) {
                            kptr -= lrecl;
                        }
                    }
                }
            }
            if (diff > 0) {
                if (mid < numkeys - 1) {
                    kptr += lrecl;
                    diff = -1;
                } else if (cur.isLeaf() && !inserting) {
                    roff = cur.getPageForward();
                    if (roff != 0) {
                        cur = tblfile.absolutePage(roff);
                        kptr = cur.body;
                        diff = cur.mappedBuffer != null ? TBLTable.byteCmp(pkey, 0, cur.mappedBuffer, kptr, keyl) : TBLTable.byteCmp(pkey, 0, cur.unmappedBuffer, kptr, keyl);
                        if (rStack.ix > 0) {
                            int n2 = rStack.ix - 1;
                            rStack.dataOffset[n2] = rStack.dataOffset[n2] + brlen;
                        }
                    }
                } else if (mid < numkeys) {
                    kptr += lrecl;
                }
            }
            if (zigzag) {
                zigzag = false;
                if (diff > 0) {
                    cur = tblfile.absolutePage(rStack.pageOffset[rStack.ix - 1]);
                    kptr = cur.body + rStack.dataOffset[rStack.ix - 1] + brlen;
                    rStack.dataOffset[rStack.ix - 1] = kptr - cur.body;
                    roff = cur.mappedBuffer != null ? (int)TBLTable.getLong(cur.mappedBuffer, kptr - 4) : (int)TBLTable.getLong(cur.unmappedBuffer, kptr - 4);
                    cur = tblfile.absolutePage(roff);
                    continue;
                }
            }
            if (cur.isLeaf()) {
                rStack.dataOffset[rStack.ix] = kptr - cur.body;
                rStack.pageOffset[rStack.ix] = tblfile.getPageOffset(cur);
                if (diff == 0) {
                    return 0;
                }
                if (diff < 0) {
                    return 1;
                }
                return 3;
            }
            if (diff == 0) {
                zigzag = true;
            }
            rStack.dataOffset[rStack.ix] = kptr - cur.body;
            rStack.pageOffset[rStack.ix] = tblfile.getPageOffset(cur);
            ++rStack.ix;
            if (rStack.ix >= 32) {
                return 16;
            }
            roff = cur.mappedBuffer != null ? (int)TBLTable.getLong(cur.mappedBuffer, kptr - 4) : (int)TBLTable.getLong(cur.unmappedBuffer, kptr - 4);
            cur = tblfile.absolutePage(roff);
        }
    }

    public int lookupUnique(byte[] pkey, TBLLookupStack rStack, boolean inserting) throws DomainException {
        return this.lookupUnique(null, pkey, rStack, inserting);
    }

    public int lookupUnique(DBControl dbControl, byte[] pkey, TBLLookupStack rStack, boolean inserting) throws DomainException {
        int brlen;
        int keyl;
        int tbltype;
        int diff = 0;
        int mid = 0;
        TBLFile tblFile = this.file;
        if ((this.tblFlags & 0x80) == 128) {
            tbltype = this.nextIndex.tblType;
            keyl = this.nextIndex.keyLen;
            brlen = this.nextIndex.brRowLen;
        } else {
            tbltype = this.tblType;
            keyl = this.keyLen;
            brlen = this.brRowLen;
        }
        TBLPage cur = tblFile.absolutePage(this.rootOffset);
        rStack.ix = 0;
        rStack.recno = 0;
        while (true) {
            int roff;
            int kptr;
            int lrecl;
            int numkeys = cur.getPageRecords();
            if (cur.isBranch()) {
                lrecl = brlen;
            } else {
                lrecl = this.leafRowLen;
                if (tbltype == 0) {
                    if (numkeys == 0) {
                        return 6;
                    }
                    rStack.pageOffset[rStack.ix] = tblFile.getPageOffset(cur);
                    diff = (int)TBLTable.getLong(pkey, 0) - rStack.recno;
                    kptr = cur.body + diff * lrecl;
                    rStack.dataOffset[rStack.ix] = kptr - cur.body;
                    if (diff >= numkeys) {
                        return 3;
                    }
                    if (diff < 0) {
                        return 1;
                    }
                    return 0;
                }
            }
            diff = 1;
            if (numkeys <= 4) {
                if (numkeys == 0) {
                    return 6;
                }
                kptr = cur.body;
                if (cur.mappedBuffer != null) {
                    for (mid = 0; mid < numkeys && (diff = TBLTable.byteCmp(pkey, 0, cur.mappedBuffer, kptr, keyl)) > 0; ++mid) {
                        kptr += lrecl;
                    }
                } else {
                    for (mid = 0; mid < numkeys && (diff = TBLTable.byteCmp(pkey, 0, cur.unmappedBuffer, kptr, keyl)) > 0; ++mid) {
                        kptr += lrecl;
                    }
                }
            } else {
                int bot = 0;
                int top = numkeys;
                if (cur.mappedBuffer != null) {
                    while ((diff = TBLTable.byteCmp(pkey, 0, cur.mappedBuffer, kptr = cur.body + lrecl * (mid = (bot + top) / 2), keyl)) != 0 && top - bot > 1) {
                        if (diff < 0) {
                            top = mid;
                            continue;
                        }
                        bot = mid;
                    }
                } else {
                    while ((diff = TBLTable.byteCmp(pkey, 0, cur.unmappedBuffer, kptr = cur.body + lrecl * (mid = (bot + top) / 2), keyl)) != 0 && top - bot > 1) {
                        if (diff < 0) {
                            top = mid;
                            continue;
                        }
                        bot = mid;
                    }
                }
            }
            if (diff > 0) {
                if (mid < numkeys - 1) {
                    kptr += lrecl;
                    diff = -1;
                } else if (cur.isLeaf() && !inserting) {
                    roff = cur.getPageForward();
                    if (roff != 0) {
                        cur = tblFile.absolutePage(roff);
                        kptr = cur.body;
                        diff = cur.mappedBuffer != null ? TBLTable.byteCmp(pkey, 0, cur.mappedBuffer, kptr, keyl) : TBLTable.byteCmp(pkey, 0, cur.unmappedBuffer, kptr, keyl);
                        if (rStack.ix > 0) {
                            int n = rStack.ix - 1;
                            rStack.dataOffset[n] = rStack.dataOffset[n] + brlen;
                        }
                    }
                } else if (mid < numkeys) {
                    kptr += lrecl;
                }
            }
            if (cur.isLeaf()) {
                rStack.dataOffset[rStack.ix] = kptr - cur.body;
                rStack.pageOffset[rStack.ix] = tblFile.getPageOffset(cur);
                if (diff == 0) {
                    return 0;
                }
                if (diff < 0) {
                    return 1;
                }
                return 3;
            }
            if (diff == 0) {
                kptr += lrecl;
            }
            if (tbltype == 0 && kptr != cur.body) {
                rStack.recno = cur.mappedBuffer != null ? (int)TBLTable.getLong(cur.mappedBuffer, kptr - lrecl) : (int)TBLTable.getLong(cur.unmappedBuffer, kptr - lrecl);
            }
            rStack.dataOffset[rStack.ix] = kptr - cur.body;
            rStack.pageOffset[rStack.ix] = tblFile.getPageOffset(cur);
            ++rStack.ix;
            if (rStack.ix >= 32) {
                return 16;
            }
            roff = cur.mappedBuffer != null ? (int)TBLTable.getLong(cur.mappedBuffer, kptr - 4) : (int)TBLTable.getLong(cur.unmappedBuffer, kptr - 4);
            cur = tblFile.absolutePage(roff);
        }
    }

    public int lookupConsolidated(TBLCursor cursor, byte[] pkey) {
        int kptr;
        int mid = 0;
        TBLTable table = cursor.index;
        int keyl = table.nextIndex.keyLen;
        int lrecl = table.leafRowLen;
        int numkeys = table.recCount;
        int tbltype = table.nextIndex.tblType;
        TBLPage blk = table.file.absolutePage(table.rootOffset);
        int diff = 1;
        if (numkeys <= 4) {
            kptr = blk.offset;
            if (blk.mappedBuffer != null) {
                for (mid = 0; mid < numkeys && (diff = TBLTable.byteCmp(pkey, 0, blk.mappedBuffer, kptr, keyl)) > 0; ++mid) {
                    kptr += lrecl;
                }
            } else {
                for (mid = 0; mid < numkeys && (diff = TBLTable.byteCmp(pkey, 0, blk.unmappedBuffer, kptr, keyl)) > 0; ++mid) {
                    kptr += lrecl;
                }
            }
        } else {
            int bot = 0;
            int top = numkeys;
            if (blk.mappedBuffer != null) {
                while ((diff = TBLTable.byteCmp(pkey, 0, blk.mappedBuffer, kptr = blk.offset + lrecl * (mid = (bot + top) / 2), keyl)) != 0 && top - bot > 1) {
                    if (diff < 0) {
                        top = mid;
                        continue;
                    }
                    bot = mid;
                }
                if (tbltype == 1 && diff <= 0) {
                    while (kptr > blk.offset && TBLTable.byteCmp(pkey, kptr, blk.mappedBuffer, kptr - lrecl, keyl) == 0) {
                        kptr -= lrecl;
                    }
                }
            } else {
                while ((diff = TBLTable.byteCmp(pkey, 0, blk.unmappedBuffer, kptr = blk.offset + lrecl * (mid = (bot + top) / 2), keyl)) != 0 && top - bot > 1) {
                    if (diff < 0) {
                        top = mid;
                        continue;
                    }
                    bot = mid;
                }
                if (tbltype == 1 && diff <= 0) {
                    while (kptr > blk.offset && TBLTable.byteCmp(pkey, kptr, blk.unmappedBuffer, kptr - lrecl, keyl) == 0) {
                        kptr -= lrecl;
                    }
                }
            }
        }
        if (diff > 0 && mid < numkeys - 1) {
            kptr += lrecl;
            diff = -1;
        }
        if (blk.mappedBuffer != null) {
            while (true) {
                cursor.recno = mid++;
                cursor.ixrowoff = kptr - blk.offset;
                cursor.row = kptr;
                cursor.mappedRowbuf = blk.mappedBuffer;
                cursor.status |= 4;
                if ((blk.mappedBuffer.getByte(kptr + table.strOff) & 0x80) == 0) {
                    if (diff == 0) {
                        return 0;
                    }
                    if (diff < 0) {
                        return 1;
                    }
                    return 3;
                }
                if (mid >= cursor.recno) {
                    return 3;
                }
                diff = TBLTable.byteCmp(pkey, 0, blk.mappedBuffer, kptr += lrecl, keyl);
            }
        }
        while (true) {
            cursor.recno = mid++;
            cursor.ixrowoff = kptr - blk.offset;
            cursor.row = kptr;
            cursor.unmappedRowbuf = blk.unmappedBuffer;
            cursor.status |= 4;
            if ((blk.unmappedBuffer[kptr + table.strOff] & 0x80) == 0) {
                if (diff == 0) {
                    return 0;
                }
                if (diff < 0) {
                    return 1;
                }
                return 3;
            }
            if (mid >= cursor.recno) {
                return 3;
            }
            diff = TBLTable.byteCmp(pkey, 0, blk.unmappedBuffer, kptr += lrecl, keyl);
        }
    }

    private void makeMetaData() {
        short len;
        byte dataType;
        int depth = 0;
        int fmtIndex = 0;
        this.colCount = 0;
        do {
            dataType = this.colForm[fmtIndex++];
            switch (dataType) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    len = this.colForm[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    ++this.colCount;
                    len = TBLTable.getShort(this.colForm, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    len = this.colForm[2];
                    fmtIndex += 3 + len;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    ++this.colCount;
                    break;
                }
                case 8: {
                    break;
                }
                case 15: {
                    fmtIndex += 6;
                    break;
                }
                case 16: {
                    fmtIndex += 6;
                    break;
                }
                case 13: 
                case 21: {
                    ++this.colCount;
                    fmtIndex += 2;
                }
            }
        } while (depth > 0);
        this.metaData = new short[3 * this.colCount];
        depth = 0;
        fmtIndex = 0;
        int rowIndex = 0;
        int rowOffset = 0;
        int stringIndex = 0;
        do {
            dataType = this.colForm[fmtIndex++];
            switch (dataType) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    len = this.colForm[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)rowOffset;
                    len = TBLTable.getShort(this.colForm, fmtIndex);
                    this.metaData[rowIndex++] = len;
                    rowOffset += len;
                    len = TBLTable.getShort(this.colForm, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    len = this.colForm[2];
                    fmtIndex += 3 + len;
                    break;
                }
                case 1: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)rowOffset;
                    this.metaData[rowIndex++] = 1;
                    ++rowOffset;
                    break;
                }
                case 2: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)rowOffset;
                    this.metaData[rowIndex++] = 2;
                    rowOffset += 2;
                    break;
                }
                case 3: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)rowOffset;
                    this.metaData[rowIndex++] = 3;
                    rowOffset += 3;
                    break;
                }
                case 4: 
                case 7: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)rowOffset;
                    this.metaData[rowIndex++] = 4;
                    rowOffset += 4;
                    break;
                }
                case 6: 
                case 9: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)rowOffset;
                    this.metaData[rowIndex++] = 8;
                    rowOffset += 8;
                    break;
                }
                case 5: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)stringIndex;
                    this.metaData[rowIndex++] = 0;
                    ++stringIndex;
                    break;
                }
                case 8: {
                    break;
                }
                case 15: {
                    fmtIndex += 6;
                    break;
                }
                case 16: {
                    fmtIndex += 6;
                    break;
                }
                case 13: 
                case 21: {
                    this.metaData[rowIndex++] = dataType;
                    this.metaData[rowIndex++] = (short)rowOffset;
                    len = TBLTable.getShort(this.colForm, fmtIndex);
                    fmtIndex += 2;
                    this.metaData[rowIndex++] = len;
                    rowOffset += len;
                }
            }
        } while (depth > 0);
    }

    void copyKeys(TBLCursor cursor) {
        int i2;
        for (i2 = 0; i2 < this.keyLen; ++i2) {
            cursor.brbuf[i2] = 0;
        }
        int bufIndex = 0;
        byte[] fmt = this.colForm;
        int fmtIndex = 0;
        int depth = 0;
        int len = 0;
        do {
            byte dt = fmt[fmtIndex++];
            switch (dt) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    len = 1;
                    break;
                }
                case 17: {
                    short off = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += off;
                    break;
                }
                case 15: {
                    len = TBLTable.getShort(fmt, fmtIndex);
                    short off = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += 6;
                    double fval = TBLTable.getDouble(cursor.buffer, bufIndex + off);
                    TBLTable.putLong(cursor.brbuf, bufIndex, (long)TBLTable.flt2Int(fval, len));
                    bufIndex += 4;
                    break;
                }
                case 16: {
                    len = TBLTable.getShort(fmt, fmtIndex);
                    short off = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += 6;
                    DomainString ps = cursor.string[off];
                    char[] chArr = ps.toCharArray();
                    for (i2 = 0; i2 < len && i2 < chArr.length && chArr[i2] != '\u0000'; ++i2) {
                        cursor.brbuf[bufIndex + i2] = (byte)Character.toUpperCase(ps.charAt(i2));
                    }
                    while (i2 < len) {
                        cursor.brbuf[bufIndex + i2] = (byte)TBLTable.convertChar(32, cursor.xlate);
                        ++i2;
                    }
                    bufIndex += len;
                    break;
                }
                case 14: {
                    TBLTable.putLong(cursor.brbuf, bufIndex, (long)cursor.recno);
                    bufIndex += 4;
                    break;
                }
                case 13: 
                case 21: {
                    len = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    len = dt - 1 + 1;
                    break;
                }
                case 7: {
                    len = 4;
                    break;
                }
                case 20: {
                    short off = TBLTable.getShort(fmt, fmtIndex);
                    fmtIndex += 4;
                    if (len != 0) {
                        System.arraycopy(cursor.buffer, off, cursor.brbuf, bufIndex, len);
                    }
                    bufIndex += len;
                    break;
                }
            }
        } while (depth > 0);
    }

    int insertBase(TBLRow record, TBLLookupStack rstack, int lookrc) throws DomainException {
        TBLFile tblfile = this.file;
        int tbltype = (this.tblFlags & 0x80) == 128 ? this.nextIndex.tblType : this.tblType;
        int keylen = (this.tblFlags & 0x80) == 128 ? this.nextIndex.keyLen : this.keyLen;
        boolean isLeaf = true;
        if (lookrc == 6) {
            TBLPage curblk = this.file.absolutePage(this.rootOffset);
            record.putRecordInPage(curblk, curblk.body, isLeaf);
            this.recCount = 1;
            return 0;
        }
        while (true) {
            int slen;
            int ptrrec;
            TBLPage newblk;
            TBLPage curblk = this.file.absolutePage(rstack.pageOffset[rstack.ix]);
            int currec = curblk.body + rstack.dataOffset[rstack.ix];
            if (record.recordFitsInPage(curblk, isLeaf)) {
                record.putRecordInPage(curblk, currec, isLeaf);
                ++this.recCount;
                return 0;
            }
            if (curblk.getBlockOffset() == this.rootOffset) {
                newblk = curblk;
                curblk = this.file.allocPage();
                if (curblk == null) {
                    return 13;
                }
                int pagesize = newblk.getPageSize();
                if (pagesize > tblfile.pageSize) {
                    pagesize = tblfile.pageSize;
                }
                if (newblk.mappedBuffer != null) {
                    DomainByteArrayFileMap.arraycopy(newblk.mappedBuffer, 0, curblk.mappedBuffer, 0, pagesize);
                } else {
                    System.arraycopy(newblk.unmappedBuffer, 0, curblk.unmappedBuffer, 0, pagesize);
                }
                curblk.modifiedPage();
                rstack.ix = 1;
                rstack.dataOffset[0] = 0;
                rstack.pageOffset[0] = newblk.getBlockOffset();
                newblk.initPage(pagesize);
                newblk.setLower(curblk.getBlockOffset());
                newblk.modifiedPage();
            }
            int lrecl = isLeaf ? this.leafRowLen : ((this.tblFlags & 0x80) == 128 ? this.nextIndex.brRowLen : this.brRowLen);
            int numkeys = curblk.getPageRecords();
            int lnk = (numkeys + 1) / 2;
            int hwp = curblk.body + lnk * lrecl;
            if (tbltype == 1) {
                while (true) {
                    if (hwp == curblk.body) {
                        lnk = (numkeys + 1) / 2;
                        hwp = curblk.body + lnk * lrecl;
                        break;
                    }
                    if (curblk.mappedBuffer != null ? TBLTable.byteCmp(curblk.mappedBuffer, hwp, curblk.mappedBuffer, hwp - lrecl, this.keyLen) != 0 : TBLTable.byteCmp(curblk.unmappedBuffer, hwp, curblk.unmappedBuffer, hwp - lrecl, this.keyLen) != 0) break;
                    hwp -= lrecl;
                    --lnk;
                }
            }
            int rnk = numkeys - lnk;
            tblfile.holdPage(curblk);
            newblk = tblfile.allocPage();
            if (newblk == null) {
                return 13;
            }
            tblfile.releasePage(curblk);
            int promoff = newblk.getBlockOffset();
            if (isLeaf) {
                int soff;
                if (rnk != 0) {
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, newblk.mappedBuffer, newblk.body, lrecl * rnk);
                        DomainByteArrayFileMap.fill(curblk.mappedBuffer, hwp, hwp + lrecl * rnk, (byte)0);
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, hwp, newblk.unmappedBuffer, newblk.body, lrecl * rnk);
                        Arrays.fill(curblk.unmappedBuffer, hwp, hwp + lrecl * rnk, (byte)0);
                    }
                    curblk.setRecords(lnk, isLeaf);
                    newblk.setRecords(rnk, isLeaf);
                    curblk.setRowData(lrecl * lnk);
                    newblk.setRowData(lrecl * rnk);
                }
                int tslen = curblk.getPageStrings();
                if (rnk != 0 && tslen != 0) {
                    int sptr;
                    int i2;
                    int smoved;
                    int strbufIndex;
                    int cstrptr = curblk.offset + 4096;
                    int nstrptr = newblk.offset + 4096;
                    byte[] strbuf = new byte[tslen];
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, cstrptr - tslen, strbuf, 0, tslen);
                        strbufIndex = tslen;
                        ptrrec = curblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < lnk; ++i2) {
                            soff = TBLTable.getShort(curblk.mappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(curblk.mappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            DomainByteArrayFileMap.arraycopy(strbuf, sptr, curblk.mappedBuffer, cstrptr -= slen, slen);
                            TBLTable.putShort(curblk.mappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                        curblk.setStrings(smoved);
                        ptrrec = newblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < rnk; ++i2) {
                            soff = TBLTable.getShort(newblk.mappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(newblk.mappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            DomainByteArrayFileMap.arraycopy(strbuf, sptr, newblk.mappedBuffer, nstrptr -= slen, slen);
                            TBLTable.putShort(newblk.mappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, cstrptr - tslen, strbuf, 0, tslen);
                        strbufIndex = tslen;
                        ptrrec = curblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < lnk; ++i2) {
                            soff = TBLTable.getShort(curblk.unmappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(curblk.unmappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            System.arraycopy(strbuf, sptr, curblk.unmappedBuffer, cstrptr -= slen, slen);
                            TBLTable.putShort(curblk.unmappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                        curblk.setStrings(smoved);
                        ptrrec = newblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < rnk; ++i2) {
                            soff = TBLTable.getShort(newblk.unmappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(newblk.unmappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            System.arraycopy(strbuf, sptr, newblk.unmappedBuffer, nstrptr -= slen, slen);
                            TBLTable.putShort(newblk.unmappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                    }
                    newblk.setStrings(smoved);
                }
                if (currec < hwp) {
                    record.putRecordInPage(curblk, currec, isLeaf);
                } else {
                    soff = currec - curblk.body - lrecl * lnk;
                    ptrrec = newblk.body + soff;
                    record.putRecordInPage(newblk, ptrrec, isLeaf);
                }
                ++this.recCount;
                if (tbltype == 0) {
                    TBLTable.putLong(record.brbuf, 0, (long)(rstack.recno + lnk));
                } else if (newblk.mappedBuffer != null) {
                    DomainByteArrayFileMap.arraycopy(newblk.mappedBuffer, newblk.body, record.brbuf, 0, keylen);
                } else {
                    System.arraycopy(newblk.unmappedBuffer, newblk.body, record.brbuf, 0, keylen);
                }
                TBLTable.putLong(record.brbuf, keylen, (long)promoff);
                int fwdpg = curblk.getPageForward();
                if (fwdpg != 0) {
                    TBLPage lnkblk = tblfile.absolutePage(fwdpg);
                    lnkblk.setLower(newblk.getBlockOffset());
                    newblk.setForward(lnkblk.getBlockOffset());
                    lnkblk.modifiedPage();
                }
                curblk.setForward(newblk.getBlockOffset());
                newblk.setLower(curblk.getBlockOffset());
            } else {
                int tomove;
                if (currec < hwp) {
                    ptrrec = hwp - lrecl;
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, ptrrec, record.savebuf, 0, lrecl);
                        if (rnk != 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, newblk.mappedBuffer, newblk.body, rnk * lrecl);
                        }
                        if ((tomove = ptrrec - currec) > 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, currec, curblk.mappedBuffer, currec + lrecl, tomove);
                        }
                        DomainByteArrayFileMap.arraycopy(record.brbuf, 0, curblk.mappedBuffer, currec, lrecl);
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, ptrrec, record.savebuf, 0, lrecl);
                        if (rnk != 0) {
                            System.arraycopy(curblk.unmappedBuffer, hwp, newblk.unmappedBuffer, newblk.body, rnk * lrecl);
                        }
                        if ((tomove = ptrrec - currec) > 0) {
                            System.arraycopy(curblk.unmappedBuffer, currec, curblk.unmappedBuffer, currec + lrecl, tomove);
                        }
                        System.arraycopy(record.brbuf, 0, curblk.unmappedBuffer, currec, lrecl);
                    }
                    System.arraycopy(record.savebuf, 0, record.brbuf, 0, lrecl);
                } else if (currec == hwp) {
                    if (rnk != 0) {
                        if (curblk.mappedBuffer != null) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, newblk.mappedBuffer, newblk.body, rnk * lrecl);
                        } else {
                            System.arraycopy(curblk.unmappedBuffer, hwp, newblk.unmappedBuffer, newblk.body, rnk * lrecl);
                        }
                    }
                } else {
                    int before;
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, record.savebuf, 0, lrecl);
                        before = currec - hwp - lrecl;
                        if (before > 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp + lrecl, newblk.mappedBuffer, newblk.body, before);
                        }
                        DomainByteArrayFileMap.arraycopy(record.brbuf, 0, newblk.mappedBuffer, newblk.body + before, lrecl);
                        tomove = rnk * lrecl - before - lrecl;
                        if (tomove > 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, currec, newblk.mappedBuffer, newblk.body + before + lrecl, tomove);
                        }
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, hwp, record.savebuf, 0, lrecl);
                        before = currec - hwp - lrecl;
                        if (before > 0) {
                            System.arraycopy(curblk.unmappedBuffer, hwp + lrecl, newblk.unmappedBuffer, newblk.body, before);
                        }
                        System.arraycopy(record.brbuf, 0, newblk.unmappedBuffer, newblk.body + before, lrecl);
                        tomove = rnk * lrecl - before - lrecl;
                        if (tomove > 0) {
                            System.arraycopy(curblk.unmappedBuffer, currec, newblk.unmappedBuffer, newblk.body + before + lrecl, tomove);
                        }
                    }
                    System.arraycopy(record.savebuf, 0, record.brbuf, 0, lrecl);
                }
                curblk.setRecords(lnk, isLeaf);
                newblk.setRecords(rnk, isLeaf);
                curblk.setRowData(lrecl * lnk);
                newblk.setRowData(lrecl * rnk);
                if (curblk.mappedBuffer != null) {
                    DomainByteArrayFileMap.arraycopy(record.brbuf, this.keyLen, newblk.mappedBuffer, newblk.lowerpage, 4);
                    TBLTable.putLong(record.brbuf, this.keyLen, (long)promoff);
                    slen = lnk * lrecl;
                    if (slen < 4080) {
                        DomainByteArrayFileMap.fill(curblk.mappedBuffer, curblk.body + slen, 4096, (byte)0);
                    }
                    if ((slen = rnk * lrecl) < 4080) {
                        DomainByteArrayFileMap.fill(newblk.mappedBuffer, newblk.body + slen, 4096, (byte)0);
                    }
                } else {
                    System.arraycopy(record.brbuf, this.keyLen, newblk.unmappedBuffer, newblk.lowerpage, 4);
                    TBLTable.putLong(record.brbuf, this.keyLen, (long)promoff);
                    slen = lnk * lrecl;
                    if (slen < 4080) {
                        Arrays.fill(curblk.unmappedBuffer, curblk.body + slen, 4096, (byte)0);
                    }
                    if ((slen = rnk * lrecl) < 4080) {
                        Arrays.fill(newblk.unmappedBuffer, newblk.body + slen, 4096, (byte)0);
                    }
                }
            }
            curblk.modifiedPage();
            newblk.modifiedPage();
            --rstack.ix;
            isLeaf = false;
        }
    }

    int insertBase(TBLCursor cursor, TBLLookupStack rstack, int lookrc) throws DomainException {
        TBLFile tblfile = this.file;
        int tbltype = (this.tblFlags & 0x80) == 128 ? this.nextIndex.tblType : this.tblType;
        int keylen = (this.tblFlags & 0x80) == 128 ? this.nextIndex.keyLen : this.keyLen;
        boolean isLeaf = true;
        if (lookrc == 6) {
            TBLPage curblk = tblfile.absolutePage(this.rootOffset);
            int rc = cursor.putRecordInPage(this, curblk, curblk.body, isLeaf);
            if (rc != 0) {
                return rc;
            }
            curblk.modifiedPage();
            if ((this.tblFlags & 8) == 8) {
                cursor.pageoff = tblfile.getPageOffset(curblk);
                cursor.rowoff = 0;
            }
            this.recCount = 1;
            return 0;
        }
        if (lookrc == 0 && tbltype == 2) {
            TBLPage curblk = tblfile.absolutePage(rstack.pageOffset[rstack.ix]);
            if (curblk.mappedBuffer != null) {
                TBLTable.putLong(curblk.mappedBuffer, curblk.body + rstack.dataOffset[rstack.ix] + keylen, (long)cursor.recno);
            } else {
                TBLTable.putLong(curblk.unmappedBuffer, curblk.body + rstack.dataOffset[rstack.ix] + keylen, (long)cursor.recno);
            }
            curblk.modifiedPage();
            return 0;
        }
        return this.insertSplit(cursor, rstack, false);
    }

    int insertSplit(TBLCursor cursor, TBLLookupStack rstack, boolean strReplace) {
        TBLFile tblfile = this.file;
        int tbltype = (this.tblFlags & 0x80) == 128 ? this.nextIndex.tblType : this.tblType;
        int keylen = (this.tblFlags & 0x80) == 128 ? this.nextIndex.keyLen : this.keyLen;
        boolean isLeaf = true;
        while (true) {
            int slen;
            int ptrrec;
            TBLPage newblk;
            int rc;
            TBLPage curblk = tblfile.absolutePage(rstack.pageOffset[rstack.ix]);
            int currec = curblk.body + rstack.dataOffset[rstack.ix];
            if (cursor.recordFitsInPage(this, curblk, isLeaf)) {
                rc = cursor.putRecordInPage(this, curblk, currec, isLeaf);
                if (rc != 0) {
                    return rc;
                }
                if (isLeaf) {
                    if ((this.tblFlags & 8) == 8) {
                        cursor.pageoff = tblfile.getPageOffset(curblk);
                        cursor.rowoff = currec - curblk.body;
                    }
                    ++this.recCount;
                }
                return 0;
            }
            if (tblfile.getPageOffset(curblk) == this.rootOffset) {
                newblk = curblk;
                curblk = tblfile.allocPage();
                if (curblk == null) {
                    return 13;
                }
                int pagesize = newblk.getPageSize();
                if (pagesize > tblfile.pageSize) {
                    pagesize = tblfile.pageSize;
                }
                if (newblk.mappedBuffer != null) {
                    DomainByteArrayFileMap.arraycopy(newblk.mappedBuffer, 0, curblk.mappedBuffer, 0, pagesize);
                    currec = curblk.body + (currec - newblk.body);
                    curblk.modifiedPage();
                    rstack.ix = 1;
                    rstack.dataOffset[0] = 0;
                    rstack.pageOffset[0] = tblfile.getPageOffset(newblk);
                    DomainByteArrayFileMap.fill(newblk.mappedBuffer, newblk.body, newblk.getPageSize() - 16, (byte)0);
                } else {
                    System.arraycopy(newblk.unmappedBuffer, 0, curblk.unmappedBuffer, 0, pagesize);
                    currec = curblk.body + (currec - newblk.body);
                    curblk.modifiedPage();
                    rstack.ix = 1;
                    rstack.dataOffset[0] = 0;
                    rstack.pageOffset[0] = tblfile.getPageOffset(newblk);
                    Arrays.fill(newblk.unmappedBuffer, newblk.body, newblk.getPageSize() - 16, (byte)0);
                }
                newblk.setRecords(0, false);
                newblk.setRowData(0);
                newblk.setStrings(0);
                newblk.setForward(0);
                newblk.setLower(tblfile.getPageOffset(curblk));
                newblk.modifiedPage();
            }
            int lrecl = isLeaf ? this.leafRowLen : ((this.tblFlags & 0x80) == 128 ? this.nextIndex.brRowLen : this.brRowLen);
            int numkeys = curblk.getPageRecords();
            boolean packed = false;
            int lnk = numkeys;
            int hwp = curblk.body + lnk * lrecl;
            if (isLeaf && hwp == currec) {
                if ((this.tblFlags & 0x100) == 256) {
                    packed = true;
                } else if ((this.tblFlags & 8) == 8 && (this.tblFlags & 0x80) == 0) {
                    packed = true;
                }
            }
            if (!packed) {
                lnk = (numkeys + 1) / 2;
                hwp = curblk.body + lnk * lrecl;
                if (tbltype == 1) {
                    if (curblk.mappedBuffer != null) {
                        while (true) {
                            if (hwp == curblk.body) {
                                lnk = (numkeys + 1) / 2;
                                hwp = curblk.body + lnk * lrecl;
                            } else if (TBLTable.byteCmp(curblk.mappedBuffer, hwp, curblk.mappedBuffer, hwp - lrecl, keylen) == 0) {
                                hwp -= lrecl;
                                --lnk;
                                continue;
                            }
                            break;
                        }
                    } else {
                        while (true) {
                            if (hwp == curblk.body) {
                                lnk = (numkeys + 1) / 2;
                                hwp = curblk.body + lnk * lrecl;
                                break;
                            }
                            if (TBLTable.byteCmp(curblk.unmappedBuffer, hwp, curblk.unmappedBuffer, hwp - lrecl, keylen) != 0) break;
                            hwp -= lrecl;
                            --lnk;
                        }
                    }
                }
            }
            int rnk = numkeys - lnk;
            tblfile.holdPage(curblk);
            newblk = tblfile.allocPage();
            if (newblk == null) {
                return 13;
            }
            tblfile.releasePage(curblk);
            int promoff = tblfile.getPageOffset(newblk);
            if (isLeaf) {
                int soff;
                if (rnk != 0) {
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, newblk.mappedBuffer, newblk.body, lrecl * rnk);
                        DomainByteArrayFileMap.fill(curblk.mappedBuffer, hwp, hwp + lrecl * rnk, (byte)0);
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, hwp, newblk.unmappedBuffer, newblk.body, lrecl * rnk);
                        Arrays.fill(curblk.unmappedBuffer, hwp, hwp + lrecl * rnk, (byte)0);
                    }
                    curblk.setRecords(lnk, isLeaf);
                    newblk.setRecords(rnk, isLeaf);
                    curblk.setRowData(lrecl * lnk);
                    newblk.setRowData(lrecl * rnk);
                }
                int tslen = curblk.getPageStrings();
                if (rnk != 0 && tslen != 0) {
                    int sptr;
                    int i2;
                    int smoved;
                    int strbufIndex;
                    int cstrptr = curblk.offset + curblk.getPageSize();
                    int nstrptr = newblk.offset + newblk.getPageSize();
                    byte[] strbuf = new byte[tslen];
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, cstrptr - tslen, strbuf, 0, tslen);
                        strbufIndex = tslen;
                        ptrrec = curblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < lnk; ++i2) {
                            soff = TBLTable.getShort(curblk.mappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(curblk.mappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            DomainByteArrayFileMap.arraycopy(strbuf, sptr, curblk.mappedBuffer, cstrptr -= slen, slen);
                            TBLTable.putShort(curblk.mappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                        curblk.setStrings(smoved);
                        ptrrec = newblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < rnk; ++i2) {
                            soff = TBLTable.getShort(newblk.mappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(newblk.mappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            DomainByteArrayFileMap.arraycopy(strbuf, sptr, newblk.mappedBuffer, nstrptr -= slen, slen);
                            TBLTable.putShort(newblk.mappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, cstrptr - tslen, strbuf, 0, tslen);
                        strbufIndex = tslen;
                        ptrrec = curblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < lnk; ++i2) {
                            soff = TBLTable.getShort(curblk.unmappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(curblk.unmappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            System.arraycopy(strbuf, sptr, curblk.unmappedBuffer, cstrptr -= slen, slen);
                            TBLTable.putShort(curblk.unmappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                        curblk.setStrings(smoved);
                        ptrrec = newblk.body;
                        smoved = 0;
                        for (i2 = 0; i2 < rnk; ++i2) {
                            soff = TBLTable.getShort(newblk.unmappedBuffer, ptrrec + this.strOff) & Short.MAX_VALUE;
                            slen = TBLTable.getShort(newblk.unmappedBuffer, ptrrec + this.strOff + 2);
                            sptr = strbufIndex - soff;
                            System.arraycopy(strbuf, sptr, newblk.unmappedBuffer, nstrptr -= slen, slen);
                            TBLTable.putShort(newblk.unmappedBuffer, ptrrec + this.strOff, (short)(smoved += slen));
                            ptrrec += lrecl;
                        }
                    }
                    newblk.setStrings(smoved);
                }
                if (currec < hwp) {
                    cursor.pageoff = tblfile.getPageOffset(curblk);
                    cursor.rowoff = currec - curblk.body;
                    rc = !strReplace ? cursor.putRecordInPage(this, curblk, currec, isLeaf) : cursor.putStringInPage(this, curblk, currec);
                    if (rc != 0) {
                        return rc;
                    }
                } else {
                    soff = currec - curblk.body - lrecl * lnk;
                    ptrrec = newblk.body + soff;
                    cursor.pageoff = tblfile.getPageOffset(newblk);
                    cursor.rowoff = ptrrec - newblk.body;
                    rc = !strReplace ? cursor.putRecordInPage(this, newblk, ptrrec, isLeaf) : cursor.putStringInPage(this, newblk, ptrrec);
                    if (rc != 0) {
                        return rc;
                    }
                }
                if (!strReplace) {
                    ++this.recCount;
                }
                strReplace = false;
                if (tbltype == 0) {
                    TBLTable.putLong(cursor.brbuf, 0, (long)(rstack.recno + lnk));
                } else if (newblk.mappedBuffer != null) {
                    DomainByteArrayFileMap.arraycopy(newblk.mappedBuffer, newblk.body, cursor.brbuf, 0, keylen);
                } else {
                    System.arraycopy(newblk.unmappedBuffer, newblk.body, cursor.brbuf, 0, keylen);
                }
                TBLTable.putLong(cursor.brbuf, 0 + keylen, (long)promoff);
                int fwdpg = curblk.getPageForward();
                if (fwdpg != 0) {
                    TBLPage lnkblk = tblfile.absolutePage(fwdpg);
                    lnkblk.setLower(tblfile.getPageOffset(newblk));
                    newblk.setForward(tblfile.getPageOffset(lnkblk));
                    lnkblk.modifiedPage();
                }
                curblk.setForward(tblfile.getPageOffset(newblk));
                newblk.setLower(tblfile.getPageOffset(curblk));
            } else {
                int tomove;
                if (currec < hwp) {
                    ptrrec = hwp - lrecl;
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, ptrrec, cursor.brbuf, lrecl, lrecl);
                        if (rnk != 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, newblk.mappedBuffer, newblk.body, rnk * lrecl);
                        }
                        if ((tomove = ptrrec - currec) > 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, currec, curblk.mappedBuffer, currec + lrecl, tomove);
                        }
                        DomainByteArrayFileMap.arraycopy(cursor.brbuf, 0, curblk.mappedBuffer, currec, lrecl);
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, ptrrec, cursor.brbuf, lrecl, lrecl);
                        if (rnk != 0) {
                            System.arraycopy(curblk.unmappedBuffer, hwp, newblk.unmappedBuffer, newblk.body, rnk * lrecl);
                        }
                        if ((tomove = ptrrec - currec) > 0) {
                            System.arraycopy(curblk.unmappedBuffer, currec, curblk.unmappedBuffer, currec + lrecl, tomove);
                        }
                        System.arraycopy(cursor.brbuf, 0, curblk.unmappedBuffer, currec, lrecl);
                    }
                    System.arraycopy(cursor.brbuf, lrecl, cursor.brbuf, 0, lrecl);
                } else if (currec == hwp) {
                    if (rnk != 0) {
                        if (curblk.mappedBuffer != null) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, newblk.mappedBuffer, newblk.body, rnk * lrecl);
                        } else {
                            System.arraycopy(curblk.unmappedBuffer, hwp, newblk.unmappedBuffer, newblk.body, rnk * lrecl);
                        }
                    }
                } else {
                    int before;
                    if (curblk.mappedBuffer != null) {
                        DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp, cursor.brbuf, lrecl, lrecl);
                        before = currec - hwp - lrecl;
                        if (before > 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, hwp + lrecl, newblk.mappedBuffer, newblk.body, before);
                        }
                        DomainByteArrayFileMap.arraycopy(cursor.brbuf, 0, newblk.mappedBuffer, newblk.body + before, lrecl);
                        tomove = rnk * lrecl - before - lrecl;
                        if (tomove > 0) {
                            DomainByteArrayFileMap.arraycopy(curblk.mappedBuffer, currec, newblk.mappedBuffer, newblk.body + before + lrecl, tomove);
                        }
                    } else {
                        System.arraycopy(curblk.unmappedBuffer, hwp, cursor.brbuf, lrecl, lrecl);
                        before = currec - hwp - lrecl;
                        if (before > 0) {
                            System.arraycopy(curblk.unmappedBuffer, hwp + lrecl, newblk.unmappedBuffer, newblk.body, before);
                        }
                        System.arraycopy(cursor.brbuf, 0, newblk.unmappedBuffer, newblk.body + before, lrecl);
                        tomove = rnk * lrecl - before - lrecl;
                        if (tomove > 0) {
                            System.arraycopy(curblk.unmappedBuffer, currec, newblk.unmappedBuffer, newblk.body + before + lrecl, tomove);
                        }
                    }
                    System.arraycopy(cursor.brbuf, lrecl, cursor.brbuf, 0, lrecl);
                }
                curblk.setRecords(lnk, isLeaf);
                newblk.setRecords(rnk, isLeaf);
                curblk.setRowData(lrecl * lnk);
                newblk.setRowData(lrecl * rnk);
                if (curblk.mappedBuffer != null) {
                    DomainByteArrayFileMap.arraycopy(cursor.brbuf, keylen, newblk.mappedBuffer, newblk.lowerpage, 4);
                    TBLTable.putLong(cursor.brbuf, keylen, (long)promoff);
                    slen = lnk * lrecl;
                    if (slen < 4096) {
                        DomainByteArrayFileMap.fill(curblk.mappedBuffer, curblk.body + slen, 4096, (byte)0);
                    }
                    if ((slen = rnk * lrecl) < 4096) {
                        DomainByteArrayFileMap.fill(newblk.mappedBuffer, newblk.body + slen, 4096, (byte)0);
                    }
                } else {
                    System.arraycopy(cursor.brbuf, keylen, newblk.unmappedBuffer, newblk.lowerpage, 4);
                    TBLTable.putLong(cursor.brbuf, keylen, (long)promoff);
                    slen = lnk * lrecl;
                    if (slen < 4096) {
                        Arrays.fill(curblk.unmappedBuffer, curblk.body + slen, 4096, (byte)0);
                    }
                    if ((slen = rnk * lrecl) < 4096) {
                        Arrays.fill(newblk.unmappedBuffer, newblk.body + slen, 4096, (byte)0);
                    }
                }
            }
            curblk.modifiedPage();
            newblk.modifiedPage();
            --rstack.ix;
            isLeaf = false;
        }
    }

    static int byteCmp(byte[] buffer, int index, byte[] buffer2, int index2, int len) {
        while (len-- > 0) {
            int diff = (buffer[index] < 0 ? 256 + buffer[index] : buffer[index]) - (buffer2[index2] < 0 ? 256 + buffer2[index2] : buffer2[index2]);
            if (diff != 0) {
                return diff;
            }
            ++index;
            ++index2;
        }
        return 0;
    }

    static int byteCmp(byte[] buffer, int index, DomainByteArrayFileMap buffer2, int index2, int len) {
        byte[] tmpBuffer2 = buffer2.getBytes(index2, len);
        int idx2 = 0;
        while (len-- > 0) {
            int byte2;
            int diff = (buffer[index] < 0 ? 256 + buffer[index] : buffer[index]) - ((byte2 = tmpBuffer2[idx2]) < 0 ? 256 + byte2 : byte2);
            if (diff != 0) {
                return diff;
            }
            ++index;
            ++idx2;
        }
        return 0;
    }

    static int byteCmp(DomainByteArrayFileMap buffer, int index, DomainByteArrayFileMap buffer2, int index2, int len) {
        byte[] tmpBuffer = buffer.getBytes(index, len);
        byte[] tmpBuffer2 = buffer2.getBytes(index2, len);
        int idx = 0;
        int idx2 = 0;
        while (len-- > 0) {
            int byte2;
            int byte1 = tmpBuffer[idx];
            int diff = (byte1 < 0 ? 256 + byte1 : byte1) - ((byte2 = tmpBuffer2[idx2]) < 0 ? 256 + byte2 : byte2);
            if (diff != 0) {
                return diff;
            }
            ++idx;
            ++idx2;
        }
        return 0;
    }

    int restoreLinks(TBLStruct def) {
        while (def != null) {
            switch (def.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int rc = this.restoreLinks(def.components);
                    if (rc == 0) break;
                    return rc;
                }
                case 4: {
                    int rc = this.restoreLinks(def.components);
                    if (rc == 0) break;
                    return rc;
                }
                case 5: {
                    if (def.datatype != 11 && def.datatype != 17) break;
                    def.components = this.layout.find(def.sname);
                    if (def.components == null && this.file.protos != null && this != this.file.protos) {
                        def.components = this.file.protos.layout.find(def.sname);
                    }
                    if (def.components == null) {
                        return 29;
                    }
                    def.sname = null;
                    break;
                }
            }
            def = def.next;
        }
        return 0;
    }

    int createRoot() {
        TBLFile tblfile = this.file;
        TBLPage rootpage = tblfile.allocPage();
        if (rootpage == null) {
            return 12;
        }
        rootpage.modifiedPage();
        this.rootOffset = tblfile.getPageOffset(rootpage);
        return 0;
    }

    TBLStruct newTBLStruct(int type, DomainString name) {
        if (name == null) {
            ++this.strucId;
            DomainString work = new DomainString("_S" + this.strucId);
            if (this.xlate != null) {
                EcUtil.convertCharSet(work.toCharArray(), 0, this.xlate);
            }
            name = work;
        }
        int nameLen = name.length();
        TBLStruct newdef = new TBLStruct();
        newdef.name = name;
        newdef.table = this;
        newdef.type = type;
        newdef.elements = 1;
        newdef.back = this.curpar;
        return newdef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void TblCopyStruct(TBLStruct col, int link, TBLStruct parent) throws DomainException {
        TBLStruct changeLink = parent;
        while (col != null) {
            if (col.type != 3 && (col.type != 6 || col.datatype != 14)) {
                TBLStruct newcol = this.newTBLStruct(col.type, col.name);
                if (link == 1) {
                    if (changeLink == null) throw new DomainException("TblCopyStruct TblSave_In_Parent_Next with parent null");
                    changeLink.next = newcol;
                } else if (link == 2) {
                    if (changeLink == null) throw new DomainException("TblCopyStruct TblSave_In_Parent_Components with parent null");
                    changeLink.components = newcol;
                } else if (link != 0) {
                    throw new DomainException("TblCopyStruct TblSave_In_Parent_Components with parent null");
                }
                newcol.back = parent;
                newcol.elements = col.elements;
                newcol.offset = col.offset;
                newcol.length = col.length;
                newcol.bitmask = col.bitmask;
                newcol.datatype = col.datatype;
                newcol.strix = col.strix;
                newcol.numstr = col.numstr;
                newcol.coloff = col.coloff;
                newcol.numcol = col.numcol;
                newcol.precision = col.precision;
                newcol.srcOffset = col.srcOffset;
                newcol.srcString = col.srcString;
                newcol.srcColumn = col.srcColumn;
                if (col.datatype == 11 || col.datatype == 17) {
                    newcol.sname = new DomainString(col.components.name);
                }
                switch (col.type) {
                    case 1: 
                    case 2: 
                    case 4: {
                        this.TblCopyStruct(col.components, 2, newcol);
                        break;
                    }
                }
                link = 1;
                changeLink = newcol;
            }
            col = col.next;
        }
    }

    public static final byte getByte(byte[] rec, int index) {
        return (byte)(rec[index] & 0xFF);
    }

    public static final byte getByte(DomainByteArrayFileMap rec, int index) {
        return (byte)(rec.getByte(index) & 0xFF);
    }

    public static final void putByte(byte[] rec, int index, byte n) {
        rec[index] = n;
    }

    public static final short getShort(byte[] rec, int index) {
        return (short)((rec[index] & 0xFF) << 8 | rec[index + 1] & 0xFF);
    }

    public static final short getShort(DomainByteArrayFileMap rec, int index) {
        byte[] tmp = rec.getBytes(index, 2);
        return (short)((tmp[0] & 0xFF) << 8 | tmp[1] & 0xFF);
    }

    public static final void putShort(byte[] rec, int index, short x) {
        rec[index + 0] = (byte)(x >> 8);
        rec[index + 1] = (byte)(x >> 0);
    }

    public static final void putShort(DomainByteArrayFileMap rec, int index, short x) {
        byte[] tmp = new byte[]{(byte)(x >> 8), (byte)(x >> 0)};
        rec.putBytes(index, tmp);
    }

    public static final int getMedium(byte[] rec, int index) {
        return ((rec[index + 0] & 0x80) == 128 ? -16777216 : 0) | (rec[index + 0] & 0xFF) << 16 | (rec[index + 1] & 0xFF) << 8 | rec[index + 2] & 0xFF;
    }

    public static final int getMedium(DomainByteArrayFileMap rec, int index) {
        byte[] tmp = rec.getBytes(index, 3);
        return ((tmp[0] & 0x80) == 128 ? -16777216 : 0) | (tmp[0] & 0xFF) << 16 | (tmp[1] & 0xFF) << 8 | tmp[2] & 0xFF;
    }

    public static final void putMedium(byte[] rec, int index, int x) {
        rec[index + 0] = (byte)(x >> 16);
        rec[index + 1] = (byte)(x >> 8);
        rec[index + 2] = (byte)(x >> 0);
    }

    public static final void putMedium(DomainByteArrayFileMap rec, int index, int x) {
        byte[] tmp = new byte[]{(byte)(x >> 16), (byte)(x >> 8), (byte)(x >> 0)};
        rec.putBytes(index, tmp);
    }

    public static final long getLong(byte[] rec, int index) {
        return ((long)rec[index + 0] & 0xFFL) << 24 | ((long)rec[index + 1] & 0xFFL) << 16 | ((long)rec[index + 2] & 0xFFL) << 8 | ((long)rec[index + 3] & 0xFFL) << 0;
    }

    public static final long getLong(DomainByteArrayFileMap rec, int index) {
        byte[] tmp = rec.getBytes(index, 4);
        return ((long)tmp[0] & 0xFFL) << 24 | ((long)tmp[1] & 0xFFL) << 16 | ((long)tmp[2] & 0xFFL) << 8 | ((long)tmp[3] & 0xFFL) << 0;
    }

    public static final void putLong(byte[] rec, int index, long x) {
        rec[index + 0] = (byte)(x >> 24);
        rec[index + 1] = (byte)(x >> 16);
        rec[index + 2] = (byte)(x >> 8);
        rec[index + 3] = (byte)(x >> 0);
    }

    public static final void putLong(DomainByteArrayFileMap rec, int index, long x) {
        byte[] tmp = new byte[]{(byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)(x >> 0)};
        rec.putBytes(index, tmp);
    }

    static final long getDbl(byte[] rec, int index) {
        return ((long)rec[index + 0] & 0xFFL) << 56 | ((long)rec[index + 1] & 0xFFL) << 48 | ((long)rec[index + 2] & 0xFFL) << 40 | ((long)rec[index + 3] & 0xFFL) << 32 | ((long)rec[index + 4] & 0xFFL) << 24 | ((long)rec[index + 5] & 0xFFL) << 16 | ((long)rec[index + 6] & 0xFFL) << 8 | ((long)rec[index + 7] & 0xFFL) << 0;
    }

    static final long getDbl(DomainByteArrayFileMap rec, int index) {
        byte[] tmp = rec.getBytes(index, 8);
        return ((long)tmp[0] & 0xFFL) << 56 | ((long)tmp[1] & 0xFFL) << 48 | ((long)tmp[2] & 0xFFL) << 40 | ((long)tmp[3] & 0xFFL) << 32 | ((long)tmp[4] & 0xFFL) << 24 | ((long)tmp[5] & 0xFFL) << 16 | ((long)tmp[6] & 0xFFL) << 8 | ((long)tmp[7] & 0xFFL) << 0;
    }

    public static final void putDbl(byte[] rec, int index, long x) {
        rec[index + 0] = (byte)(x >> 56);
        rec[index + 1] = (byte)(x >> 48);
        rec[index + 2] = (byte)(x >> 40);
        rec[index + 3] = (byte)(x >> 32);
        rec[index + 4] = (byte)(x >> 24);
        rec[index + 5] = (byte)(x >> 16);
        rec[index + 6] = (byte)(x >> 8);
        rec[index + 7] = (byte)(x >> 0);
    }

    public static final void putDbl(DomainByteArrayFileMap rec, int index, long x) {
        byte[] tmp = new byte[]{(byte)(x >> 56), (byte)(x >> 48), (byte)(x >> 40), (byte)(x >> 32), (byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)(x >> 0)};
        rec.putBytes(index, tmp);
    }

    public static final double getDouble(byte[] rec, int index) {
        long n = 0L;
        double d = Double.longBitsToDouble(TBLTable.getDbl(rec, index));
        return Math.rint(1.0E14 * d) / 1.0E14;
    }

    public static final double getDouble(DomainByteArrayFileMap rec, int index) {
        long n = 0L;
        double d = Double.longBitsToDouble(TBLTable.getDbl(rec, index));
        return Math.rint(1.0E14 * d) / 1.0E14;
    }

    public static final void putDouble(byte[] rec, int index, double value) {
        TBLTable.putDbl(rec, index, Double.doubleToRawLongBits(value));
    }

    public static final void putDouble(DomainByteArrayFileMap rec, int index, double value) {
        TBLTable.putDbl(rec, index, Double.doubleToRawLongBits(value));
    }

    public static void main(String[] args) {
        byte[] b = new byte[]{63, -11, -50, 7, 95, 111, -46, 34};
        double d = TBLTable.getDouble(b, 0);
    }

    public int numColumns() {
        return this.numCols;
    }

    public int numIndices() {
        int count = 0;
        TBLTable curr = this.nextIndex;
        while (curr != null) {
            ++count;
            curr = curr.nextIndex;
        }
        return count;
    }

    public TBLTable indexFindByOffset(int index) {
        boolean count = false;
        TBLTable curr = this.nextIndex;
        while (curr != null) {
            if (index == 0) {
                return curr;
            }
            --index;
            curr = curr.nextIndex;
        }
        return null;
    }

    public int indexColumns() {
        return this.numCols;
    }

    public DomainString indexName() {
        if (this.layout != null) {
            return this.layout.name;
        }
        if (this.colForm != null && this.colForm[3] == 19) {
            return new DomainString(this.colForm, 5, (int)this.colForm[4]);
        }
        return null;
    }

    public int unloadType(int valueIndex) {
        int depth = 0;
        int fmtIndex = 0;
        byte[] fmt = this.colForm;
        do {
            switch (fmt[fmtIndex++]) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    if (valueIndex-- == 0) {
                        return 12;
                    }
                    short len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    byte rc = fmt[2];
                    fmtIndex += 3 + rc;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (valueIndex-- != 0) break;
                    return 3;
                }
                case 7: {
                    if (valueIndex-- != 0) break;
                    return 7;
                }
                case 6: {
                    if (valueIndex-- != 0) break;
                    return 5;
                }
                case 9: {
                    if (valueIndex-- != 0) break;
                    return 8;
                }
                case 5: {
                    if (valueIndex-- != 0) break;
                    return 4;
                }
                case 8: {
                    break;
                }
                case 15: {
                    if (valueIndex-- == 0) {
                        return 5;
                    }
                    fmtIndex += 6;
                    break;
                }
                case 16: {
                    if (valueIndex-- == 0) {
                        return 4;
                    }
                    fmtIndex += 6;
                    break;
                }
                case 13: {
                    if (valueIndex-- == 0) {
                        return 4;
                    }
                    fmtIndex += 2;
                }
            }
        } while (depth > 0);
        return 0;
    }

    public int unloadWidth(int valueIndex) {
        int depth = 0;
        int fmtIndex = 0;
        byte[] fmt = this.colForm;
        do {
            switch (fmt[fmtIndex++]) {
                case 0: {
                    --depth;
                    break;
                }
                case 18: {
                    fmtIndex += 2;
                    ++depth;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 17: {
                    if (valueIndex-- == 0) {
                        fmtIndex += 4;
                        int bits = 0;
                        while (fmt[fmtIndex] != 0) {
                            ++bits;
                            fmtIndex += 4 + fmt[fmtIndex + 3];
                        }
                        return bits;
                    }
                    short len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 11: 
                case 12: {
                    ++depth;
                    break;
                }
                case 10: {
                    byte rc = fmt[2];
                    fmtIndex += 3 + rc;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (valueIndex-- != 0) break;
                    return 0;
                }
                case 7: {
                    if (valueIndex-- != 0) break;
                    return 0;
                }
                case 6: {
                    if (valueIndex-- != 0) break;
                    return 0;
                }
                case 9: {
                    if (valueIndex-- != 0) break;
                    return 0;
                }
                case 5: {
                    if (valueIndex-- != 0) break;
                    return 0;
                }
                case 8: {
                    break;
                }
                case 15: {
                    if (valueIndex-- == 0) {
                        return 0;
                    }
                    fmtIndex += 6;
                    break;
                }
                case 16: {
                    if (valueIndex-- == 0) {
                        return TBLTable.getShort(fmt, fmtIndex);
                    }
                    fmtIndex += 6;
                    break;
                }
                case 13: {
                    if (valueIndex-- == 0) {
                        return TBLTable.getShort(fmt, fmtIndex);
                    }
                    fmtIndex += 2;
                }
            }
        } while (depth > 0);
        return 0;
    }

    public int getIntLength(int intNum) {
        int intCount = 0;
        int fmtIndex = 0;
        byte[] fmt = this.colForm;
        do {
            switch (fmt[fmtIndex++]) {
                case 3: 
                case 4: {
                    if (intCount == intNum) {
                        return fmt[fmtIndex - 1];
                    }
                    ++intCount;
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: {
                    break;
                }
                case 13: 
                case 18: 
                case 21: {
                    fmtIndex += 2;
                    break;
                }
                case 20: {
                    fmtIndex += 4;
                    break;
                }
                case 15: 
                case 16: {
                    fmtIndex += 6;
                    break;
                }
                case 17: {
                    short len = TBLTable.getShort(fmt, fmtIndex + 2);
                    fmtIndex += len;
                    break;
                }
                case 19: {
                    short len = fmt[fmtIndex++];
                    fmtIndex += len;
                    break;
                }
                case 10: {
                    short len = fmt[2];
                    fmtIndex += 3 + len;
                }
            }
        } while (fmtIndex < this.formLen);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int unCompactStruct(DomainEcNumber ptr, int expected, Object link, TBLStruct parent) {
        TBLStruct prevDef = null;
        while (true) {
            Object object;
            Object object2;
            int idx;
            Object name;
            if (ptr.getMappedData() != null) {
                name = ptr.getMappedData();
                idx = ptr.getOffset();
                if ((object2 = ((DomainByteArrayFileMap)name).getByte(idx++)) == 0) break;
                if (object2 != expected) {
                    return 34;
                }
                object = ((DomainByteArrayFileMap)name).getByte(idx++);
            } else {
                name = ptr.getUnmappedData();
                idx = ptr.getOffset();
                if ((object2 = (Object)name[idx++]) == 0) break;
                if (object2 != expected) {
                    return 34;
                }
                object = name[idx++];
            }
            ptr.incOffset(2);
            DomainString tabName = ptr.getEcString();
            TBLStruct def = this.newTBLStruct((int)object, tabName);
            if (prevDef == null) {
                if (link instanceof TBLTable) {
                    ((TBLTable)link).layout = def;
                } else {
                    if (!(link instanceof TBLStruct)) return 34;
                    ((TBLStruct)link).components = def;
                }
            } else {
                prevDef.next = def;
            }
            def.back = parent;
            def.table = this;
            def.elements = ptr.getEcNumber();
            def.offset = ptr.getEcNumber();
            def.length = ptr.getEcNumber();
            def.bitmask = ptr.getEcNumber();
            def.datatype = ptr.getEcNumber();
            def.strix = ptr.getEcNumber();
            def.numstr = ptr.getEcNumber();
            def.coloff = ptr.getEcNumber();
            def.numcol = ptr.getEcNumber();
            def.precision = ptr.getEcNumber();
            def.srcOffset = ptr.getEcNumber();
            def.srcString = ptr.getEcNumber();
            def.srcColumn = ptr.getEcNumber();
            if (def.type == 5 && (def.datatype == 11 || def.datatype == 17)) {
                tabName = ptr.getEcString();
            }
            switch (def.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int rc = this.unCompactStruct(ptr, 7, def, def);
                    if (rc == 0) break;
                    return rc;
                }
                case 4: {
                    int rc = this.unCompactStruct(ptr, 6, def, def);
                    if (rc == 0) break;
                    return rc;
                }
                case 5: {
                    if (def.datatype != 11 && def.datatype != 17) break;
                    def.sname = new DomainString(tabName);
                    break;
                }
            }
            if (expected == 4) {
                expected = 5;
            }
            prevDef = def;
        }
        ptr.incOffset(1);
        return 0;
    }
}

