/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.td;

import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.td.TDFile;
import com.mmmhis.domain.td.TDSection;
import com.mmmhis.domain.td.TDTag;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;

public final class TDHandle {
    public static final int TdITEM_TAG = 1;
    public static final int TdITEM_STARTSECTION = 2;
    public static final int TdITEM_ENDSECTION = 3;
    public static final int TdITEM_EMPTYLINE = 4;
    public static final int TdITEM_SKIP = 5;
    public static final char TdP_STARTSECTIONNAME = '<';
    public static final char TdP_ENDSECTIONNAME = '>';
    public static final String TdP_ENDSECTIONTEXT = "END";
    public static final String TdP_ENDOFRECORDTEXT = "<EOR>";
    public static final char TdP_TAGDELIMETER = '=';
    public static final char TdP_LINECOMMENT = '%';
    public static final char TdP_EOLMARKER = '\n';
    TDSection section;
    TDTag tag;
    TDFile file;

    public void setSection(TDSection section) {
        this.section = section;
    }

    public TDSection getSection() {
        return this.section;
    }

    public void setTag(TDTag tag) {
        this.tag = tag;
    }

    public TDTag getTag() {
        return this.tag;
    }

    public TDFile getFile() {
        return this.file;
    }

    public void setFile(TDFile tdFile) {
        this.file = tdFile;
    }

    public void attachFile(TDFile resFile) {
        this.file = resFile;
        this.section = resFile.root;
    }

    public TDFile detachFile() {
        return this.file;
    }

    public void deleteHandle() {
        this.section = null;
        this.tag = null;
        this.file = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int parseLine(ParseResult result) {
        int end;
        int begin;
        int len;
        String line;
        int status = 0;
        block6: while (true) {
            line = null;
            try {
                line = ((BufferedReader)result.reader).readLine();
                if (line == null) return 102;
                if (line.length() == 1 && line.charAt(0) == '\u0000') {
                    return 102;
                }
            }
            catch (IOException ex) {
                return 110;
            }
            len = line.length();
            if (len == 0) continue;
            end = begin = 0;
            while (begin < len && Character.isWhitespace(line.charAt(begin))) {
                ++begin;
            }
            for (end = begin; end < len && !Character.isWhitespace(line.charAt(end)); ++end) {
            }
            if (line.substring(begin, end).toUpperCase().equals(result.eorTag)) {
                while (end < len && !Character.isWhitespace(line.charAt(end))) {
                    ++end;
                }
                if (end == len) {
                    return 103;
                }
            }
            end = begin;
            if (begin >= len) continue;
            switch (line.charAt(begin)) {
                case '%': {
                    continue block6;
                }
                case '<': {
                    if (end >= len) return 101;
                    if (line.charAt(end) == File.separatorChar) {
                        return 101;
                    }
                    for (end = ++begin; end < len && line.charAt(end) != '>'; ++end) {
                    }
                    result.name = line.substring(begin, end).toUpperCase();
                    if (result.name.equals(TdP_ENDSECTIONTEXT)) {
                        if (result.level-- == result.skipLevel) {
                            result.skip = false;
                            result.skipLevel = 0;
                            continue block6;
                        }
                        if (result.skip) continue block6;
                        result.type = 3;
                        return 0;
                    }
                    ++result.level;
                    if (result.skip) continue block6;
                    if (result.application != null && result.name.startsWith("@")) {
                        result.skip = !result.name.substring(1, result.name.length()).equals(result.application);
                        result.skipLevel = result.level;
                        continue block6;
                    }
                    result.type = 2;
                    return 0;
                }
            }
            if (!result.skip) break;
        }
        result.type = 1;
        result.value = "";
        begin = end;
        int last = end;
        boolean foundSep = false;
        while (true) {
            block25: {
                block26: {
                    block24: {
                        if (end >= len) break block24;
                        if (line.charAt(end) == File.separatorChar) {
                            return 101;
                        }
                        if (line.charAt(end) != result.separator) break block25;
                        foundSep = true;
                        result.name = line.substring(begin, last);
                        ++end;
                        while (end < len && Character.isWhitespace(line.charAt(end))) {
                            ++end;
                        }
                        begin = end;
                        break block26;
                    }
                    if (foundSep) return 0;
                    result.name = line.substring(begin, last);
                    return 0;
                }
                while (end < len) {
                    if (!Character.isWhitespace(line.charAt(end))) {
                        last = ++end;
                        continue;
                    }
                    ++end;
                }
                result.value = last > begin ? line.substring(begin, last) : "";
            }
            if (end < len && !Character.isWhitespace(line.charAt(end))) {
                last = ++end;
                continue;
            }
            ++end;
        }
    }

    public int parse(Reader reader, String eorTag, char separator, String application) {
        ParseResult result = new ParseResult();
        result.eorTag = eorTag;
        result.separator = separator;
        result.application = application;
        result.reader = reader;
        TDSection currSection = this.section;
        int status;
        while ((status = this.parseLine(result)) == 0) {
            switch (result.type) {
                case 1: {
                    TDTag tag = new TDTag(result.name, result.value);
                    currSection.add(tag);
                    break;
                }
                case 2: {
                    TDSection newSection;
                    if (this.file.merge && currSection != null && (newSection = currSection.findSection(result.name)) != null) {
                        currSection = newSection;
                        break;
                    }
                    newSection = new TDSection(result.name);
                    currSection.add(newSection);
                    currSection = newSection;
                    break;
                }
                case 3: {
                    currSection = currSection.parent;
                    if (currSection != null) break;
                    return 100;
                }
            }
        }
        return status;
    }

    public int parseXml() {
        System.out.println("*** NYI TDHandle.parseXml ***");
        return 0;
    }

    public int seekToRoot() {
        this.setSection(this.getFile().getRoot());
        this.setTag(null);
        return 0;
    }

    public int seekToSection(TDSection section) {
        this.setSection(section);
        this.setTag(null);
        return 0;
    }

    public int seekToTag(TDTag tag) {
        this.setSection(tag.getParent());
        this.setTag(tag);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int setPositionToPath(String tagPathName, boolean createPathStruct, DomainString returnTag) {
        TDSection currentSection;
        int start;
        int status = 0;
        if (returnTag != null) {
            returnTag.reset();
        }
        TDSection oldSection = this.getSection();
        if (tagPathName == null || tagPathName.length() == 0) {
            return 109;
        }
        String name = tagPathName.toUpperCase();
        if (name.indexOf(47, start = 0) == start) {
            ++start;
            currentSection = this.getFile().getRoot();
        } else {
            currentSection = this.getSection();
        }
        int nameLen = name.length();
        while (start < nameLen) {
            int end;
            block14: {
                end = name.indexOf(47, start);
                if (end == -1) {
                    if (returnTag != null) {
                        returnTag.setValue(name.substring(start));
                        break;
                    }
                    end = nameLen;
                }
                if (name.substring(start, end).equals("..")) {
                    if ((currentSection = currentSection.getParent()) == null) {
                        status = 109;
                        break;
                    }
                } else if (!name.substring(start, end).equals(".")) {
                    TDSection saveSection = currentSection;
                    if ((currentSection = currentSection.findSection(name.substring(start, end))) == null) {
                        if (createPathStruct) {
                            currentSection = new TDSection(name.substring(start, end));
                            saveSection.add(currentSection);
                            status = 112;
                            break block14;
                        } else {
                            status = 109;
                            break;
                        }
                    }
                    this.seekToSection(currentSection);
                }
            }
            start = end + 1;
        }
        this.seekToSection(status == 109 ? oldSection : currentSection);
        return status;
    }

    public int newTag(String tagPathName, String tagValue, TDTag[] returnTag) {
        DomainString tagName = new DomainString();
        int status = this.setPositionToPath(tagPathName, true, tagName);
        switch (status) {
            case 0: 
            case 112: {
                returnTag[0] = new TDTag(tagName.toString(), tagValue);
                this.setTag(returnTag[0]);
                this.section.add(returnTag[0]);
                return 0;
            }
        }
        return status;
    }

    public int insertTag(TDTag insertTag) {
        TDTag tag = this.getTag();
        int status = tag != null ? (tag == insertTag ? 0 : this.getTag().insert(insertTag)) : this.getSection().add(insertTag);
        return status;
    }

    public int getNextTag(TDTag[] returnTag) {
        TDTag tag = this.getTag();
        returnTag[0] = tag = tag != null ? tag.next : this.section.tags;
        if (tag != null) {
            this.tag = tag;
            return 0;
        }
        return 106;
    }

    public int getPrevTag(TDTag[] returnTag) {
        TDTag tag = this.getTag();
        returnTag[0] = tag = tag != null ? tag.prev() : null;
        if (tag != null) {
            this.tag = tag;
            return 0;
        }
        return 106;
    }

    public int getFirstTag(TDTag[] returnTag) {
        TDTag tag;
        returnTag[0] = tag = this.section.tags;
        if (tag != null) {
            this.tag = tag;
            return 0;
        }
        return 106;
    }

    public int getLastTag(TDTag[] returnTag) {
        TDTag tag = this.section.tags;
        if (tag != null) {
            tag = tag.last();
        }
        returnTag[0] = tag;
        if (tag != null) {
            this.tag = tag;
            return 0;
        }
        return 106;
    }

    public int findTag(String tagPathName, TDTag[] returnTag) {
        TDTag tag;
        int status = 106;
        DomainString returnTagName = new DomainString();
        if (this.setPositionToPath(tagPathName, false, returnTagName) == 0 && (tag = this.section.findTag(returnTagName.toString())) != null) {
            this.seekToTag(tag);
            returnTag[0] = tag;
            status = 0;
        }
        return status;
    }

    public int findNextTag(String name, TDTag[] returnTag) {
        TDTag aTag = this.tag;
        if (aTag == null) {
            aTag = this.section.getTags();
        }
        if (aTag != null) {
            TDTag tDTag = aTag = aTag.next != null ? aTag.next.findPrimitive(name) : null;
        }
        if (aTag != null) {
            this.seekToTag(aTag);
            returnTag[0] = aTag;
            return 0;
        }
        return 106;
    }

    public int findPrevTag(String name, TDTag[] returnTag) {
        TDTag aTag = this.tag;
        if (aTag != null) {
            aTag = aTag.prev().findPrimitive(name);
        }
        if (aTag != null) {
            this.seekToTag(aTag);
            returnTag[0] = aTag;
            return 0;
        }
        return 106;
    }

    public int deleteTag() {
        TDTag aTag = this.removeTag();
        return aTag.delete();
    }

    public TDTag removeTag() {
        TDTag returnTag = this.tag;
        this.tag = returnTag.next;
        if (this.tag == null) {
            this.tag = returnTag.prev();
        }
        returnTag.remove();
        return returnTag;
    }

    public int renameResetTag(String newName, String newValue) {
        if (this.tag != null) {
            return 106;
        }
        if (newName == null && newValue == null) {
            return 101;
        }
        if (newName != null && newName.indexOf(File.separatorChar) >= 0) {
            return 101;
        }
        this.tag.resetNameValue(newName, newValue);
        return 0;
    }

    public int newSection(String sectionPathName, TDSection[] returnSection) {
        TDSection oldSection = this.section;
        int status = this.setPositionToPath(sectionPathName, true, null);
        switch (status) {
            case 0: {
                TDSection aSection;
                if (oldSection.parent == this.section) {
                    aSection = this.section;
                } else {
                    aSection = new TDSection(this.section.name);
                    status = this.section.parent.add(aSection);
                }
                this.seekToSection(aSection);
                returnSection[0] = aSection;
                break;
            }
            case 112: {
                returnSection[0] = this.section;
                status = 0;
                break;
            }
        }
        return status;
    }

    public int insertSection(TDSection sectionToInsert) {
        int status = this.section.insert(sectionToInsert);
        if (status == 0) {
            this.seekToSection(sectionToInsert);
        }
        return status;
    }

    public int getNextSection(TDSection[] returnSection) {
        TDSection aSection = this.section.next;
        if (aSection != null) {
            this.seekToSection(aSection);
        }
        returnSection[0] = aSection;
        return aSection != null ? 0 : 108;
    }

    public int getPrevSection(TDSection[] returnSection) {
        TDSection aSection = this.section.prev();
        if (aSection != null) {
            this.seekToSection(aSection);
        }
        returnSection[0] = aSection;
        return aSection != null ? 0 : 108;
    }

    public int getFirstSection(TDSection[] returnSection) {
        TDSection aSection = this.section.kids;
        if (aSection != null) {
            this.seekToSection(aSection);
        }
        returnSection[0] = aSection;
        return aSection != null ? 0 : 108;
    }

    public int getLastSection(TDSection[] returnSection) {
        TDSection lastSection = null;
        TDSection aSection = this.section.kids;
        while (aSection != null) {
            lastSection = aSection;
            aSection = aSection.next;
        }
        if (lastSection != null) {
            this.seekToSection(lastSection);
        }
        returnSection[0] = lastSection;
        return lastSection != null ? 0 : 108;
    }

    public int findSection(String sectionPathName, TDSection[] returnSection) {
        int status = this.setPositionToPath(sectionPathName, false, null);
        if (status == 0) {
            returnSection[0] = this.section;
        }
        return status;
    }

    public int renameSection(String name) {
        if (this.file.root != this.section) {
            if (name.indexOf(File.separatorChar) >= 0) {
                return 101;
            }
            this.section.setName(name);
            return 0;
        }
        return 117;
    }

    public int findNextSection(String name, TDSection[] returnSection) {
        TDSection aSection = this.section;
        if (aSection != null) {
            aSection = aSection.next.findPrimitive(name);
        }
        if (aSection != null) {
            this.seekToSection(aSection);
            returnSection[0] = aSection;
            return 0;
        }
        return 108;
    }

    public int findPrevSection(String name, TDSection[] returnSection) {
        TDSection aSection = this.section;
        if (aSection != null) {
            aSection = aSection.prev().findPrimitive(name);
        }
        if (aSection != null) {
            this.seekToSection(aSection);
            returnSection[0] = aSection;
            return 0;
        }
        return 108;
    }

    public TDSection resetCurrentSection() {
        TDSection returnSection;
        if (this.section != this.file.root) {
            returnSection = this.section;
            this.section = returnSection.next;
            if (this.section == null) {
                this.section = returnSection.prev();
                if (this.section == null) {
                    this.section = returnSection.parent;
                }
            }
        } else {
            returnSection = null;
        }
        this.seekToSection(this.section);
        return returnSection;
    }

    public int deleteSection() {
        this.section = this.resetCurrentSection();
        int status = this.section != null ? this.section.delete() : this.file.root.clear();
        return status;
    }

    public TDSection removeSection() {
        TDSection returnSection = this.resetCurrentSection();
        if (returnSection != null) {
            returnSection.remove();
        }
        return returnSection;
    }

    static class ParseResult {
        String name;
        String value;
        String application;
        String eorTag;
        Reader reader;
        boolean skip;
        int level;
        int skipLevel;
        char separator;
        int type;

        ParseResult() {
        }
    }
}

