/*
 * Decompiled with CFR 0.152.
 */
package com.modal.claim;

import com.modal.ClaimOutputFlag;
import com.modal.Diagnosis;
import com.modal.Edit;
import com.modal.Procedure;
import com.modal.ValueCodes;
import com.util.StringUtils;
import gov.cms.oce.api.OceClaimExecutor;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceLineItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GrouperOutput {
    private final ArrayList<Procedure> procedureArrayList = new ArrayList();
    private final ArrayList<Diagnosis> pdxList = new ArrayList();
    private final ArrayList<Diagnosis> sdxList = new ArrayList();
    private final ArrayList<Diagnosis> rvdxList = new ArrayList();
    private ArrayList<Edit> claimRejectionEdits = new ArrayList();
    private ArrayList<Edit> claimDenialEdits = new ArrayList();
    private ArrayList<Edit> claimRtpEdits = new ArrayList();
    private ArrayList<Edit> claimMedicalSuspendEdits = new ArrayList();
    private ArrayList<Edit> claimLineItemRejectionEdits = new ArrayList();
    private ArrayList<Edit> claimLineItemDenialEdits = new ArrayList();
    private ArrayList<ValueCodes> valueCodes = new ArrayList();
    private ArrayList<String> payerConditionCodes = new ArrayList();
    private ClaimOutputFlag returnCode;
    private ClaimOutputFlag claimProcessedFlag;
    private ClaimOutputFlag overallClaimDisposition;
    private ClaimOutputFlag claimRejectionDisposition;
    private ClaimOutputFlag claimDenialDisposition;
    private ClaimOutputFlag claimRTPDisposition;
    private ClaimOutputFlag claimSuspensionDisposition;
    private ClaimOutputFlag lineItemRejectionDisposition;
    private ClaimOutputFlag lineItemDenialDisposition;
    private String oceVersionUsed;
    private String bufferCompleted;
    private String numberOfLineItems;
    private String billTypeX83Flag;

    public void addLineLevelOutput(OceClaim claim) {
        List<OceLineItem> lineItemList = claim.getLineItemList();
        this.procedureArrayList.clear();
        for (OceLineItem lineItem : lineItemList) {
            Procedure proc = new Procedure();
            proc.setCodeOutput(lineItem.getHcpcs());
            proc.setPaymentAPC(lineItem.getPaymentApc());
            proc.setHcpcsAPC(lineItem.getHcpcsApc());
            proc.setStatusIndicator(lineItem.getStatusIndicator());
            proc.setPaymentIndicator(lineItem.getPaymentIndicator());
            proc.setDiscountFormula(lineItem.getDiscountingFormula());
            proc.setLineItemDenialRejectionFlag(lineItem.getRejectionDenialFlag());
            proc.setPackagingFlag(lineItem.getPackagingFlag());
            proc.setPaymentAdjustmentFlag(lineItem.getPaymentAdjustmentFlag01());
            proc.setPaymentAdjustmentFlag2(lineItem.getPaymentAdjustmentFlag02());
            proc.setPaymentMethodFlag(lineItem.getPaymentMethodFlag());
            proc.setUnitsOutput(lineItem.getUnitsOutput());
            proc.setChargeOutput(lineItem.getCharge());
            proc.setLineItemActionFlagOutput(lineItem.getActionFlagOutput());
            proc.setCompositeAdjustmentFlag(lineItem.getCompositeAdjustmentFlag());
            proc.setLineItemActionFlagInput(lineItem.getActionFlagInput());
            proc.setCbAPC(lineItem.getContractorApc());
            proc.setCbDenialRejection(lineItem.getContractorRejectionDenialFlag());
            proc.setCbDiscountingFormula(lineItem.getContractorDiscountingFormula());
            proc.setCbEdit1(this.getElementOrElseEmptyStr(lineItem.getContractorEditBypassList(), 0));
            proc.setCbEdit2(this.getElementOrElseEmptyStr(lineItem.getContractorEditBypassList(), 1));
            proc.setCbEdit3(this.getElementOrElseEmptyStr(lineItem.getContractorEditBypassList(), 2));
            proc.setCbEdit4(this.getElementOrElseEmptyStr(lineItem.getContractorEditBypassList(), 3));
            proc.setCbPackagingFlag(lineItem.getContractorPackagingFlag());
            proc.setCbPaymentAdjustmentFlag(lineItem.getContractorPaymentAdjustmentFlag01());
            proc.setCbPaymentAdjustmentFlag2(lineItem.getContractorPaymentAdjustmentFlag02());
            proc.setCbPaymentIndicator(lineItem.getContractorPaymentIndicator());
            proc.setCbPaymentMethodFlag(lineItem.getContractorPaymentMethodFlag());
            proc.setCbStatusIndicator(lineItem.getContractorStatusIndicator());
            proc.setCode(lineItem.getHcpcs());
            proc.setModifier1(this.getElementOrElseEmptyModifier(lineItem.getHcpcsModifierInputList(), 0));
            proc.setModifier2(this.getElementOrElseEmptyModifier(lineItem.getHcpcsModifierInputList(), 1));
            proc.setModifier3(this.getElementOrElseEmptyModifier(lineItem.getHcpcsModifierInputList(), 2));
            proc.setModifier4(this.getElementOrElseEmptyModifier(lineItem.getHcpcsModifierInputList(), 3));
            proc.setModifier5(this.getElementOrElseEmptyModifier(lineItem.getHcpcsModifierInputList(), 4));
            proc.setRevenueCode(lineItem.getRevenueCode());
            proc.setServiceDate(lineItem.getServiceDate());
            proc.setUnitsInput(lineItem.getUnitsInput());
            proc.setChargeInput(lineItem.getCharge());
            proc.setHcpcsModifier(lineItem.getHcpcsModifierOutputList().stream().map(OceHcpcsModifier::getHcpcsModifier).collect(Collectors.joining("")));
            proc.setProcedureEdits(new ArrayList<Edit>(lineItem.getHcpcsEditList().stream().map(Edit::new).collect(Collectors.toList())));
            proc.setDateEdits(new ArrayList<Edit>(lineItem.getServiceDateEditList().stream().map(Edit::new).collect(Collectors.toList())));
            proc.setRevenueEdits(new ArrayList<Edit>(lineItem.getRevenueEditList().stream().map(Edit::new).collect(Collectors.toList())));
            proc.setModifierEdits(new ArrayList<Edit>(lineItem.getHcpcsModifierInputList().stream().flatMap(m -> m.getEditList().stream().map(Edit::new)).collect(Collectors.toList())));
            this.procedureArrayList.add(proc);
        }
    }

    public void addDXEdits(OceClaim claim, OceClaimExecutor executor) {
        OceDiagnosisCode principalDiagnosisCode;
        ArrayList<Edit> edits;
        Diagnosis diagnosis;
        this.rvdxList.clear();
        for (OceDiagnosisCode diagnosisCode : claim.getReasonForVisitDiagnosisCodeList()) {
            if (StringUtils.isNullOrWhitespace(diagnosisCode.getDiagnosis())) break;
            diagnosis = new Diagnosis(diagnosisCode.getDiagnosis(), executor.getLatestDiagnosisDescription(diagnosisCode.getDiagnosis()));
            edits = diagnosis.getEdits();
            edits.clear();
            edits.addAll(diagnosisCode.getEditList().stream().map(Edit::new).collect(Collectors.toList()));
            this.rvdxList.add(diagnosis);
        }
        this.pdxList.clear();
        if (claim.getPrincipalDiagnosisCode() != null && !StringUtils.isNullOrWhitespace((principalDiagnosisCode = claim.getPrincipalDiagnosisCode()).getDiagnosis())) {
            Diagnosis principcalDiagnosis = new Diagnosis(principalDiagnosisCode.getDiagnosis(), executor.getLatestDiagnosisDescription(principalDiagnosisCode.getDiagnosis()));
            ArrayList<Edit> principcalEdits = principcalDiagnosis.getEdits();
            principcalEdits.clear();
            principcalEdits.addAll(principalDiagnosisCode.getEditList().stream().map(Edit::new).collect(Collectors.toList()));
            this.pdxList.add(principcalDiagnosis);
        }
        this.sdxList.clear();
        for (OceDiagnosisCode diagnosisCode : claim.getSecondaryDiagnosisCodeList()) {
            if (StringUtils.isNullOrWhitespace(diagnosisCode.getDiagnosis())) break;
            diagnosis = new Diagnosis(diagnosisCode.getDiagnosis(), executor.getLatestDiagnosisDescription(diagnosisCode.getDiagnosis()));
            edits = diagnosis.getEdits();
            edits.clear();
            edits.addAll(diagnosisCode.getEditList().stream().map(Edit::new).collect(Collectors.toList()));
            this.sdxList.add(diagnosis);
        }
    }

    public void addClaimLevelOutputs(OceClaim claim, OceClaimExecutor executor) {
        this.claimRejectionEdits = claim.getClaimRejectionEditList().stream().map(Edit::new).collect(Collectors.toCollection(ArrayList::new));
        this.claimDenialEdits = claim.getClaimDenialEditList().stream().map(Edit::new).collect(Collectors.toCollection(ArrayList::new));
        this.claimRtpEdits = claim.getClaimReturnToProviderEditList().stream().map(Edit::new).collect(Collectors.toCollection(ArrayList::new));
        this.claimMedicalSuspendEdits = claim.getClaimSuspensionEditList().stream().map(Edit::new).collect(Collectors.toCollection(ArrayList::new));
        this.claimLineItemRejectionEdits = claim.getLineRejectionEditList().stream().map(Edit::new).collect(Collectors.toCollection(ArrayList::new));
        this.claimLineItemDenialEdits = claim.getLineDenialEditList().stream().map(Edit::new).collect(Collectors.toCollection(ArrayList::new));
        this.valueCodes = claim.getValueCodeInputList().stream().map(v -> new ValueCodes(v.getCode(), v.getValue())).collect(Collectors.toCollection(ArrayList::new));
        this.payerConditionCodes = new ArrayList<String>(claim.getConditionCodeInputList());
        this.setClaimProcessedFlag(new ClaimOutputFlag(claim.getClaimProcessedFlag(), executor.getLatestClaimProcessedFlagDescription(claim)));
        this.setOverallClaimDisposition(new ClaimOutputFlag(claim.getClaimDisposition(), executor.getLatestClaimDispositionValueDescription("1", claim.getClaimDisposition())));
        this.setClaimRejectionDisposition(new ClaimOutputFlag(claim.getClaimRejectionDisposition(), executor.getLatestClaimDispositionValueDescription("2", claim.getClaimRejectionDisposition())));
        this.setClaimDenialDisposition(new ClaimOutputFlag(claim.getClaimDenialDisposition(), executor.getLatestClaimDispositionValueDescription("3", claim.getClaimDenialDisposition())));
        this.setClaimRTPDisposition(new ClaimOutputFlag(claim.getClaimReturnToProviderDisposition(), executor.getLatestClaimDispositionValueDescription("4", claim.getClaimReturnToProviderDisposition())));
        this.setClaimSuspensionDisposition(new ClaimOutputFlag(claim.getClaimSuspensionDisposition(), executor.getLatestClaimDispositionValueDescription("5", claim.getClaimSuspensionDisposition())));
        this.setLineItemRejectionDisposition(new ClaimOutputFlag(claim.getLineRejectionDisposition(), executor.getLatestClaimDispositionValueDescription("6", claim.getLineRejectionDisposition())));
        this.setLineItemDenialDisposition(new ClaimOutputFlag(claim.getLineDenialDisposition(), executor.getLatestClaimDispositionValueDescription("7", claim.getLineDenialDisposition())));
        this.setBillTypeX83Flag(claim.getNoppsBillFlag());
        this.setOceVersionUsed(claim.getVersion());
        this.setBufferCompleted(claim.getApcReturnBufferFlag());
        this.setNumberOfLineItems(String.valueOf(claim.getLineItemListLength()));
    }

    public ArrayList<Procedure> getProcedureArrayList() {
        return this.procedureArrayList;
    }

    public ClaimOutputFlag getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(OceClaim claim, OceClaimExecutor executor) {
        String returnCode = String.valueOf(claim.getProcessingInformation().getReturnCode());
        this.returnCode = new ClaimOutputFlag(returnCode, executor.getLatestErrorDescription(returnCode));
    }

    public void setReturnCode(ClaimOutputFlag returnCode) {
        this.returnCode = returnCode;
    }

    public ClaimOutputFlag getClaimProcessedFlag() {
        return this.claimProcessedFlag;
    }

    public void setClaimProcessedFlag(ClaimOutputFlag claimProcessedFlag) {
        this.claimProcessedFlag = claimProcessedFlag;
    }

    public ClaimOutputFlag getOverallClaimDisposition() {
        return this.overallClaimDisposition;
    }

    public void setOverallClaimDisposition(ClaimOutputFlag overallClaimDisposition) {
        this.overallClaimDisposition = overallClaimDisposition;
    }

    public String getOceVersionUsed() {
        return this.oceVersionUsed;
    }

    public void setOceVersionUsed(String oceVersionUsed) {
        this.oceVersionUsed = oceVersionUsed;
    }

    public String getBufferCompleted() {
        return this.bufferCompleted;
    }

    public void setBufferCompleted(String bufferCompleted) {
        this.bufferCompleted = bufferCompleted;
    }

    public ArrayList<Edit> getClaimRejectionEdits() {
        return this.claimRejectionEdits;
    }

    public ArrayList<Edit> getClaimRtpEdits() {
        return this.claimRtpEdits;
    }

    public ArrayList<Edit> getClaimLineItemDenialEdits() {
        return this.claimLineItemDenialEdits;
    }

    public ArrayList<Edit> getClaimLineItemRejectionEdits() {
        return this.claimLineItemRejectionEdits;
    }

    public ArrayList<Edit> getClaimMedicalSuspendEdits() {
        return this.claimMedicalSuspendEdits;
    }

    public ArrayList<Edit> getClaimDenialEdits() {
        return this.claimDenialEdits;
    }

    public ArrayList<ValueCodes> getValueCodes() {
        return this.valueCodes;
    }

    public List<String> getFormattedValueCodes() {
        ArrayList<String> formattedValueCodes = new ArrayList<String>();
        this.valueCodes.forEach(e -> {
            if (!e.toDomainString().trim().isEmpty() && !e.toDomainString().startsWith(" ")) {
                formattedValueCodes.add(e.toString());
            }
        });
        return formattedValueCodes;
    }

    public void setValueCodes(ArrayList<ValueCodes> valueCodes) {
        this.valueCodes = valueCodes;
    }

    public ArrayList<String> getPayerConditionCodes() {
        return this.payerConditionCodes;
    }

    public void setPayerConditionCodes(ArrayList<String> payerConditionCodes) {
        this.payerConditionCodes = payerConditionCodes;
    }

    public ClaimOutputFlag getClaimRejectionDisposition() {
        return this.claimRejectionDisposition;
    }

    public void setClaimRejectionDisposition(ClaimOutputFlag claimRejectionDisposition) {
        this.claimRejectionDisposition = claimRejectionDisposition;
    }

    public ClaimOutputFlag getClaimDenialDisposition() {
        return this.claimDenialDisposition;
    }

    public void setClaimDenialDisposition(ClaimOutputFlag claimDenialDisposition) {
        this.claimDenialDisposition = claimDenialDisposition;
    }

    public ClaimOutputFlag getClaimRTPDisposition() {
        return this.claimRTPDisposition;
    }

    public void setClaimRTPDisposition(ClaimOutputFlag claimRTPDisposition) {
        this.claimRTPDisposition = claimRTPDisposition;
    }

    public ClaimOutputFlag getClaimSuspensionDisposition() {
        return this.claimSuspensionDisposition;
    }

    public void setClaimSuspensionDisposition(ClaimOutputFlag claimSuspensionDisposition) {
        this.claimSuspensionDisposition = claimSuspensionDisposition;
    }

    public ClaimOutputFlag getLineItemRejectionDisposition() {
        return this.lineItemRejectionDisposition;
    }

    public void setLineItemRejectionDisposition(ClaimOutputFlag lineItemRejectionDisposition) {
        this.lineItemRejectionDisposition = lineItemRejectionDisposition;
    }

    public ClaimOutputFlag getLineItemDenialDisposition() {
        return this.lineItemDenialDisposition;
    }

    public void setLineItemDenialDisposition(ClaimOutputFlag lineItemDenialDisposition) {
        this.lineItemDenialDisposition = lineItemDenialDisposition;
    }

    public String getNumberOfLineItems() {
        return this.numberOfLineItems;
    }

    public void setNumberOfLineItems(String numberOfLineItems) {
        this.numberOfLineItems = numberOfLineItems;
    }

    public String getBillTypeX83Flag() {
        return this.billTypeX83Flag;
    }

    public void setBillTypeX83Flag(String billTypeX83Flag) {
        this.billTypeX83Flag = billTypeX83Flag;
    }

    private String getElementOrElseEmptyStr(List<String> list, int index) {
        if (list.size() >= index) {
            return "";
        }
        return list.get(index);
    }

    private String getElementOrElseEmptyModifier(List<OceHcpcsModifier> list, int index) {
        if (list.size() >= index) {
            return "";
        }
        return list.get(index).getHcpcsModifier();
    }
}

