/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.component.ComponentManager;
import com.modal.claim.GrouperInput;
import com.modal.claim.GrouperOutput;
import com.util.Popup;
import com.util.TRFMapper;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.util.converter.OceClaimDefinition;
import gov.cms.oce.util.converter.OceClaimToTestClaimConverter;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.io.StringWriter;
import javafx.scene.control.Alert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTRF
extends TRFMapper {
    private static final Logger logger = LoggerFactory.getLogger(ExportTRF.class);
    private final GrouperInput grouperInput;
    private final GrouperOutput grouperOutput;

    public ExportTRF(GrouperInput grouperInput, GrouperOutput grouperOutput) {
        this.grouperInput = grouperInput;
        this.grouperOutput = grouperOutput;
    }

    public String getOutput() {
        ComponentManager componentManager = new ComponentManager(this.grouperInput, this.grouperOutput);
        OceClaim oceClaim = componentManager.processFixedClaim();
        try {
            OceClaimDefinition oceClaimDefinition = new OceClaimDefinition();
            OceClaimToTestClaimConverter outputConverter = new OceClaimToTestClaimConverter(oceClaimDefinition.getClaimDefinition());
            ClaimModel claim = outputConverter.convert(oceClaim);
            StringWriter writer = new StringWriter();
            for (RecordModel record : claim.getRecords()) {
                writer.write(record.getData());
                writer.write("\r\n");
            }
            return writer.toString();
        }
        catch (Exception e) {
            logger.error("Error when trying to export claim...", e);
            this.showError();
            return "";
        }
    }

    private void showError() {
        new Popup(Alert.AlertType.ERROR, "Component Export Error", "Missing Required Fields", "The export function failed unexpectedly. Please check to make sure the claim you are exporting is valid.").showAndWait();
    }
}

