/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Control;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;

public class NodeUtils {
    public static Control[] getAllControl(Parent root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeUtils.addAllDescendents(root, nodes);
        Control[] controls = new Control[nodes.size()];
        int i2 = 0;
        for (Node n : nodes) {
            if (!(n instanceof Control) || n.getId() == null) continue;
            controls[i2++] = (Control)n;
        }
        return controls;
    }

    public static Control[] getAllControl(Parent root, String ... id) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeUtils.addAllDescendents(root, nodes);
        Control[] controls = new Control[nodes.size()];
        int i2 = 0;
        for (Node n : nodes) {
            if (!(n instanceof Control) || n.getId() == null) continue;
            for (String s : id) {
                if (!s.contains(n.getId())) continue;
                controls[i2++] = (Control)n;
            }
        }
        return controls;
    }

    private static void addAllDescendents(Parent root, ArrayList<Node> nodes) {
        List children = Collections.EMPTY_LIST;
        if (root instanceof ButtonBar) {
            children = ((ButtonBar)root).getButtons();
        } else if (root instanceof TitledPane) {
            NodeUtils.addAllDescendents((Parent)((TitledPane)root).getContent(), nodes);
        } else if (root instanceof TabPane) {
            for (Tab tab : ((TabPane)root).getTabs()) {
                Node tabContent = tab.getContent();
                if (!(tabContent instanceof Parent)) continue;
                NodeUtils.addAllDescendents((Parent)tab.getContent(), nodes);
            }
        } else {
            children = root.getChildrenUnmodifiable();
        }
        for (Node node : children) {
            nodes.add(node);
            if (!(node instanceof Parent)) continue;
            NodeUtils.addAllDescendents((Parent)node, nodes);
        }
    }
}

