/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.mmmhis.domain.DomainFixedString;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final Logger logger = LoggerFactory.getLogger(StringUtils.class);

    public static String trim(char c, String value) {
        int st;
        if (c <= ' ') {
            return value.trim();
        }
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && val[st] == c; ++st) {
        }
        while (st < len && val[len - 1] == c) {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public static String cat(Object ... v) {
        StringBuilder sb = new StringBuilder();
        for (Object o : v) {
            sb.append(o).append(" ");
        }
        return sb.toString();
    }

    public static String convertToDomainDate(String date, String inputPatter, String outputPattern) {
        try {
            if (date != null && !date.trim().isEmpty()) {
                Date date1 = new SimpleDateFormat(inputPatter).parse(date);
                String formattedDate = new SimpleDateFormat(outputPattern).format(date1);
                Date date2 = new SimpleDateFormat(outputPattern).parse(formattedDate);
                String backwards = new SimpleDateFormat(inputPatter).format(date2);
                if (date.equals(backwards) || date.contains("-")) {
                    return formattedDate;
                }
                return date;
            }
        }
        catch (ParseException e) {
            return date;
        }
        return "        ";
    }

    public static String center(String text, int len) {
        String out = String.format("%" + len + "s%s%" + len + "s", "", text, "");
        float mid = out.length() / 2;
        float start = mid - (float)(len / 2);
        float end = start + (float)len;
        return out.substring((int)start, (int)end);
    }

    public static DomainFixedString[] createEmptyDomainStringArray(int elementLength, int arrayLength) {
        DomainFixedString[] tmp = new DomainFixedString[arrayLength];
        for (int idx = 0; idx < tmp.length; ++idx) {
            tmp[idx] = new DomainFixedString(elementLength);
        }
        return tmp;
    }

    public static boolean isNullOrWhitespace(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().isEmpty();
    }

    public static String trim(String str) {
        if (str == null) {
            return str;
        }
        return str.trim();
    }
}

