/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.modal.Diagnosis;
import com.modal.Procedure;
import com.modal.ValueCodes;
import com.modal.claim.GrouperInput;
import com.util.Popup;
import com.util.StringUtils;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.util.converter.OceClaimDefinition;
import gov.cms.oce.util.converter.TestClaimToOceClaimConverter;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.TestClaimFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TRFMapper {
    private static final Logger logger = LoggerFactory.getLogger(TRFMapper.class);

    private GrouperInput populate(OceClaim claim) {
        OceLineItem line;
        GrouperInput input = new GrouperInput();
        input.setClaimID(claim.getClaimId());
        input.setAge(claim.getAge());
        input.setSex(claim.getSex());
        input.setFromDate(claim.getDateStarted());
        input.setThroughDate(claim.getDateEnded());
        input.setBillType(claim.getBillType());
        input.setMedicalRecordNumber(claim.getNationalProviderId());
        input.setCCN(claim.getCmsCertificationNumber());
        input.setPatientStatus(claim.getPatientStatus());
        input.setOpps(claim.getOppsFlag());
        input.setOccurrenceCodes(new ArrayList<String>(claim.getOccurrenceCodeInputList().stream().filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList())));
        input.setConditionCodes(new ArrayList<String>(claim.getConditionCodeInputList()));
        input.setReceiptDate(claim.getReceiptDate());
        input.setPdxList((ObservableList<Diagnosis>)FXCollections.observableArrayList((Object[])new Diagnosis[]{new Diagnosis(claim.getPrincipalDiagnosisCode().getDiagnosis(), "")}));
        input.setSdxList((ObservableList<Diagnosis>)FXCollections.observableArrayList((Collection)claim.getSecondaryDiagnosisCodeList().stream().filter(s -> s.getDiagnosis() != null && !s.getDiagnosis().isEmpty()).map(s -> new Diagnosis(s.getDiagnosis(), "")).collect(Collectors.toList())));
        input.setRvdxList((ObservableList<Diagnosis>)FXCollections.observableArrayList((Collection)claim.getReasonForVisitDiagnosisCodeList().stream().filter(s -> s.getDiagnosis() != null && !s.getDiagnosis().isEmpty()).map(s -> new Diagnosis(s.getDiagnosis(), "")).collect(Collectors.toList())));
        input.setValueCodes(new ArrayList<ValueCodes>(claim.getValueCodeInputList().stream().filter(s -> s.getCode() != null && !s.getCode().isEmpty()).map(s -> new ValueCodes(s.getCode(), s.getValue())).collect(Collectors.toList())));
        Iterator<OceLineItem> iterator = claim.getLineItemList().iterator();
        while (!(!iterator.hasNext() || StringUtils.isNullOrWhitespace((line = iterator.next()).getServiceDate()) && StringUtils.isNullOrWhitespace(line.getRevenueCode()))) {
            Procedure proc = new Procedure();
            proc.setLineItemActionFlagInput(line.getActionFlagInput());
            proc.setCbAPC(line.getContractorApc());
            proc.setCbDenialRejection(line.getContractorRejectionDenialFlag());
            proc.setCbDiscountingFormula(line.getContractorDiscountingFormula());
            proc.setCbEdit1(this.getElementOrElseEmptyStr(line.getContractorEditBypassList(), 0));
            proc.setCbEdit2(this.getElementOrElseEmptyStr(line.getContractorEditBypassList(), 1));
            proc.setCbEdit3(this.getElementOrElseEmptyStr(line.getContractorEditBypassList(), 2));
            proc.setCbEdit4(this.getElementOrElseEmptyStr(line.getContractorEditBypassList(), 3));
            proc.setCbPackagingFlag(line.getContractorPackagingFlag());
            proc.setCbPaymentAdjustmentFlag(line.getContractorPaymentAdjustmentFlag01());
            proc.setCbPaymentAdjustmentFlag2(line.getContractorPaymentAdjustmentFlag02());
            proc.setCbPaymentIndicator(line.getContractorPaymentIndicator());
            proc.setCbPaymentMethodFlag(line.getContractorPaymentMethodFlag());
            proc.setCbStatusIndicator(line.getContractorStatusIndicator());
            proc.setCode(line.getHcpcs());
            proc.setModifier1(this.getElementOrElseEmptyModifier(line.getHcpcsModifierInputList(), 0));
            proc.setModifier2(this.getElementOrElseEmptyModifier(line.getHcpcsModifierInputList(), 1));
            proc.setModifier3(this.getElementOrElseEmptyModifier(line.getHcpcsModifierInputList(), 2));
            proc.setModifier4(this.getElementOrElseEmptyModifier(line.getHcpcsModifierInputList(), 3));
            proc.setModifier5(this.getElementOrElseEmptyModifier(line.getHcpcsModifierInputList(), 4));
            proc.setRevenueCode(line.getRevenueCode());
            proc.setServiceDate(line.getServiceDate());
            proc.setUnitsInput(line.getUnitsInput());
            proc.setChargeInput(line.getCharge());
            input.addProcedure(proc);
        }
        return input;
    }

    private String getElementOrElseEmptyStr(List<String> list, int index) {
        if (list.size() >= index) {
            return "";
        }
        return list.get(index);
    }

    private String getElementOrElseEmptyModifier(List<OceHcpcsModifier> list, int index) {
        if (list.size() >= index) {
            return "";
        }
        return list.get(index).getHcpcsModifier();
    }

    public GrouperInput group(File file) {
        List<GrouperInput> inputs = this.getInputs(file);
        return inputs.size() > 0 ? inputs.get(0) : null;
    }

    public List<GrouperInput> multGroup(File inputFile) {
        return this.getInputs(inputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GrouperInput> getInputs(File inputFile) {
        TestClaimFileReader reader = null;
        ArrayList<GrouperInput> inputs = new ArrayList<GrouperInput>();
        try {
            ClaimModel claim;
            OceClaimDefinition oceClaimDefinition = new OceClaimDefinition();
            reader = new TestClaimFileReader(inputFile.getAbsolutePath(), oceClaimDefinition.getClaimDefinition());
            reader.open();
            TestClaimToOceClaimConverter inputConverter = new TestClaimToOceClaimConverter(oceClaimDefinition.getClaimDefinition());
            while ((claim = reader.next()) != null) {
                OceClaim oceClaim = inputConverter.convert(claim);
                inputs.add(this.populate(oceClaim));
            }
        }
        catch (Exception e) {
            logger.error("Error while importing claim...", e);
            this.showError();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return inputs;
    }

    private void showError() {
        new Popup(Alert.AlertType.ERROR, "Component Import Error", "Missing Required Input", "The import function failed unexpectedly. Please check your import file and compare with the IOCE manual.").showAndWait();
    }
}

