/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.api;

import gov.cms.oce.api.OceClaimExecutor;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.util.FileProcessExecutor;
import gov.cms.oce.util.FileProcessor;
import gov.cms.oce.util.ModelLogger;
import gov.cms.oce.util.converter.OceClaimToStringClaimConverter;
import gov.cms.oce.util.converter.StringClaimToOceClaimConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainframeApi
implements FileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MainframeApi.class);
    private static final MainframeApi API = new MainframeApi();
    private final OceClaimExecutor claimExecutor = new OceClaimExecutor();
    private final StringClaimToOceClaimConverter inputConverter = new StringClaimToOceClaimConverter();
    private final OceClaimToStringClaimConverter outputConverter = new OceClaimToStringClaimConverter();

    private final String processClaim(String inputClaimBuffer) {
        String outputClaimBuffer = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Input claim string: \"{}\"", (Object)inputClaimBuffer);
            }
            OceClaim oceClaim = this.inputConverter.convert(inputClaimBuffer);
            if (logger.isTraceEnabled()) {
                ModelLogger.print(oceClaim);
            }
            this.claimExecutor.processClaim(oceClaim);
            if (logger.isTraceEnabled()) {
                ModelLogger.print(oceClaim);
            }
            outputClaimBuffer = this.outputConverter.convert(oceClaim);
            if (logger.isDebugEnabled()) {
                logger.debug("Output claim string: \"{}\"", (Object)outputClaimBuffer);
            }
        }
        catch (Exception e) {
            logger.error("Failed processing input claim buffer \"{}\".", (Object)inputClaimBuffer);
            logger.error("Failed processing input claim buffer.", e);
        }
        return outputClaimBuffer;
    }

    @Override
    public final void process(String inputFilePath, String outputFilePath) {
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(inputFilePath), StandardCharsets.UTF_8));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                String outputClaim = this.processClaim(line);
                writer.write(outputClaim);
                ((Writer)writer).write(10);
            }
        }
        catch (IOException e) {
            logger.error("IOException while processing input file \"{}\"", (Object)inputFilePath, (Object)e);
        }
    }

    @Override
    public final void process(File inputFile, File outputFile) {
        this.process(inputFile.getAbsolutePath(), outputFile.getAbsolutePath());
    }

    public static final void main(String[] v) throws IOException {
        if (v.length != 2) {
            logger.error("java -jar MainframeApi <path-to-input-file> <path-to-output-file>");
            return;
        }
        FileProcessExecutor fileProcessExecutor = new FileProcessExecutor();
        fileProcessExecutor.processFile(new MainframeApi(), v[0], v[1]);
    }

    public static final String process(String inputClaimBuffer) {
        return API.processClaim(inputClaimBuffer);
    }
}

