/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.DataDiscountFormulaDao;
import gov.cms.oce.dao.data.row.DataDiscountFormulaRowInternal;
import gov.cms.oce.dao.data.table.DataDiscountFormulaTableInternal;
import gov.cms.oce.model.internal.DiscountFormula;
import gov.cms.oce.util.StringUtilities;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataDiscountFormulaDaoImpl
implements DataDiscountFormulaDao {
    private static final Logger logger = LoggerFactory.getLogger(DataDiscountFormulaDaoImpl.class);

    @Override
    public final DataDiscountFormulaRowInternal getRow(String value, Short version) {
        if (StringUtilities.isEmpty(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Discount key parameter value is null/empty.");
            }
            return null;
        }
        Map<DataDiscountFormulaTableInternal.DataDiscountFormulaTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataDiscountFormulaTableInternal.DataDiscountFormulaTableKey.class);
        key.put(DataDiscountFormulaTableInternal.DataDiscountFormulaTableKey.DISCOUNT_KEY, value);
        DataDiscountFormulaTableInternal table = BinaryDataProvider.getInstance().getDataDiscountFormulaTable();
        DataDiscountFormulaRowInternal row = table.getRowInternal(key, version);
        if (row == null && logger.isDebugEnabled()) {
            logger.debug("Discount key parameter value \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
        }
        return row;
    }

    @Override
    public final DataDiscountFormulaRowInternal getRow(DiscountFormula discountFormula, Short version) {
        return this.getRow(String.valueOf(discountFormula.getValue()), version);
    }
}

