/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.MapAddonPhDao;
import gov.cms.oce.dao.data.row.MapAddonPhRowInternal;
import gov.cms.oce.dao.data.table.MapAddonPhTableInternal;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.StringUtilities;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapAddonPhDaoImpl
implements MapAddonPhDao {
    private static final Logger logger = LoggerFactory.getLogger(MapAddonPhDaoImpl.class);

    @Override
    public final MapAddonPhRowInternal getRow(String addon, String addonPrimary, Short version) {
        if (StringUtilities.isEmpty(addon)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Addon parameter value is null/empty.");
            }
            return null;
        }
        if (StringUtilities.isEmpty(addonPrimary)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Addon primary parameter value is null/empty.");
            }
            return null;
        }
        Map<MapAddonPhTableInternal.MapAddonPhTableKey, String> key = TableKeyBuilder.createTableKeyMap(MapAddonPhTableInternal.MapAddonPhTableKey.class);
        key.put(MapAddonPhTableInternal.MapAddonPhTableKey.ADDON, addon);
        key.put(MapAddonPhTableInternal.MapAddonPhTableKey.ADDON_PRIMARY, addonPrimary);
        MapAddonPhTableInternal table = BinaryDataProvider.getInstance().getMapAddonPhTable();
        return table.getRowInternal(key, version);
    }

    @Override
    public final MapAddonPhRowInternal getRow(LineItemInternal lineItem1, LineItemInternal lineItem2, Short version) {
        if (lineItem1.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) && lineItem2.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS)) {
            return this.getRow(lineItem1.getHcpcs().getValue(), lineItem2.getHcpcs().getValue(), version);
        }
        return null;
    }
}

