/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscDx10RowInternal;
import gov.cms.oce.dao.desc.table.DscDx10TableInternal;
import gov.cms.oce.dao.dsc.DscDx10Dao;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscDx10DaoImpl
implements DscDx10Dao {
    private static final Logger logger = LoggerFactory.getLogger(DscDx10DaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Diagnosis code parameter is null/empty.");
            }
            return "";
        }
        Map<DscDx10TableInternal.DscDx10TableKey, String> key = TableKeyBuilder.createTableKeyMap(DscDx10TableInternal.DscDx10TableKey.class);
        key.put(DscDx10TableInternal.DscDx10TableKey.DIAGNOSIS, value);
        DscDx10TableInternal table = BinaryDescriptionProvider.getInstance().getDscDx10Table();
        DscDx10RowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for diagnosis code \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(DiagnosisCode diagnosisCode, Short version) {
        String description = this.getDescription(diagnosisCode.getValue(), version);
        diagnosisCode.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Diagnosis code parameter is null/empty.");
            }
            return "";
        }
        Map<DscDx10TableInternal.DscDx10TableKey, String> key = TableKeyBuilder.createTableKeyMap(DscDx10TableInternal.DscDx10TableKey.class);
        key.put(DscDx10TableInternal.DscDx10TableKey.DIAGNOSIS, value);
        DscDx10TableInternal table = BinaryDescriptionProvider.getInstance().getDscDx10Table();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscDx10RowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(DiagnosisCode diagnosisCode) {
        String description = this.getLatestDescription(diagnosisCode.getValue());
        diagnosisCode.setDescription(description);
        return description;
    }
}

