/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscEditDispositionRowInternal;
import gov.cms.oce.dao.desc.table.DscEditDispositionTableInternal;
import gov.cms.oce.dao.dsc.DscEditDispositionDao;
import gov.cms.oce.model.internal.Disposition;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscEditDispositionDaoImpl
implements DscEditDispositionDao {
    private static final Logger logger = LoggerFactory.getLogger(DscEditDispositionDaoImpl.class);

    private final DscEditDispositionRowInternal getRow(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Edit disposition parameter is null/empty.");
            }
            return null;
        }
        Map<DscEditDispositionTableInternal.DscEditDispositionTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscEditDispositionTableInternal.DscEditDispositionTableKey.class);
        key.put(DscEditDispositionTableInternal.DscEditDispositionTableKey.ID, value);
        DscEditDispositionTableInternal table = BinaryDescriptionProvider.getInstance().getDscEditDispositionTable();
        return table.getRowInternal(key, version);
    }

    @Override
    public final String getName(String value, Short version) {
        DscEditDispositionRowInternal row = this.getRow(value, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Name for edit disposition \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getName());
    }

    @Override
    public final String getDescription(String value, Short version) {
        DscEditDispositionRowInternal row = this.getRow(value, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for edit disposition \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(Disposition disposition, Short version) {
        String description = this.getDescription(String.valueOf(disposition.getValue()), version);
        disposition.setDescription(description);
        return description;
    }

    private final DscEditDispositionRowInternal getLatestRow(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Edit disposition parameter is null/empty.");
            }
            return null;
        }
        Map<DscEditDispositionTableInternal.DscEditDispositionTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscEditDispositionTableInternal.DscEditDispositionTableKey.class);
        key.put(DscEditDispositionTableInternal.DscEditDispositionTableKey.ID, value);
        DscEditDispositionTableInternal table = BinaryDescriptionProvider.getInstance().getDscEditDispositionTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscEditDispositionRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return row;
        }
        return null;
    }

    @Override
    public final String getLatestName(String value) {
        DscEditDispositionRowInternal row = this.getLatestRow(value);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Name for edit disposition \"{}\" is missing from table.", (Object)value);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getName());
    }

    @Override
    public final String getLatestDescription(String value) {
        DscEditDispositionRowInternal row = this.getLatestRow(value);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for edit disposition \"{}\" is missing from table.", (Object)value);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getLatestDescription(Disposition disposition) {
        String description = this.getLatestDescription(String.valueOf(disposition.getValue()));
        disposition.setDescription(description);
        return description;
    }
}

