/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscLiafRowInternal;
import gov.cms.oce.dao.desc.table.DscLiafTableInternal;
import gov.cms.oce.dao.dsc.DscLiafDao;
import gov.cms.oce.model.internal.LineActionFlag;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscLiafDaoImpl
implements DscLiafDao {
    private static final Logger logger = LoggerFactory.getLogger(DscLiafDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Line item action flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscLiafTableInternal.DscLiafTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscLiafTableInternal.DscLiafTableKey.class);
        key.put(DscLiafTableInternal.DscLiafTableKey.VALUE, value);
        DscLiafTableInternal table = BinaryDescriptionProvider.getInstance().getDscLiafTable();
        DscLiafRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for line item action flag \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(LineActionFlag lineActionFlag, Short version) {
        String description = this.getDescription(String.valueOf(lineActionFlag.getValue()), version);
        lineActionFlag.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Line item action flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscLiafTableInternal.DscLiafTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscLiafTableInternal.DscLiafTableKey.class);
        key.put(DscLiafTableInternal.DscLiafTableKey.VALUE, value);
        DscLiafTableInternal table = BinaryDescriptionProvider.getInstance().getDscLiafTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscLiafRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for line item action flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(LineActionFlag lineActionFlag) {
        String description = this.getLatestDescription(String.valueOf(lineActionFlag.getValue()));
        lineActionFlag.setDescription(description);
        return description;
    }
}

