/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscValueCodeRowInternal;
import gov.cms.oce.dao.desc.table.DscValueCodeTableInternal;
import gov.cms.oce.dao.dsc.DscValueCodeDao;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscValueCodeDaoImpl
implements DscValueCodeDao {
    private static final Logger logger = LoggerFactory.getLogger(DscValueCodeDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Value code parameter is null/empty.");
            }
            return "";
        }
        Map<DscValueCodeTableInternal.DscValueCodeTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscValueCodeTableInternal.DscValueCodeTableKey.class);
        key.put(DscValueCodeTableInternal.DscValueCodeTableKey.CODE, value);
        DscValueCodeTableInternal table = BinaryDescriptionProvider.getInstance().getDscValueCodeTable();
        DscValueCodeRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for value code \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(ValueCode valueCode, Short version) {
        String description = this.getDescription(valueCode.getCode(), version);
        valueCode.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Value code parameter is null/empty.");
            }
            return "";
        }
        Map<DscValueCodeTableInternal.DscValueCodeTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscValueCodeTableInternal.DscValueCodeTableKey.class);
        key.put(DscValueCodeTableInternal.DscValueCodeTableKey.CODE, value);
        DscValueCodeTableInternal table = BinaryDescriptionProvider.getInstance().getDscValueCodeTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscValueCodeRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(ValueCode valueCode) {
        String description = this.getLatestDescription(valueCode.getCode());
        valueCode.setDescription(description);
        return description;
    }
}

