/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.MapCompositeRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapCompositeTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(MapCompositeTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<MapCompositeRowInternal>> table;

    private MapCompositeTableInternal() {
        this(null);
    }

    public MapCompositeTableInternal(Map<String, List<MapCompositeRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<MapCompositeRowInternal> getRowInternal(Map<MapCompositeTableKey, String> tableKey) {
        List<MapCompositeRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final MapCompositeRowInternal getRowInternal(Map<MapCompositeTableKey, String> tableKey, short version) {
        for (MapCompositeRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum MapCompositeTableKey {
        HCPCS;

    }
}

