/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.OffsetApcRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetApcTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(OffsetApcTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<OffsetApcRowInternal>> table;

    private OffsetApcTableInternal() {
        this(null);
    }

    public OffsetApcTableInternal(Map<String, List<OffsetApcRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<OffsetApcRowInternal> getRowInternal(Map<OffsetApcTableKey, String> tableKey) {
        List<OffsetApcRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final OffsetApcRowInternal getRowInternal(Map<OffsetApcTableKey, String> tableKey, short version) {
        for (OffsetApcRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum OffsetApcTableKey {
        GROUP_ID,
        LIST_ID,
        APC;

    }
}

