/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.OffsetCodepairRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetCodepairTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(OffsetCodepairTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<OffsetCodepairRowInternal>> table;

    private OffsetCodepairTableInternal() {
        this(null);
    }

    public OffsetCodepairTableInternal(Map<String, List<OffsetCodepairRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<OffsetCodepairRowInternal> getRowInternal(Map<OffsetCodepairTableKey, String> tableKey) {
        List<OffsetCodepairRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final OffsetCodepairRowInternal getRowInternal(Map<OffsetCodepairTableKey, String> tableKey, short version) {
        for (OffsetCodepairRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum OffsetCodepairTableKey {
        LIST_ID,
        CODE1,
        CODE2;

    }
}

