/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.initialization;

import gov.cms.oce.logic.AbstractLogicPhasePath;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.initialization.OceDataTableInitialization;
import gov.cms.oce.logic.initialization.OceDescriptionTableInitialization;
import gov.cms.oce.logic.initialization.ValidateHardcodedApc;
import gov.cms.oce.logic.initialization.ValidateHardcodedHcpcs;
import gov.cms.oce.logic.initialization.ValidateHardcodedRevenueCode;
import gov.cms.oce.model.rsc.LogicPhaseFlags;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceInitializationLogicPhasePath
extends AbstractLogicPhasePath {
    private static final Logger logger = LoggerFactory.getLogger(OceInitializationLogicPhasePath.class);

    public OceInitializationLogicPhasePath() {
        super.getFlags().set(LogicPhaseFlags.RUN_ONCE);
    }

    @Override
    public final void configure(ClaimProcessor processor) {
        List<Logic> logicPath = super.getLogicPhasePath();
        logicPath.add(new OceDataTableInitialization());
        logicPath.add(new OceDescriptionTableInitialization());
        logicPath.add(new ValidateHardcodedApc());
        logicPath.add(new ValidateHardcodedHcpcs());
        logicPath.add(new ValidateHardcodedRevenueCode());
        if (logger.isTraceEnabled()) {
            logger.trace("\"{}\" has {} logic blocks.", (Object)this.getClass().getSimpleName(), (Object)super.getLogicPhasePath().size());
        }
    }
}

