/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.PaymentAdjustmentFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalculatePaymentAdjustmentFlag
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CalculatePaymentAdjustmentFlag.class);

    CalculatePaymentAdjustmentFlag() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (!navigator.isInitialized()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping logic block because required navigator isn't available");
            }
            return false;
        }
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (line.getFlags().isSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || line.isPackaged()) continue;
            boolean adjustable = !line.isZeroCharge() || !line.isPackaged();
            FlagSet<LineFlags> flags = line.getFlags();
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_COINS)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_COINS);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_REDUCTION)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_REDUCTION);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_COINS)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_COINS);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_REDUCTION)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_REDUCTION);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_BLOOD_PRODUCT)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_BLOOD_PRODUCT);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_BLOOD_PROCESS)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_BLOOD_PROCESS);
                continue;
            }
            if (line.isNotPackaged() && flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_CT_SCAN_REDUCTION)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_CT_SCAN_REDUCTION);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_1ST)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_1ST);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_2ND)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_2ND);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_3RD)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_3RD);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_TERMINATED)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_TERMINATED);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_CREDIT_TERMINATED)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEVICE_CREDIT_TERMINATED);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_1ST)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_1ST);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_2ND)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_2ND);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_3RD)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_3RD);
                continue;
            }
            if (adjustable && flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_COINS_NA)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_COINS_NA);
                continue;
            }
            if (adjustable && flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_COINS_NA)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_COINS_NA);
                continue;
            }
            if (adjustable && flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA_COINS_REDUCED)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA_COINS_REDUCED);
                continue;
            }
            if (adjustable && flags.anySet(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_PASSTHRU_DRUG_OR_BIOLOGICAL)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_PASSTHRU_DRUG_OR_BIOLOGICAL);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_ADJUSTED_TO_COST)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_ADJUSTED_TO_COST);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_NEW_DRUG_OR_BIOLOGICAL)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_NEW_DRUG_OR_BIOLOGICAL);
                continue;
            }
            if (adjustable && flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_PROVIDER_NO_COST)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_PROVIDER_NO_COST);
                continue;
            }
            if (adjustable && flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_PROVIDER_PARTIAL_CREDIT)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_PROVIDER_PARTIAL_CREDIT);
                continue;
            }
            if (flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_DUAL_ELIGIBLE_PATIENT)) {
                line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_DUAL_ELIGIBLE_PATIENT);
                continue;
            }
            if (!adjustable || !line.isNotPackaged() || !flags.isSet(LineFlags.PAYMENT_ADJUSTMENT_UNITS_REDUCED_TO_ONE)) continue;
            line.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_UNITS_REDUCED_TO_ONE);
        }
        return false;
    }
}

