/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalculatePaymentMethodFlag
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CalculatePaymentMethodFlag.class);

    CalculatePaymentMethodFlag() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        boolean cc07OddPath;
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isClaimProcessed() || claim.getVersionAsPrimitive() == 0) {
            return false;
        }
        boolean bl = cc07OddPath = claim.isConditionCodePresent("07") && claim.getFlags().anySet(ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT) && !claim.matchesBillType("43", "71", "77", "87");
        if (claim.matchesBillType("13")) {
            block86: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                switch (line.getStatusIndicator().getValue()) {
                    case "A": 
                    case "F": 
                    case "L": {
                        line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                        line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                        continue block86;
                    }
                    case "B": 
                    case "C": 
                    case "E": 
                    case "E1": 
                    case "E2": 
                    case "M": 
                    case "Q1": 
                    case "Q2": 
                    case "Q3": 
                    case "Q4": 
                    case "W": 
                    case "Y": 
                    case "Z": {
                        line.setPaymentMethodFlag("1");
                        line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                        continue block86;
                    }
                }
                if (line.matchesStatusIndicator("G", "K")) {
                    line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                    continue;
                }
                line.setPaymentMethodFlag("0");
            }
        } else if (claim.matchesBillType("12", "14")) {
            if (claim.isConditionCodePresent("41")) {
                for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    line.setPaymentMethodFlag("1");
                    line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                }
            } else {
                block88: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    switch (line.getStatusIndicator().getValue()) {
                        case "A": 
                        case "F": 
                        case "L": {
                            line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                            line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                            continue block88;
                        }
                        case "B": 
                        case "C": 
                        case "E": 
                        case "E1": 
                        case "E2": 
                        case "M": 
                        case "Q1": 
                        case "Q2": 
                        case "Q3": 
                        case "Q4": 
                        case "W": 
                        case "Y": 
                        case "Z": {
                            line.setPaymentMethodFlag("1");
                            line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                            continue block88;
                        }
                    }
                    if (line.matchesStatusIndicator("G", "K")) {
                        line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                        continue;
                    }
                    line.setPaymentMethodFlag("0");
                }
            }
        } else if (claim.matchesBillType("34")) {
            block89: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                if (line.getFlags().anySet((LineFlags)new LineFlags[]{LineFlags.DATA_HCPCS_ANTIGEN, LineFlags.DATA_HCPCS_CAST, LineFlags.DATA_HCPCS_SPLINT, LineFlags.DATA_HCPCS_VACCINE, LineFlags.DATA_HCPCS_NEGATIVE_PRESSURE_WOUND_THERAPY})) {
                    line.setPaymentMethodFlag("0");
                    continue;
                }
                switch (line.getStatusIndicator().getValue()) {
                    case "C": 
                    case "E": 
                    case "E1": 
                    case "E2": 
                    case "M": 
                    case "W": 
                    case "Y": 
                    case "Z": {
                        line.setPaymentMethodFlag("1");
                        line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                        continue block89;
                    }
                }
                line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
            }
        } else if (claim.matchesBillType("75")) {
            block90: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                if (cc07OddPath && line.getFlags().anySet(LineFlags.DATA_HCPCS_ANTIGEN, LineFlags.DATA_HCPCS_CAST, LineFlags.DATA_HCPCS_SPLINT)) {
                    line.setPaymentMethodFlag("0");
                    continue;
                }
                switch (line.getStatusIndicator().getValue()) {
                    case "C": 
                    case "E": 
                    case "E1": 
                    case "E2": 
                    case "M": 
                    case "W": 
                    case "Y": 
                    case "Z": {
                        line.setPaymentMethodFlag("1");
                        line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                        continue block90;
                    }
                }
                line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
            }
        } else if (claim.matchesBillType("76")) {
            boolean ccMYPath = false;
            boolean cc66Path = false;
            if (claim.isClaimVersionAfter(65)) {
                ccMYPath = claim.isConditionCodePresent("MY");
                cc66Path = claim.isConditionCodePresent("66");
            }
            block91: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                if (line.isPackaged() || line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE)) {
                    if (ccMYPath) {
                        line.setPaymentMethodFlag("9");
                        continue;
                    }
                    if (cc66Path) {
                        line.setPaymentMethodFlag("6");
                        continue;
                    }
                    line.setPaymentMethodFlag("0");
                    continue;
                }
                if (line.getFlags().isNotSet(LineFlags.INPUT_INVALID_HCPCS) && line.matchesHcpcs(HardcodedHcpcsSet.TELEHEALTH_G2025, HardcodedHcpcsSet.TELEHEALTH_Q3041)) {
                    line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                    line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                    continue;
                }
                HardcodedApcSet hardcodedApc = HardcodedApcSet.getHardcodedApc(line.getPaymentApc().getValue());
                if (hardcodedApc == null) {
                    hardcodedApc = HardcodedApcSet.APC_ZERO;
                }
                switch (hardcodedApc) {
                    case PH_APC1_2016: 
                    case PH_APC2_2016: 
                    case PH_APC_2017: 
                    case CMHC_APC1_2016: 
                    case CMHC_APC2_2016: {
                        if (ccMYPath) {
                            line.setPaymentMethodFlag("9");
                            continue block91;
                        }
                        if (cc66Path) {
                            line.setPaymentMethodFlag("6");
                            continue block91;
                        }
                        line.setPaymentMethodFlag("0");
                        continue block91;
                    }
                }
                line.setPaymentMethodFlag("1");
                line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
            }
        } else if (claim.isClaimVersionAfter(56) && claim.matchesBillType("77") && (claim.isClaimVersionAfter(80) || !claim.isConditionCodePresent("65"))) {
            for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                line.setPaymentMethodFlag("5");
                line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
            }
        } else {
            block93: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                if (cc07OddPath && line.getFlags().anySet(LineFlags.DATA_HCPCS_ANTIGEN, LineFlags.DATA_HCPCS_CAST, LineFlags.DATA_HCPCS_SPLINT)) {
                    line.setPaymentMethodFlag("0");
                    continue;
                }
                switch (line.getStatusIndicator().getValue()) {
                    case "C": 
                    case "E": 
                    case "E1": 
                    case "E2": 
                    case "M": 
                    case "W": 
                    case "Y": 
                    case "Z": {
                        line.setPaymentMethodFlag("1");
                        line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                        continue block93;
                    }
                }
                line.setPaymentMethodFlag(line.isRejectedDenied() ? "3" : "2");
                line.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
            }
        }
        return false;
    }
}

