/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.AbstractLogicPhasePath;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.postprocessing.CalculateDiscount;
import gov.cms.oce.logic.postprocessing.CalculateDisposition;
import gov.cms.oce.logic.postprocessing.CalculatePaymentAdjustmentFlag;
import gov.cms.oce.logic.postprocessing.CalculatePaymentMethodFlag;
import gov.cms.oce.logic.postprocessing.CalculateUnits;
import gov.cms.oce.logic.postprocessing.CaptureTimeEnded;
import gov.cms.oce.logic.postprocessing.ContractorOverride;
import gov.cms.oce.logic.postprocessing.CopyOutputToExternalClaim;
import gov.cms.oce.logic.postprocessing.InitializePaymentAdjustmentFlag;
import gov.cms.oce.logic.postprocessing.NonOppsOverride;
import gov.cms.oce.logic.postprocessing.PaymentMethodFqhcOverride;
import gov.cms.oce.logic.postprocessing.PaymentMethodRoModelOverride;
import gov.cms.oce.logic.postprocessing.PaymentMethodSection603Override;
import gov.cms.oce.logic.postprocessing.ReturnCodeCheck;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.HardcodedBillTypeSet;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcePostProcessingLogicPhasePath
extends AbstractLogicPhasePath {
    private static final Logger logger = LoggerFactory.getLogger(OcePostProcessingLogicPhasePath.class);

    @Override
    public final void configure(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<Logic> logicPath = super.getLogicPhasePath();
        if (HardcodedBillTypeSet.isLineBufferComplete(claim)) {
            logicPath.add(new InitializePaymentAdjustmentFlag());
            logicPath.add(new CalculatePaymentAdjustmentFlag());
            logicPath.add(new CalculateDiscount());
        }
        logicPath.add(new CalculateUnits());
        if (claim.isOpps()) {
            logicPath.add(new CalculatePaymentMethodFlag());
            if (claim.isOpps() && claim.isClaimVersionAfter(65) && claim.matchesBillType("13", "76")) {
                logicPath.add(new PaymentMethodSection603Override());
            }
            if (claim.matchesBillType("77") && (claim.isClaimVersionAfter(80) || !claim.isConditionCodePresent("65")) && OceClaimUtility.isCsModifierApplicable(claim)) {
                logicPath.add(new PaymentMethodFqhcOverride());
            }
            if (claim.isClaimVersionAfter(79) && claim.matchesBillType("13") && !claim.isConditionCodePresent("41", "89")) {
                logicPath.add(new PaymentMethodRoModelOverride());
            }
        }
        logicPath.add(new CalculateDisposition());
        if (claim.isNonOpps()) {
            logicPath.add(new NonOppsOverride());
        }
        if (claim.matchesBillType("12", "14") && claim.isConditionCodePresent("41")) {
            if (logger.isTraceEnabled()) {
                logger.trace("Bill type is not applicable for contractor override operation.");
            }
        } else {
            logicPath.add(new ContractorOverride());
        }
        logicPath.add(new ReturnCodeCheck());
        logicPath.add(new CopyOutputToExternalClaim());
        logicPath.add(new CaptureTimeEnded());
        if (logger.isTraceEnabled()) {
            logger.trace("\"{}\" has {} logic blocks.", (Object)this.getClass().getSimpleName(), (Object)super.getLogicPhasePath().size());
        }
    }
}

