/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.dao.data.VersionRangeDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.Version;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitializeVersion
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InitializeVersion.class);

    InitializeVersion() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim;
        VersionRangeDao dao;
        block17: {
            LocalDate latestDate;
            LocalDate earliestDate;
            dao = processor.getResourceManager().getDataDaoFactory().getVersionRangeDao();
            claim = processor.getInternalClaim();
            if (claim.getFlags().isSet(ClaimFlags.INPUT_INVALID_DATE_STARTED)) {
                claim.getFlags().set(ClaimFlags.FATAL_VERSION_COULD_NOT_BE_CALCULATED);
                claim.setReturnCode(ReturnCode.BAD_FROM_DATE);
                return true;
            }
            try {
                LocalDate claimDate = claim.getDateStarted().getValueAsDate();
                earliestDate = dao.getEarliestDate();
                if (claimDate.isBefore(earliestDate)) {
                    claim.assignEdit(EditValue.DATE_OUT_OF_RANGE);
                    claim.setReturnCode(ReturnCode.DATE_VERSION, ClaimProcessedValue.ONE);
                    return true;
                }
                latestDate = dao.getLatestDate();
                LocalDate finalAcceptedDate = latestDate.minusDays(1L);
                if (claimDate.isAfter(finalAcceptedDate)) {
                    claim.assignEdit(EditValue.DATE_OUT_OF_RANGE);
                    claim.setReturnCode(ReturnCode.DATE_VERSION, ClaimProcessedValue.ONE);
                    return true;
                }
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Claim start date outside of acceptable version date range.", e);
                }
                return true;
            }
            if (claim.getFlags().isSet(ClaimFlags.INPUT_INVALID_RECEIPT_DATE)) {
                claim.assignEdit(EditValue.INVALID_RECEIPT_DATE);
                claim.setReturnCode(ReturnCode.INVALID_RECEIPT_DATE, ClaimProcessedValue.ONE);
                return true;
            }
            LocalDate receiptDate = claim.getReceiptDate().getValueAsDate();
            if (receiptDate == null) {
                try {
                    Version receiptDateVersion = dao.getVersion(claim.getDateEnded());
                    claim.getReceiptDateVersion().setVersion(receiptDateVersion.getValue(), receiptDateVersion.getDateStarted(), receiptDateVersion.getDateEnded(), receiptDateVersion.getVersionId());
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Failed to calculate receipt date version.", e);
                    }
                    break block17;
                }
            }
            earliestDate = dao.getEarliestDate();
            latestDate = dao.getLatestDate();
            if (receiptDate.isBefore(earliestDate) || receiptDate.isAfter(latestDate)) {
                claim.assignEdit(EditValue.INVALID_RECEIPT_DATE);
                claim.setReturnCode(ReturnCode.INVALID_RECEIPT_DATE, ClaimProcessedValue.ONE);
                return true;
            }
            try {
                Version receiptDateVersion = dao.getVersion(claim.getReceiptDate());
                claim.getReceiptDateVersion().setVersion(receiptDateVersion.getValue(), receiptDateVersion.getDateStarted(), receiptDateVersion.getDateEnded(), receiptDateVersion.getVersionId());
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block17;
                logger.trace("Failed to calculate receipt date version.", e);
            }
        }
        try {
            Version version = dao.getVersion(claim.getDateStarted());
            claim.getVersion().setVersion(version.getValue(), version.getDateStarted(), version.getDateEnded(), version.getVersionId());
            claim.getProcessingInformation().setVersion(version.getVersionId());
            claim.getProcessingInformation().setInternalVersion(version.getValue());
        }
        catch (Exception e) {
            claim.getFlags().set(ClaimFlags.FATAL_VERSION_COULD_NOT_BE_CALCULATED);
            if (logger.isTraceEnabled()) {
                logger.trace("Failed to calculate version.", e);
            }
            return true;
        }
        return false;
    }
}

