/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.dao.data.DataEditBypassDao;
import gov.cms.oce.dao.data.row.DataEditBypassRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateContractorOverrideData
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ValidateContractorOverrideData.class);

    ValidateContractorOverrideData() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        short version = claim.getVersionAsPrimitive();
        DataEditBypassDao dataEditBypassDao = processor.getResourceManager().getDataDaoFactory().getDataEditBypassDao();
        for (LineItemInternal line : claim.getLineItemList().getValue()) {
            if (!line.getFlags().isSet(LineFlags.CONTRACTOR_OVERRIDE_EDIT_INVALID)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Invalid Edit detected. Aborting...");
            }
            claim.setReturnCode(ReturnCode.INVALID_EDIT_BYPASS, ClaimProcessedValue.FOUR);
            return true;
        }
        for (LineItemInternal line : claim.getLineItemList().getValue()) {
            if (!line.matchesActionFlag(0)) continue;
            for (EditValue editValue : line.getEditBypass().getEditBypassList().getValue()) {
                if (editValue == EditValue.NO_EDIT) break;
                DataEditBypassRowInternal row = dataEditBypassDao.getRow(editValue.getValue(), (Short)version);
                if (row == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Edit \"{}\" not found in EditBypass table. Aborting...", (Object)editValue);
                    }
                    claim.setReturnCode(ReturnCode.INVALID_EDIT_BYPASS, ClaimProcessedValue.FOUR);
                    return true;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Edit \"{}\" found in EditBypass table with the \"line bypass required\" flag set to \"{}\".", (Object)editValue, (Object)row.isLineBypassRequired());
                }
                if (row.isLineBypassRequired()) {
                    if (claim.isOpps()) {
                        if (line.getFlags().anySet((LineFlags)new LineFlags[]{LineFlags.CONTRACTOR_BYPASS_APC_INVALID, LineFlags.CONTRACTOR_BYPASS_SI_INVALID, LineFlags.CONTRACTOR_BYPASS_PI_INVALID, LineFlags.CONTRACTOR_BYPASS_DISCOUNTING_FORMULA_INVALID, LineFlags.CONTRACTOR_BYPASS_REJECTION_DENIAL_INVALID, LineFlags.CONTRACTOR_BYPASS_PACKAGING_FLAG_INVALID, LineFlags.CONTRACTOR_BYPASS_PAYMENT_ADJUSTMENT_01_FLAG_INVALID, LineFlags.CONTRACTOR_BYPASS_PAYMENT_METHOD_FLAG_INVALID, LineFlags.CONTRACTOR_BYPASS_PAYMENT_ADJUSTMENT_02_FLAG_INVALID})) {
                            if (logger.isTraceEnabled()) {
                                if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_APC_INVALID)) {
                                    logger.trace("Edit \"{}\" override APC value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_SI_INVALID)) {
                                    logger.trace("Edit \"{}\" override SI value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_PI_INVALID)) {
                                    logger.trace("Edit \"{}\" override PI value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_DISCOUNTING_FORMULA_INVALID)) {
                                    logger.trace("Edit \"{}\" override discount formula value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_REJECTION_DENIAL_INVALID)) {
                                    logger.trace("Edit \"{}\" override rejection/denial flag value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_PACKAGING_FLAG_INVALID)) {
                                    logger.trace("Edit \"{}\" override packagin flag value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_PAYMENT_ADJUSTMENT_01_FLAG_INVALID)) {
                                    logger.trace("Edit \"{}\" override payment adjustment flag 1 value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_PAYMENT_METHOD_FLAG_INVALID)) {
                                    logger.trace("Edit \"{}\" override payment method flag value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                } else if (line.getFlags().isSet(LineFlags.CONTRACTOR_BYPASS_PAYMENT_ADJUSTMENT_02_FLAG_INVALID)) {
                                    logger.trace("Edit \"{}\" override payment adjustment flag 2 value invalid for line \"{}\".", (Object)editValue, (Object)line.getDay().getIndex());
                                }
                            }
                            claim.setReturnCode(ReturnCode.INVALID_BYPASS_VALUE, ClaimProcessedValue.FOUR);
                            return true;
                        }
                        line.getEditBypassEditSet().add(editValue);
                        line.getFlags().set(LineFlags.LINE_OUTPUT_BYPASS);
                        continue;
                    }
                    line.getEditBypassEditSet().add(editValue);
                    line.getFlags().set(LineFlags.LINE_OUTPUT_BYPASS);
                    continue;
                }
                claim.getEditBypassEditSet().add(editValue);
            }
        }
        return false;
    }
}

