/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateServiceDate
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ValidateServiceDate.class);

    ValidateServiceDate() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.matchesBillType("32G")) {
            if (logger.isTraceEnabled()) {
                logger.trace("Edit 23 bypassed because of presence of bill type 32G or 77x with condition code 65.");
            }
        } else {
            boolean returnCodeAssigned = false;
            for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().anySet(LineFlags.INPUT_EMPTY_SERVICE_DATE, LineFlags.INPUT_INVALID_SERVICE_DATE, LineFlags.INPUT_SERVICE_DATE_EARLIER_THAN_CLAIM_START_DATE, LineFlags.INPUT_SERVICE_DATE_LATER_THAN_CLAIM_END_DATE) || HardcodedRevenueCodeSet.isHippsCode(line.getRevenueCode()) && claim.matchesBillType("32") || !line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                claim.assignEdit(EditValue.INVALID_DATE_2, line);
                if (returnCodeAssigned) continue;
                claim.setReturnCode(ReturnCode.BAD_LINE_DATE, ClaimProcessedValue.ONE);
                returnCodeAssigned = true;
            }
            if (returnCodeAssigned) {
                return true;
            }
        }
        return false;
    }
}

