/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapAddonType1And3Dao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.LineSpan;
import gov.cms.oce.util.Navigator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddonType1And3Pair85xLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(AddonType1And3Pair85xLogic.class);

    AddonType1And3Pair85xLogic() {
    }

    private final boolean isAddonSatisfied(MapAddonType1And3Dao dao, short version, LineSpan lineSpan, LineItemInternal line) {
        if (line.getFlags().noneSet(LineFlags.DATA_HCPCS_ADDON_TYPE1, LineFlags.DATA_HCPCS_ADDON_TYPE3)) {
            return true;
        }
        for (LineItemInternal primary : lineSpan.getList()) {
            if (line.equals(primary) || line.isServiceDateBefore(primary.getServiceDate().getValueAsDate()) || !primary.getFlags().noneSet(LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !HardcodedRevenueCodeSet.matchesProfessionalServicePolarity(line, primary) || dao.getRow(line, primary, version) == null || !this.isAddonSatisfied(dao, version, lineSpan, primary)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapAddonType1And3Dao dao = processor.getResourceManager().getDataDaoFactory().getMapAddonType1And3Dao();
        short version = claim.getVersionAsPrimitive();
        List<LineSpan> lineSpanList = navigator.getPrecedingLineWindowList(2);
        for (LineSpan lineSpan : lineSpanList) {
            for (LineItemInternal line : lineSpan.getList()) {
                if (!this.isAddonSatisfied(dao, version, lineSpan, line)) continue;
                line.getFlags().set(LineFlags.ADDON_SATISFIED);
            }
        }
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.ADDON_SATISFIED, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_LINE_EDIT_BYPASS, LineFlags.INPATIENT_LINE)) continue;
            if (line.getFlags().isSet(LineFlags.DATA_HCPCS_ADDON_TYPE1)) {
                claim.assignEdit(EditValue.ADDON_TYPE_ONE_MISSING_PRIMARY, line);
                continue;
            }
            if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_ADDON_TYPE3)) continue;
            claim.assignEdit(EditValue.ADDON_TYPE_THREE_MISSING_PRIMARY, line);
        }
        return false;
    }
}

