/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BilateralUnitsModifierConflict85xLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BilateralUnitsModifierConflict85xLogic.class);

    BilateralUnitsModifierConflict85xLogic() {
    }

    private final String createKey(LineItemInternal line) {
        return line.getHcpcs().getValue() + line.getRevenueCode().getValue();
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            if (day.isEmpty()) continue;
            HashMap<String, LineGroup> lineGroupMap = new HashMap<String, LineGroup>();
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet((LineFlags)new LineFlags[]{LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_REVENUE_CODE}) || !line.getFlags().anySet(LineFlags.DATA_HCPCS_BILATERAL_CONDITIONAL, LineFlags.DATA_HCPCS_BILATERAL_INDEPENDENT) || !HardcodedRevenueCodeSet.isProfessionalService(line.getRevenueCode()) || line.getHcpcsModifierInputList().getCount() != 0 && (line.getHcpcsModifierInputList().getCount() != 1 || !line.isHcpcsModifierPresent("50"))) continue;
                lineGroupMap.computeIfAbsent(this.createKey(line), v -> new LineGroup()).addLine(line);
            }
            for (LineGroup lineGroup : lineGroupMap.values()) {
                if (!lineGroup.isModifier50Present() || 1 >= lineGroup.getTotalUnitCount()) continue;
                for (LineItemInternal line : lineGroup.lineList) {
                    claim.assignEdit(EditValue.BILATERAL_UNITS_MODIFIFER_50_CONFLICT, line);
                }
            }
        }
        return false;
    }

    private final class LineGroup {
        private final List<LineItemInternal> lineList = new ArrayList<LineItemInternal>();

        private LineGroup() {
        }

        private final boolean addLine(LineItemInternal line) {
            return this.lineList.add(line);
        }

        private final boolean isModifier50Present() {
            return this.lineList.stream().anyMatch(line -> line.isHcpcsModifierPresent("50"));
        }

        private final int getTotalUnitCount() {
            return this.lineList.stream().mapToInt(LineItemInternal::getUnitsAsPrimitive).sum();
        }
    }
}

