/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.processing.AddonCovidPairLogic;
import gov.cms.oce.logic.processing.AddonDrugPairLogic;
import gov.cms.oce.logic.processing.AddonType1And3PairLogic;
import gov.cms.oce.logic.processing.BiosimilarBundledBiologicalLogic;
import gov.cms.oce.logic.processing.BiosimilarLogic;
import gov.cms.oce.logic.processing.ClaimAgeLogic;
import gov.cms.oce.logic.processing.ClaimSexLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForDenialLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForReviewLogic;
import gov.cms.oce.logic.processing.CsModifierLogic;
import gov.cms.oce.logic.processing.CsModifierMidQuarterTerminationLogic;
import gov.cms.oce.logic.processing.DiagnosisAgeLogic;
import gov.cms.oce.logic.processing.DiagnosisEcodeLogic;
import gov.cms.oce.logic.processing.DiagnosisInvalidLogic;
import gov.cms.oce.logic.processing.DiagnosisManifestationLogic;
import gov.cms.oce.logic.processing.DiagnosisSexLogic;
import gov.cms.oce.logic.processing.DiagnosisUnacceptablePrincipalLogic;
import gov.cms.oce.logic.processing.HcpcsAgeInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsMidQuarterTerminationLogic;
import gov.cms.oce.logic.processing.HcpcsModifierConflictLogic;
import gov.cms.oce.logic.processing.HcpcsModifierInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsSexLogic;
import gov.cms.oce.logic.processing.LabServiceOverrideLogic;
import gov.cms.oce.logic.processing.NcciLogic;
import gov.cms.oce.logic.processing.NonCoveredHcpcsLogic;
import gov.cms.oce.logic.processing.NonCoveredRevenueCodeLogic;
import gov.cms.oce.logic.processing.NonReportableSiteOfServiceLogic;
import gov.cms.oce.logic.processing.ObservationRevenueCodeLogic;
import gov.cms.oce.logic.processing.OutpatientHospitalCodeOnlyLogic;
import gov.cms.oce.logic.processing.QuestionableLogic;
import gov.cms.oce.logic.processing.ReportedAfterNcdTerminationDateLogic;
import gov.cms.oce.logic.processing.ReportedOutsideCmsApprovalPeriodLogic;
import gov.cms.oce.logic.processing.ReportedPriorToFdaApprovalDateLogic;
import gov.cms.oce.logic.processing.ReportedPriorToInitialMarketingDate;
import gov.cms.oce.logic.processing.ReportedPriorToNdaApprovalDateLogic;
import gov.cms.oce.logic.processing.RevenueCodeInvalidLogic;
import gov.cms.oce.logic.processing.RevenueCodeNotRecognizedLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionHcpcsLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionRevenueCodeLogic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BillType32xLogicPath
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BillType32xLogicPath.class);

    BillType32xLogicPath() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        LogicProcessor logicProcessor = processor.getResourceManager().getLogicProcessor();
        LogicPhasePath logicPhasePath = logicProcessor.getLogicPhasePath(LogicPhase.PROCESSING);
        List<Logic> logicPath = logicPhasePath.getLogicPhasePath();
        OceClaimInternal claim = processor.getInternalClaim();
        logicPath.add(new ClaimSubmittedForDenialLogic());
        logicPath.add(new LabServiceOverrideLogic());
        logicPath.add(new OutpatientHospitalCodeOnlyLogic());
        if (claim.isClaimVersionAfter(70)) {
            if (claim.isClaimVersionAfter(81)) {
                logicPath.add(new AddonCovidPairLogic());
            }
            logicPath.add(new AddonType1And3PairLogic());
            logicPath.add(new AddonDrugPairLogic());
        }
        if (OceClaimUtility.isCsModifierApplicable(claim)) {
            logicPath.add(new CsModifierLogic());
        }
        logicPath.add(new ClaimAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new ClaimSexLogic());
        }
        logicPath.add(new DiagnosisInvalidLogic());
        logicPath.add(new DiagnosisAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new DiagnosisSexLogic());
        }
        logicPath.add(new DiagnosisEcodeLogic());
        if (claim.isClaimVersionAfter(56)) {
            logicPath.add(new DiagnosisManifestationLogic());
            if (claim.isClaimVersionAfter(76)) {
                logicPath.add(new DiagnosisUnacceptablePrincipalLogic());
            }
        }
        logicPath.add(new RevenueCodeInvalidLogic());
        logicPath.add(new ObservationRevenueCodeLogic());
        logicPath.add(new RevenueCodeNotRecognizedLogic());
        logicPath.add(new BiosimilarLogic());
        logicPath.add(new BiosimilarBundledBiologicalLogic());
        logicPath.add(new ReportedPriorToInitialMarketingDate());
        logicPath.add(new HcpcsAgeInvalidLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new HcpcsSexLogic());
        }
        logicPath.add(new ReportedOutsideCmsApprovalPeriodLogic());
        logicPath.add(new NonCoveredHcpcsLogic());
        logicPath.add(new QuestionableLogic());
        logicPath.add(new StatutoryExclusionHcpcsLogic());
        logicPath.add(new ClaimSubmittedForReviewLogic());
        logicPath.add(new NonCoveredRevenueCodeLogic());
        logicPath.add(new StatutoryExclusionRevenueCodeLogic());
        logicPath.add(new HcpcsInvalidLogic());
        logicPath.add(new HcpcsModifierInvalidLogic());
        logicPath.add(new HcpcsModifierConflictLogic());
        logicPath.add(new NcciLogic());
        if (claim.isClaimVersionAfter(87)) {
            logicPath.add(new CsModifierMidQuarterTerminationLogic());
            logicPath.add(new HcpcsMidQuarterTerminationLogic());
        }
        logicPath.add(new ReportedPriorToFdaApprovalDateLogic());
        logicPath.add(new ReportedPriorToNdaApprovalDateLogic());
        logicPath.add(new ReportedAfterNcdTerminationDateLogic());
        logicPath.add(new NonReportableSiteOfServiceLogic());
        return false;
    }
}

