/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.processing.AcquiredDrug340BLogic;
import gov.cms.oce.logic.processing.AddonCovidPairLogic;
import gov.cms.oce.logic.processing.AdvanceCarePlanningLogic;
import gov.cms.oce.logic.processing.AllogeneicTransplantLogic;
import gov.cms.oce.logic.processing.AssignDefaultApcLogic;
import gov.cms.oce.logic.processing.BiosimilarBundledBiologicalLogic;
import gov.cms.oce.logic.processing.BiosimilarLogic;
import gov.cms.oce.logic.processing.BloodLogic;
import gov.cms.oce.logic.processing.BloodProductRevenueCodeConflictLogic;
import gov.cms.oce.logic.processing.BloodServiceMissingProductLogic;
import gov.cms.oce.logic.processing.ClaimAgeLogic;
import gov.cms.oce.logic.processing.ClaimSexLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForDenialLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForReviewLogic;
import gov.cms.oce.logic.processing.CompositeImagingLogic;
import gov.cms.oce.logic.processing.CompositeLdrLogic;
import gov.cms.oce.logic.processing.ConditionalClaimLogic;
import gov.cms.oce.logic.processing.ConditionalDayLogic;
import gov.cms.oce.logic.processing.CriticalCareClaimLogic;
import gov.cms.oce.logic.processing.CriticalCareDayLogic;
import gov.cms.oce.logic.processing.CsModifierLogic;
import gov.cms.oce.logic.processing.CsModifierMidQuarterTerminationLogic;
import gov.cms.oce.logic.processing.DiagnosisAgeLogic;
import gov.cms.oce.logic.processing.DiagnosisEcodeLogic;
import gov.cms.oce.logic.processing.DiagnosisInvalidLogic;
import gov.cms.oce.logic.processing.DiagnosisSexLogic;
import gov.cms.oce.logic.processing.DiagnosisUnacceptablePrincipalLogic;
import gov.cms.oce.logic.processing.DrugBiologicalMissingPayableServiceLogic;
import gov.cms.oce.logic.processing.HcpcsAgeInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsMidQuarterTerminationLogic;
import gov.cms.oce.logic.processing.HcpcsSexLogic;
import gov.cms.oce.logic.processing.ImplantationDeviceInconsistencyLogic;
import gov.cms.oce.logic.processing.ImplantationDeviceProcedureMissingDevice;
import gov.cms.oce.logic.processing.ImplantationPrimaryCodeRequiredForAddonCodeLogic;
import gov.cms.oce.logic.processing.InpatientDayDeniedLogic;
import gov.cms.oce.logic.processing.LabServiceOverrideLogic;
import gov.cms.oce.logic.processing.NcciLogic;
import gov.cms.oce.logic.processing.NonCoveredHcpcsLogic;
import gov.cms.oce.logic.processing.NonCoveredRevenueCodeLogic;
import gov.cms.oce.logic.processing.NonReportableSiteOfServiceLogic;
import gov.cms.oce.logic.processing.NonStandardCtScanLogic;
import gov.cms.oce.logic.processing.NotRecognizedByMedicareLogic;
import gov.cms.oce.logic.processing.NotRecognizedByOppsLogic;
import gov.cms.oce.logic.processing.NotSeparatelyPayableServiceLogic;
import gov.cms.oce.logic.processing.ObservationRevenueCodeLogic;
import gov.cms.oce.logic.processing.OutpatientHospitalCodeOnlyLogic;
import gov.cms.oce.logic.processing.QuestionableLogic;
import gov.cms.oce.logic.processing.ReportedAfterNcdTerminationDateLogic;
import gov.cms.oce.logic.processing.ReportedOutsideCmsApprovalPeriodLogic;
import gov.cms.oce.logic.processing.ReportedPriorToFdaApprovalDateLogic;
import gov.cms.oce.logic.processing.ReportedPriorToInitialMarketingDate;
import gov.cms.oce.logic.processing.ReportedPriorToNdaApprovalDateLogic;
import gov.cms.oce.logic.processing.RevenueCodeInvalidLogic;
import gov.cms.oce.logic.processing.RevenueCodeNotRecognizedLogic;
import gov.cms.oce.logic.processing.SeparateProcedureNotPaidLogic;
import gov.cms.oce.logic.processing.SkinSubstitute2Logic;
import gov.cms.oce.logic.processing.SometimesTherapyLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionHcpcsLogic;
import gov.cms.oce.logic.processing.StatutoryExclusionRevenueCodeLogic;
import gov.cms.oce.logic.processing.TokenChargesDrugLogic;
import gov.cms.oce.logic.processing.TokenChargesEditLogic;
import gov.cms.oce.logic.processing.TokenChargesPackagingLogic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BillType34xLogicPath
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BillType34xLogicPath.class);

    BillType34xLogicPath() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        LogicProcessor logicProcessor = processor.getResourceManager().getLogicProcessor();
        LogicPhasePath logicPhasePath = logicProcessor.getLogicPhasePath(LogicPhase.PROCESSING);
        List<Logic> logicPath = logicPhasePath.getLogicPhasePath();
        OceClaimInternal claim = processor.getInternalClaim();
        logicPath.add(new ClaimSubmittedForDenialLogic());
        logicPath.add(new LabServiceOverrideLogic());
        logicPath.add(new NonStandardCtScanLogic());
        logicPath.add(new OutpatientHospitalCodeOnlyLogic());
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
            logicPath.add(new AssignDefaultApcLogic());
            logicPath.add(new InpatientDayDeniedLogic());
        }
        if (claim.isClaimVersionAfter(81)) {
            logicPath.add(new AddonCovidPairLogic());
        }
        if (claim.isOpps()) {
            if (claim.getFlags().anySet(ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT)) {
                logicPath.add(new SometimesTherapyLogic());
            }
            if (claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
                logicPath.add(new AdvanceCarePlanningLogic());
            }
        }
        if (OceClaimUtility.isCsModifierApplicable(claim)) {
            logicPath.add(new CsModifierLogic());
        }
        logicPath.add(new ClaimAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new ClaimSexLogic());
        }
        logicPath.add(new DiagnosisInvalidLogic());
        logicPath.add(new DiagnosisAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new DiagnosisSexLogic());
        }
        logicPath.add(new DiagnosisEcodeLogic());
        if (claim.isClaimVersionAfter(76)) {
            logicPath.add(new DiagnosisUnacceptablePrincipalLogic());
        }
        logicPath.add(new RevenueCodeInvalidLogic());
        logicPath.add(new ObservationRevenueCodeLogic());
        logicPath.add(new RevenueCodeNotRecognizedLogic());
        logicPath.add(new BiosimilarLogic());
        logicPath.add(new BiosimilarBundledBiologicalLogic());
        logicPath.add(new ReportedPriorToInitialMarketingDate());
        logicPath.add(new HcpcsAgeInvalidLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new HcpcsSexLogic());
        }
        logicPath.add(new ReportedOutsideCmsApprovalPeriodLogic());
        logicPath.add(new NonCoveredHcpcsLogic());
        logicPath.add(new QuestionableLogic());
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
            logicPath.add(new NotRecognizedByMedicareLogic());
            logicPath.add(new NotRecognizedByOppsLogic());
        }
        logicPath.add(new StatutoryExclusionHcpcsLogic());
        logicPath.add(new ClaimSubmittedForReviewLogic());
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
            logicPath.add(new BloodServiceMissingProductLogic());
        }
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
            logicPath.add(new DrugBiologicalMissingPayableServiceLogic());
        }
        logicPath.add(new NonCoveredRevenueCodeLogic());
        logicPath.add(new StatutoryExclusionRevenueCodeLogic());
        logicPath.add(new HcpcsInvalidLogic());
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
            logicPath.add(new AllogeneicTransplantLogic());
            logicPath.add(new BloodProductRevenueCodeConflictLogic());
            logicPath.add(new BloodLogic());
        }
        logicPath.add(new NcciLogic());
        if (claim.isClaimVersionAfter(87)) {
            logicPath.add(new CsModifierMidQuarterTerminationLogic());
            logicPath.add(new HcpcsMidQuarterTerminationLogic());
        }
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY}) && claim.isClaimVersionAfter(86)) {
            logicPath.add(new AcquiredDrug340BLogic());
        }
        logicPath.add(new ReportedPriorToFdaApprovalDateLogic());
        logicPath.add(new ReportedPriorToNdaApprovalDateLogic());
        logicPath.add(new ReportedAfterNcdTerminationDateLogic());
        logicPath.add(new NonReportableSiteOfServiceLogic());
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
            if (claim.isClaimVersionBefore(66)) {
                logicPath.add(new ConditionalDayLogic());
                logicPath.add(new CriticalCareDayLogic());
            } else {
                logicPath.add(new ConditionalClaimLogic());
                logicPath.add(new CriticalCareClaimLogic());
            }
            if (claim.isClaimVersionBefore(70)) {
                logicPath.add(new CompositeLdrLogic());
            }
            logicPath.add(new CompositeImagingLogic());
            logicPath.add(new ImplantationDeviceInconsistencyLogic());
            logicPath.add(new ImplantationDeviceProcedureMissingDevice());
            logicPath.add(new ImplantationPrimaryCodeRequiredForAddonCodeLogic());
            logicPath.add(new TokenChargesEditLogic());
            logicPath.add(new SeparateProcedureNotPaidLogic());
            logicPath.add(new SkinSubstitute2Logic());
            logicPath.add(new TokenChargesPackagingLogic());
            if (claim.isClaimVersionAfter(83)) {
                logicPath.add(new TokenChargesDrugLogic());
            }
        }
        if (claim.isOpps() && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY})) {
            logicPath.add(new NotSeparatelyPayableServiceLogic());
        }
        return false;
    }
}

