/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.dao.data.MapCompositeDao;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.dao.data.row.MapCompositeRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.PaymentIndicator;
import gov.cms.oce.model.internal.StatusIndicator;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.model.rsc.Sequencer;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeLdrLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CompositeLdrLogic.class);
    private static final byte MAX_COMP1 = 2;

    CompositeLdrLogic() {
    }

    private final CompositeLine createCompositeLine(LineItemInternal line, MapCompositeRowInternal mapCompositeRow, DataApcRowInternal dataApcRow) {
        return new CompositeLine(line, mapCompositeRow.getListType(), Apc.create(mapCompositeRow.getCompositeApc()), StatusIndicator.create(dataApcRow.getStatusIndicator()), PaymentIndicator.create(dataApcRow.getPaymentIndicator()));
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapCompositeDao mapCompositeDao = processor.getResourceManager().getDataDaoFactory().getMapCompositeDao();
        DataApcDao dataApcDao = processor.getResourceManager().getDataDaoFactory().getDataApcDao();
        short version = claim.getVersionAsPrimitive();
        for (Day day : navigator.getDayList()) {
            CompositeGroupList compositeGroupList = new CompositeGroupList(2);
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet((LineFlags)new LineFlags[]{LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS, LineFlags.COMPOSITE_LINE}) || line.isRejectedDenied() && !line.getFlags().isSet(LineFlags.INPUT_LINE_EDIT_BYPASS)) continue;
                MapCompositeRowInternal mapCompositeRow = mapCompositeDao.getRow(line.getHcpcs(), (Short)version);
                if (mapCompositeRow == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("No composite row found for CPT/HCPCS {} on {}, line {}", line.getHcpcs(), line.getDay().getIndex(), line.getDay().getLineIndex(line));
                    continue;
                }
                DataApcRowInternal dataApcRow = dataApcDao.getRow(mapCompositeRow.getCompositeApc(), (Short)version);
                if (dataApcRow == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("No APC row found for composite APC {} for CPT/HCPCS {} on {}, line {}", mapCompositeRow.getCompositeApc(), line.getHcpcs(), line.getDay().getIndex(), line.getDay().getLineIndex(line));
                    continue;
                }
                if (0 >= dataApcRow.getComposite1Id()) continue;
                CompositeGroup compositeGroup = compositeGroupList.getCompositeGroup(dataApcRow.getComposite1Id());
                switch (mapCompositeRow.getListType()) {
                    case "A": {
                        CompositeLine compositeLine = this.createCompositeLine(line, mapCompositeRow, dataApcRow);
                        compositeGroup.addCompositeLine(compositeLine);
                        if (compositeGroup.getPrimeCompositeLine() != null && !OceClaimUtility.isLessThan(line, compositeGroup.getPrimeCompositeLine().line)) break;
                        compositeGroup.setPrimeCompositeLine(compositeLine);
                        break;
                    }
                    case "B": {
                        CompositeLine compositeLine = this.createCompositeLine(line, mapCompositeRow, dataApcRow);
                        compositeGroup.addCompositeLine(compositeLine);
                        break;
                    }
                    case "C": {
                        CompositeLine compositeLine = this.createCompositeLine(line, mapCompositeRow, dataApcRow);
                        compositeGroup.addCompositeLine(compositeLine);
                        if (compositeGroup.getPrimeCompositeLine() != null && !"A".equals(compositeGroup.getPrimeCompositeLine().type) && !OceClaimUtility.isLessThan(line, compositeGroup.getPrimeCompositeLine().line)) break;
                        compositeGroup.setPrimeCompositeLine(compositeLine);
                        break;
                    }
                }
            }
            for (int i2 = 1; i2 <= 2; ++i2) {
                CompositeGroup compositeGroup = compositeGroupList.getCompositeGroup(i2);
                if (compositeGroup.getPrimeCompositeLine() != null && ("C".equals(compositeGroup.getPrimeCompositeLine().type) || "A".equals(compositeGroup.getPrimeCompositeLine().type) && compositeGroup.isTypePresent("B") && !compositeGroup.isTerminatedModifierPresent())) {
                    Sequencer<String> c = processor.getResourceManager().getCompositeAdjustmentFlagSequencer();
                    String compositeAdjustmentFlag = c.getNextValue();
                    CompositeLine primeCompositeLine = compositeGroup.getPrimeCompositeLine();
                    OceClaimUtility.assignComposite(primeCompositeLine.line, primeCompositeLine.apc, primeCompositeLine.statusIndicator, primeCompositeLine.paymentIndicator, compositeAdjustmentFlag);
                    for (CompositeLine compositeLine : compositeGroup.compositeLineList) {
                        if (compositeLine.equals(compositeGroup.getPrimeCompositeLine())) continue;
                        OceClaimUtility.packageLine(compositeLine.line);
                        compositeLine.line.setCompositeAdjustmentFlag(compositeAdjustmentFlag);
                        compositeLine.line.getFlags().set(LineFlags.COMPOSITE_LINE);
                    }
                    continue;
                }
                for (CompositeLine compositeLine : compositeGroup.compositeLineList) {
                    if (!compositeLine.line.isNotPackaged() || !compositeLine.line.getFlags().isNotSet(LineFlags.COMPOSITE_LINE)) continue;
                    OceClaimUtility.assignConditionalApc(compositeLine.line);
                }
            }
        }
        return false;
    }

    private final class CompositeGroupList {
        private final List<CompositeGroup> list;
        private final int compositeGroupCount;

        private CompositeGroupList(int compositeGroupCount) {
            this.compositeGroupCount = compositeGroupCount + 1;
            this.list = new ArrayList<CompositeGroup>(this.compositeGroupCount);
            for (int i2 = 0; i2 < this.compositeGroupCount; ++i2) {
                this.list.add(new CompositeGroup());
            }
        }

        public final CompositeGroup getCompositeGroup(int compositeGroupIndex) {
            return this.list.get(compositeGroupIndex);
        }
    }

    private final class CompositeGroup {
        private final List<CompositeLine> compositeLineList = new ArrayList<CompositeLine>();
        private CompositeLine primeCompositeLine;

        private CompositeGroup() {
        }

        private final CompositeLine getPrimeCompositeLine() {
            return this.primeCompositeLine;
        }

        private final void setPrimeCompositeLine(CompositeLine line) {
            this.primeCompositeLine = line;
        }

        private final boolean addCompositeLine(CompositeLine compositeLine) {
            return this.compositeLineList.add(compositeLine);
        }

        private final boolean isTerminatedModifierPresent() {
            for (CompositeLine compositeLine : this.compositeLineList) {
                if (!compositeLine.line.isHcpcsModifierPresent("52", "73")) continue;
                return true;
            }
            return false;
        }

        private final boolean isTypePresent(String type) {
            if (type != null) {
                for (CompositeLine compositeLine : this.compositeLineList) {
                    if (!type.equals(compositeLine.type)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private final class CompositeLine {
        private final LineItemInternal line;
        private final String type;
        private final Apc apc;
        private final StatusIndicator statusIndicator;
        private final PaymentIndicator paymentIndicator;

        private CompositeLine(LineItemInternal line, String type, Apc apc, StatusIndicator statusIndicator, PaymentIndicator paymentIndicator) {
            this.line = line;
            this.type = type;
            this.apc = apc;
            this.statusIndicator = statusIndicator;
            this.paymentIndicator = paymentIndicator;
        }
    }
}

