/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CriticalCareDayLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CriticalCareDayLogic.class);

    CriticalCareDayLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        boolean criticalCarePresent = false;
        boolean criticalCareAncillaryPresent = false;
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            criticalCarePresent = false;
            criticalCareAncillaryPresent = false;
            for (LineItemInternal lineItemInternal : day.getLineItemList()) {
                if (lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_TRAUMA_CRITICAL_CARE)) {
                    criticalCarePresent = true;
                    if (!criticalCareAncillaryPresent) continue;
                    break;
                }
                if (!lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_CRITICAL_CARE_ANCILLARY) || !lineItemInternal.isNotPackaged() || lineItemInternal.isRejectedDeniedAndNotBypassed()) continue;
                criticalCareAncillaryPresent = true;
                if (!criticalCarePresent) continue;
                break;
            }
            if (criticalCarePresent && criticalCareAncillaryPresent) {
                boolean dayHas59OrXMod = day.isHcpcsModifierPresent("59", "XE", "XP", "XS", "XU");
                for (LineItemInternal line2 : day.getLineItemList()) {
                    if (!line2.getFlags().isSet(LineFlags.DATA_HCPCS_CRITICAL_CARE_ANCILLARY) || !line2.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line2.isNotPackaged() || line2.isRejectedDeniedAndNotBypassed()) continue;
                    if (dayHas59OrXMod && line2.getFlags().isNotSet(LineFlags.DATA_HCPCS_STV_PACKAGED)) {
                        OceClaimUtility.setConditionalApc(line2);
                        continue;
                    }
                    OceClaimUtility.packageLine(line2);
                    line2.getFlags().set(LineFlags.COMPOSITE_LINE);
                }
                continue;
            }
            for (LineItemInternal lineItemInternal : day.getLineItemList()) {
                if (!lineItemInternal.getFlags().isSet(LineFlags.DATA_HCPCS_CRITICAL_CARE_ANCILLARY) || !lineItemInternal.getFlags().noneSet(LineFlags.DATA_HCPCS_STV_PACKAGED, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !lineItemInternal.isNotPackaged() || lineItemInternal.isRejectedDeniedAndNotBypassed()) continue;
                OceClaimUtility.setConditionalApc(lineItemInternal);
            }
        }
        return false;
    }
}

