/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FqhcNonCoveredLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(FqhcNonCoveredLogic.class);

    FqhcNonCoveredLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (line.matchesActionFlag(5) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_FQHC_NON_COVERED) && !HardcodedRevenueCodeSet.isFqhcNonCovered(line.getRevenueCode())) continue;
            claim.assignEdit(EditValue.FQHC_NON_COVERED_SERVICE, line);
            line.setStatusIndicator(claim.isClaimVersionAfter(65) ? "E1" : "E");
            line.setPaymentIndicator((byte)3);
            if (line.isPackaged()) {
                line.setPackagingFlag((byte)0);
            }
            if (!claim.matchesBillType("77") || !line.matchesActionFlag(0)) continue;
            line.setActionFlag((byte)5);
        }
        return false;
    }
}

