/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.LineItemInternalTableData;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HcpcsAgeInvalidLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(HcpcsAgeInvalidLogic.class);

    HcpcsAgeInvalidLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        byte age = claim.getAge().getValue();
        for (LineItemInternal line : navigator.getLineItemList()) {
            LineItemInternalTableData tableData;
            if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_LINE_EDIT_BYPASS) || (tableData = line.getTableData()).getLowAge().getValue() == null || tableData.getHighAge().getValue() == null || tableData.getLowAge().getValue() == 0 && tableData.getHighAge().getValue() == 124 || age >= tableData.getLowAge().getValue() && age <= tableData.getHighAge().getValue()) continue;
            claim.assignEdit(EditValue.INVALID_HCPCS_AGE, line);
        }
        return false;
    }
}

