/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InformationalOnlyLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InformationalOnlyLogic.class);

    InformationalOnlyLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        for (LineItemInternal line : processor.getResourceManager().getNavigator().getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_INFORMATION_ONLY)) continue;
            claim.assignEdit(EditValue.INFORMATION_ONLY_CODE_PRESENT, line);
        }
        return false;
    }
}

