/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.DayFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeparateProcedureNotPaidLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(SeparateProcedureNotPaidLogic.class);

    SeparateProcedureNotPaidLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            boolean tProcedureOrComprehensivePresentOnDay = claim.isPrimaryComprehensiveChosen() || day.isStatusIndicatorPresent("T");
            if (!tProcedureOrComprehensivePresentOnDay || !day.getFlags().isNotSet(DayFlags.DAY_DENIED_E1849)) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_SEPARATE_PROCEDURE) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.matchesStatusIndicator("C") || line.equals(claim.getPrimaryComprehensive())) continue;
                claim.assignEdit(EditValue.SEPARATELY_PAYABLE_INPATIENT_PROCEDURE_CONFLICT, line);
            }
        }
        return false;
    }
}

