/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenChargesPackagingLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(TokenChargesPackagingLogic.class);

    TokenChargesPackagingLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        Navigator navigator = processor.getResourceManager().getNavigator();
        ArrayList<LineItemInternal> tokenChargeLineList = new ArrayList<LineItemInternal>();
        boolean validChargeFound = false;
        for (LineItemInternal line : navigator.getLineItemList()) {
            if ((!line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.matchesStatusIndicator("T")) && (!line.matchesStatusIndicator("S") || !HardcodedHcpcsSet.isSurgicalCode(line.getHcpcs()))) continue;
            if (line.isTokenCharge()) {
                tokenChargeLineList.add(line);
                continue;
            }
            if (validChargeFound) continue;
            validChargeFound = true;
        }
        if (validChargeFound && !tokenChargeLineList.isEmpty()) {
            int packagingByte = 3;
            for (LineItemInternal line : tokenChargeLineList) {
                line.setPackagingFlag((byte)3);
            }
        }
        return false;
    }
}

