/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.Charge;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.CompositeAdjustmentFlag;
import gov.cms.oce.model.internal.DiscountFormula;
import gov.cms.oce.model.internal.EditBypass;
import gov.cms.oce.model.internal.Hcpcs;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.HcpcsModifierList;
import gov.cms.oce.model.internal.LineActionFlag;
import gov.cms.oce.model.internal.LineItemInternalTableData;
import gov.cms.oce.model.internal.PackagingFlag;
import gov.cms.oce.model.internal.PaymentAdjustmentFlag;
import gov.cms.oce.model.internal.PaymentIndicator;
import gov.cms.oce.model.internal.PaymentMethodFlag;
import gov.cms.oce.model.internal.RejectionDenialFlag;
import gov.cms.oce.model.internal.RevenueCode;
import gov.cms.oce.model.internal.StatusIndicator;
import gov.cms.oce.model.internal.Unit;
import gov.cms.oce.model.rsc.Edit;
import gov.cms.oce.model.rsc.EditDisposition;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.Editable;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ModifierFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.model.rsc.PaymentAdjustmentFlags;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.FlagSet;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class LineItemInternal
implements Editable {
    private Day day;
    private final FlagSet<LineFlags> flags = new FlagSet<LineFlags>(LineFlags.class);
    private final LineItemInternalTableData tableData = new LineItemInternalTableData();
    private final Set<EditValue> editBypassEditSet = EnumSet.noneOf(EditValue.class);
    private boolean contractorEditBypassed = false;
    private final ClaimDate serviceDate = new ClaimDate();
    private final RevenueCode revenueCode = new RevenueCode();
    private final Hcpcs hcpcs = new Hcpcs();
    private final HcpcsModifierList hcpcsModifierInputList = new HcpcsModifierList();
    private final Unit units = new Unit();
    private final Charge charge = new Charge();
    private final LineActionFlag actionFlag = new LineActionFlag();
    private final EditBypass editBypass = new EditBypass();
    private final Apc hcpcsApc = new Apc();
    private final Apc paymentApc = new Apc();
    private final StatusIndicator statusIndicator = new StatusIndicator();
    private final PaymentIndicator paymentIndicator = new PaymentIndicator();
    private final DiscountFormula discountingFormula = new DiscountFormula();
    private final RejectionDenialFlag rejectionDenialFlag = new RejectionDenialFlag();
    private final PackagingFlag packagingFlag = new PackagingFlag();
    private final PaymentAdjustmentFlag paymentAdjustmentFlag01 = new PaymentAdjustmentFlag();
    private final PaymentMethodFlag paymentMethodFlag = new PaymentMethodFlag();
    private final CompositeAdjustmentFlag compositeAdjustmentFlag = new CompositeAdjustmentFlag();
    private final HcpcsModifierList hcpcsModifierOutputList = new HcpcsModifierList();
    private final PaymentAdjustmentFlag paymentAdjustmentFlag02 = new PaymentAdjustmentFlag();
    private final List<Edit> editList = new ArrayList<Edit>();

    LineItemInternal() {
    }

    public static final LineItemInternal create() {
        return new LineItemInternal();
    }

    public final Day getDay() {
        return this.day;
    }

    public final void setDay(Day day) {
        this.day = day;
    }

    public final FlagSet<LineFlags> getFlags() {
        return this.flags;
    }

    public final LineItemInternalTableData getTableData() {
        return this.tableData;
    }

    public final ClaimDate getServiceDate() {
        return this.serviceDate;
    }

    public final void setServiceDate(String value) {
        this.serviceDate.setValue(value);
    }

    public final RevenueCode getRevenueCode() {
        return this.revenueCode;
    }

    public final void setRevenueCode(Short value) {
        this.revenueCode.setValue(value);
    }

    public final Hcpcs getHcpcs() {
        return this.hcpcs;
    }

    public final void setHcpcs(String value) {
        this.hcpcs.setValue(value);
    }

    public final HcpcsModifierList getHcpcsModifierInputList() {
        return this.hcpcsModifierInputList;
    }

    public final void setHcpcsModifierInputList(int index, String externalValue) {
        HcpcsModifier internalItem = this.hcpcsModifierInputList.getValue().get(index);
        internalItem.setValue(externalValue == null ? null : externalValue.trim());
    }

    public final Unit getUnits() {
        return this.units;
    }

    public final void setUnits(Integer value) {
        this.units.setValue(value);
    }

    public final Charge getCharge() {
        return this.charge;
    }

    public final void setCharge(BigDecimal value) {
        this.charge.setValue(value);
    }

    public final LineActionFlag getActionFlag() {
        return this.actionFlag;
    }

    public final void setActionFlag(Byte value) {
        this.actionFlag.setValue(value);
    }

    public final EditBypass getEditBypass() {
        return this.editBypass;
    }

    public final Apc getHcpcsApc() {
        return this.hcpcsApc;
    }

    public final void setHcpcsApc(String value) {
        this.hcpcsApc.setValue(value);
    }

    public final Apc getPaymentApc() {
        return this.paymentApc;
    }

    public final void setPaymentApc(String value) {
        this.paymentApc.setValue(value);
    }

    public final StatusIndicator getStatusIndicator() {
        return this.statusIndicator;
    }

    public final void setStatusIndicator(String value) {
        this.statusIndicator.setValue(value);
    }

    public final PaymentIndicator getPaymentIndicator() {
        return this.paymentIndicator;
    }

    public final void setPaymentIndicator(Byte value) {
        this.paymentIndicator.setValue(value);
    }

    public final DiscountFormula getDiscountingFormula() {
        return this.discountingFormula;
    }

    public final void setDiscountingFormula(Byte value) {
        this.discountingFormula.setValue(value);
    }

    public final RejectionDenialFlag getRejectionDenialFlag() {
        return this.rejectionDenialFlag;
    }

    public final void setRejectionDenialFlag(Byte value) {
        this.rejectionDenialFlag.setValue(value);
    }

    public final PackagingFlag getPackagingFlag() {
        return this.packagingFlag;
    }

    public final void setPackagingFlag(Byte value) {
        this.packagingFlag.setValue(value);
    }

    public final PaymentAdjustmentFlag getPaymentAdjustmentFlag01() {
        return this.paymentAdjustmentFlag01;
    }

    public final void setPaymentAdjustmentFlag01(Byte value) {
        this.paymentAdjustmentFlag01.setValue(value);
    }

    public final PaymentAdjustmentFlag getPaymentAdjustmentFlag02() {
        return this.paymentAdjustmentFlag02;
    }

    public final void setPaymentAdjustmentFlag02(Byte value) {
        this.paymentAdjustmentFlag02.setValue(value);
    }

    public final PaymentMethodFlag getPaymentMethodFlag() {
        return this.paymentMethodFlag;
    }

    public final void setPaymentMethodFlag(String value) {
        this.paymentMethodFlag.setValue(value);
    }

    public final CompositeAdjustmentFlag getCompositeAdjustmentFlag() {
        return this.compositeAdjustmentFlag;
    }

    public final void setCompositeAdjustmentFlag(String value) {
        this.compositeAdjustmentFlag.setValue(value);
    }

    public final HcpcsModifierList getHcpcsModifierOutputList() {
        return this.hcpcsModifierOutputList;
    }

    public final Set<EditValue> getEditBypassEditSet() {
        return this.editBypassEditSet;
    }

    @Override
    public final List<Edit> getEditList() {
        return this.editList;
    }

    @Override
    public final boolean isContractorEditBypassed() {
        return this.contractorEditBypassed;
    }

    @Override
    public final void setContractorEditBypassed(boolean contractorEditBypassed) {
        this.contractorEditBypassed = contractorEditBypassed;
    }

    @Override
    public final boolean isEditBypassedByContractor(EditValue editValue) {
        if (this.matchesActionFlag(0)) {
            for (EditValue bypassEditValue : this.editBypassEditSet) {
                if (bypassEditValue != editValue) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isEditBypassedByContractorPresent() {
        if (this.matchesActionFlag(0)) {
            for (Edit edit : this.editList) {
                if (!this.isEditBypassedByContractor(edit.getEditValue())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isServiceDateBefore(LocalDate effectiveDate) {
        if (this.flags.isSet(LineFlags.INPUT_INVALID_SERVICE_DATE)) {
            return false;
        }
        return this.serviceDate.getValueAsDate().isBefore(effectiveDate);
    }

    public final boolean isServiceDateBefore(int date) {
        if (date == 0) {
            return false;
        }
        return this.isServiceDateBefore(ClaimDate.getDateForInteger(date));
    }

    public final boolean isServiceDateBeforeApprovalDate() {
        if (this.tableData.getDateApproved().getValueAsDate() == null) {
            return false;
        }
        return this.isServiceDateBefore(this.tableData.getDateApproved().getValueAsDate());
    }

    public final boolean isServiceDateAfter(LocalDate effectiveDate) {
        if (this.flags.isSet(LineFlags.INPUT_INVALID_SERVICE_DATE)) {
            return false;
        }
        return this.serviceDate.getValueAsDate().isAfter(effectiveDate);
    }

    public final boolean isServiceDateAfterTerminationDate() {
        if (this.tableData.getDateTerminated().getValueAsDate() == null) {
            return false;
        }
        return this.isServiceDateAfter(this.tableData.getDateTerminated().getValueAsDate());
    }

    public final boolean isApcPaymentGreaterThan(LineItemInternal line) {
        if (this.flags.isSet(LineFlags.INPUT_INVALID_HCPCS)) {
            return false;
        }
        if (line.flags.isSet(LineFlags.INPUT_INVALID_HCPCS)) {
            return true;
        }
        if (this.matchesApc(line.getPaymentApc()) || this.matchesApc(HardcodedApcSet.APC_ZERO)) {
            return false;
        }
        return line.getTableData().getApcPayment() < this.getTableData().getApcPayment();
    }

    public final int getUnitsAsPrimitive() {
        return this.units.getValue() == null || this.units.getValue() < 1 ? 1 : this.units.getValue();
    }

    public final boolean isUnitsGreaterThanOne() {
        return this.isUnitsGreaterThan(1);
    }

    public final boolean isUnitsGreaterThan(int amount) {
        if (this.units.getValue() == null) {
            return false;
        }
        return amount < this.units.getValue();
    }

    public final boolean isZeroCharge() {
        if (this.charge.getValue() == null) {
            return false;
        }
        return this.charge.getValue().compareTo(BigDecimal.ZERO) == 0;
    }

    public final boolean isTokenCharge() {
        if (this.charge.getValue() == null || this.charge.getValue().compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        return this.charge.getValue().compareTo(OceClaimUtility.getTokenChargeAmount()) < 0;
    }

    public final boolean isEditPresent(EditValue editValue) {
        if (editValue != null) {
            for (Edit e : this.editList) {
                if (editValue != e.getEditValue()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isEditPresent(EditValue ... editValueList) {
        if (editValueList != null) {
            for (Edit e : this.editList) {
                for (EditValue editValue : editValueList) {
                    if (editValue != e.getEditValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean isRejectionDenialEditPresent() {
        for (Edit edit : this.editList) {
            if (edit.getEditValue().isSoftEdit() || edit.getEditValue().getEditDisposition() != EditDisposition.LINE_REJECTION && edit.getEditValue().getEditDisposition() != EditDisposition.LINE_DENIAL) continue;
            return true;
        }
        for (HcpcsModifier hcpcsModifier : this.getHcpcsModifierInputList().getValue()) {
            for (Edit edit : hcpcsModifier.getEditList()) {
                if (edit.getEditValue().isSoftEdit() || edit.getEditValue().getEditDisposition() != EditDisposition.LINE_REJECTION && edit.getEditValue().getEditDisposition() != EditDisposition.LINE_DENIAL) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isRejectedDenied() {
        return this.isRejectionDenialEditPresent();
    }

    public final boolean isRejectedDeniedAndNotBypassed() {
        return this.isRejectionDenialEditPresent() && this.flags.isNotSet(LineFlags.INPUT_LINE_EDIT_BYPASS);
    }

    public final void setPaymentAdjustmentFlag01(PaymentAdjustmentFlags paymentAdjustmentFlag) {
        this.paymentAdjustmentFlag01.setValue(paymentAdjustmentFlag.getValue());
    }

    public final boolean isLineExcluded() {
        return this.isRejectedDeniedAndNotBypassed() || this.getFlags().anySet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE);
    }

    public final boolean isCompositeAdjustmentFlagSet() {
        return this.compositeAdjustmentFlag.getValue() != null && !"00".equals(this.compositeAdjustmentFlag.getValue());
    }

    public final boolean matchesRevenueCode(HardcodedRevenueCodeSet targetValue) {
        if (this.revenueCode.getValue() == null) {
            return targetValue.getRevenueCode() == 0;
        }
        return this.revenueCode.getValue().shortValue() == targetValue.getRevenueCode();
    }

    public final boolean matchesRevenueCode(RevenueCode targetValue) {
        if (this.revenueCode.getValue() == null) {
            return targetValue.getValue() == null;
        }
        return this.revenueCode.getValue().equals(targetValue.getValue());
    }

    public final boolean matchesRevenueCode(Short targetValue) {
        if (this.revenueCode.getValue() == null) {
            return targetValue == null;
        }
        return this.revenueCode.getValue().equals(targetValue);
    }

    public final boolean matchesRevenueCode(Short ... targetValueList) {
        for (Short targetRevenueCode : targetValueList) {
            if (!this.matchesRevenueCode(targetRevenueCode)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesApc(HardcodedApcSet targetValue) {
        if (this.paymentApc.getValue() == null) {
            return targetValue.getApc() == null;
        }
        return this.paymentApc.getValue().equals(targetValue.getApc());
    }

    public final boolean matchesApc(Apc targetValue) {
        if (this.paymentApc.getValue() == null) {
            return targetValue.getValue() == null;
        }
        return this.paymentApc.getValue().equals(targetValue.getValue());
    }

    public final boolean matchesApc(HardcodedApcSet ... targetValueList) {
        for (HardcodedApcSet targetHcpcs : targetValueList) {
            if (!this.matchesApc(targetHcpcs)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesHcpcs(HardcodedHcpcsSet targetValue) {
        if (this.hcpcs.getValue() == null) {
            return targetValue.getHcpcs() == null;
        }
        return this.hcpcs.getValue().equals(targetValue.getHcpcs());
    }

    public final boolean matchesHcpcs(Hcpcs targetValue) {
        if (this.hcpcs.getValue() == null) {
            return targetValue.getValue() == null;
        }
        return this.hcpcs.getValue().equals(targetValue.getValue());
    }

    public final boolean matchesHcpcs(HardcodedHcpcsSet ... targetValueList) {
        for (HardcodedHcpcsSet targetHcpcs : targetValueList) {
            if (!this.matchesHcpcs(targetHcpcs)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesActionFlag(int targetValue) {
        if (this.getActionFlag().getValue() == null) {
            return targetValue == 0;
        }
        return targetValue == this.getActionFlag().getValue().intValue();
    }

    public final boolean matchesActionFlag(int ... targetValueList) {
        for (int targetActionFlag : targetValueList) {
            if (!this.matchesActionFlag(targetActionFlag)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesStatusIndicatorQ() {
        return this.matchesStatusIndicator("Q1", "Q2", "Q3", "Q4");
    }

    public final boolean matchesInitialStatusIndicatorQ() {
        String initialStatusIndicator = this.getTableData().getDefaultStatusIndicator().getValue();
        return "Q1".equals(initialStatusIndicator) || "Q2".equals(initialStatusIndicator) || "Q3".equals(initialStatusIndicator) || "Q4".equals(initialStatusIndicator);
    }

    public final boolean matchesInitialStatusIndicator(String targetValue) {
        return targetValue.equals(this.getTableData().getDefaultStatusIndicator().getValue());
    }

    public final boolean matchesApcStatusIndicator(String targetValue) {
        return targetValue.equals(this.getTableData().getApcStatusIndicator().getValue());
    }

    public final boolean matchesApcStatusIndicator(String ... targetValueList) {
        for (String targetStatusIndicator : targetValueList) {
            if (!this.matchesApcStatusIndicator(targetStatusIndicator)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesStatusIndicator(String targetValue) {
        return targetValue.equals(this.getStatusIndicator().getValue());
    }

    public final boolean matchesStatusIndicator(String ... targetValueList) {
        for (String targetStatusIndicator : targetValueList) {
            if (!this.matchesStatusIndicator(targetStatusIndicator)) continue;
            return true;
        }
        return false;
    }

    public final boolean isSeparatelyPayable() {
        return "A".equals(this.getStatusIndicator().getValue()) && 2 == this.getPaymentIndicator().getValue().intValue() && this.matchesApc(HardcodedApcSet.APC_ZERO);
    }

    public final boolean isNotSeparatelyPayable() {
        return !this.isSeparatelyPayable();
    }

    public final boolean isHcpcsModifierFlagSet(ModifierFlags flag) {
        if (0 < this.hcpcsModifierInputList.getCount()) {
            for (HcpcsModifier hcpcsModifier : this.hcpcsModifierInputList.getValue()) {
                if (!hcpcsModifier.getFlags().isSet(flag)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isHcpcsModifierPresent(String ... targetValueList) {
        if (targetValueList != null && 0 < this.hcpcsModifierInputList.getCount()) {
            for (HcpcsModifier hcpcsModifier : this.hcpcsModifierInputList.getValue()) {
                if (hcpcsModifier.getValue() == null) break;
                for (String targetValue : targetValueList) {
                    if (!hcpcsModifier.getValue().equals(targetValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean isHcpcsModifierPresent(String targetValue) {
        if (targetValue != null && 0 < this.hcpcsModifierInputList.getCount()) {
            for (HcpcsModifier hcpcsModifier : this.hcpcsModifierInputList.getValue()) {
                if (hcpcsModifier.getValue() == null) break;
                if (!hcpcsModifier.getValue().equals(targetValue)) continue;
                return true;
            }
        }
        return false;
    }

    public final HcpcsModifier getHcpcsModifier(String targetValue) {
        if (targetValue != null && 0 < this.hcpcsModifierInputList.getCount()) {
            for (HcpcsModifier hcpcsModifier : this.hcpcsModifierInputList.getValue()) {
                if (hcpcsModifier.getValue() == null) break;
                if (!hcpcsModifier.getValue().equals(targetValue)) continue;
                return hcpcsModifier;
            }
        }
        return null;
    }

    public final boolean matchesPaymentAdjustmentFlag(PaymentAdjustmentFlags targetValue) {
        if (this.paymentAdjustmentFlag01.getValue() == null) {
            return targetValue.getValue() == PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_NONE.getValue();
        }
        return targetValue.getValue() == this.paymentAdjustmentFlag01.getValue().byteValue();
    }

    public final boolean matchesPaymentAdjustmentFlag(PaymentAdjustmentFlags ... targetValueList) {
        for (PaymentAdjustmentFlags targetPaymentAdjustmentFlag : targetValueList) {
            if (!this.matchesPaymentAdjustmentFlag(targetPaymentAdjustmentFlag)) continue;
            return true;
        }
        return false;
    }

    public final boolean isNotPackaged() {
        return this.getPackagingFlag().getValue() == null || this.getPackagingFlag().getValue() != 1;
    }

    public final boolean isPackaged() {
        return !this.isNotPackaged();
    }

    public final String toString() {
        return String.format("HCPCS:%s", this.hcpcs.getValue());
    }

    public final int hashCode() {
        return Objects.hash(this.day, this.flags, this.tableData, this.serviceDate, this.revenueCode, this.hcpcs, this.hcpcsModifierInputList, this.units, this.charge, this.actionFlag, this.editBypass, this.hcpcsApc, this.paymentApc, this.statusIndicator, this.paymentIndicator, this.discountingFormula, this.rejectionDenialFlag, this.packagingFlag, this.paymentAdjustmentFlag01, this.paymentMethodFlag, this.compositeAdjustmentFlag, this.hcpcsModifierOutputList, this.paymentAdjustmentFlag02, this.editList);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LineItemInternal o = (LineItemInternal)object;
        return Objects.equals(this.day, o.day) && Objects.equals(this.flags, o.flags) && Objects.equals(this.tableData, o.tableData) && Objects.equals(this.serviceDate, o.serviceDate) && Objects.equals(this.revenueCode, o.revenueCode) && Objects.equals(this.hcpcs, o.hcpcs) && Objects.equals(this.hcpcsModifierInputList, o.hcpcsModifierInputList) && Objects.equals(this.units, o.units) && Objects.equals(this.charge, o.charge) && Objects.equals(this.actionFlag, o.actionFlag) && Objects.equals(this.editBypass, o.editBypass) && Objects.equals(this.hcpcsApc, o.hcpcsApc) && Objects.equals(this.paymentApc, o.paymentApc) && Objects.equals(this.statusIndicator, o.statusIndicator) && Objects.equals(this.paymentIndicator, o.paymentIndicator) && Objects.equals(this.discountingFormula, o.discountingFormula) && Objects.equals(this.rejectionDenialFlag, o.rejectionDenialFlag) && Objects.equals(this.packagingFlag, o.packagingFlag) && Objects.equals(this.paymentAdjustmentFlag01, o.paymentAdjustmentFlag01) && Objects.equals(this.paymentMethodFlag, o.paymentMethodFlag) && Objects.equals(this.compositeAdjustmentFlag, o.compositeAdjustmentFlag) && Objects.equals(this.hcpcsModifierOutputList, o.hcpcsModifierOutputList) && Objects.equals(this.paymentAdjustmentFlag02, o.paymentAdjustmentFlag02) && Objects.equals(this.editList, o.editList);
    }
}

