/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.dao.data.AbstractDaoFactoryType;
import gov.cms.oce.dao.data.AbstractDataDaoFactory;
import gov.cms.oce.dao.data.DataDaoFactory;
import gov.cms.oce.dao.dsc.AbstractDescriptionDaoFactory;
import gov.cms.oce.dao.dsc.DescriptionDaoFactory;
import gov.cms.oce.logic.BasicLogicProcessor;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.model.external.OceClaimConverter;
import gov.cms.oce.model.rsc.CompositeAdjustmentFlagSequencer;
import gov.cms.oce.model.rsc.Sequencer;
import gov.cms.oce.processor.ResourceManager;
import gov.cms.oce.util.Navigator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceResourceManager
implements ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(OceResourceManager.class);
    private DataDaoFactory daoFactory;
    private DescriptionDaoFactory descriptionDaoFactory;
    private final LogicProcessor logicProcessor = new BasicLogicProcessor();
    private final OceClaimConverter claimConverter = new OceClaimConverter();
    private final Navigator navigator = new Navigator();
    private Sequencer<String> compositeAdjustmentFlagSequencer;

    @Override
    public final DataDaoFactory getDataDaoFactory() {
        if (this.daoFactory == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating DataDaoFactory");
            }
            this.daoFactory = AbstractDataDaoFactory.getFactory(AbstractDaoFactoryType.BINARY);
        }
        return this.daoFactory;
    }

    @Override
    public final DescriptionDaoFactory getDescriptionDaoFactory() {
        if (this.descriptionDaoFactory == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating DescriptionDaoFactory");
            }
            this.descriptionDaoFactory = AbstractDescriptionDaoFactory.getFactory(AbstractDaoFactoryType.BINARY);
        }
        return this.descriptionDaoFactory;
    }

    @Override
    public final LogicProcessor getLogicProcessor() {
        return this.logicProcessor;
    }

    @Override
    public final OceClaimConverter getConverter() {
        return this.claimConverter;
    }

    @Override
    public final Sequencer<String> getCompositeAdjustmentFlagSequencer() {
        if (this.compositeAdjustmentFlagSequencer == null) {
            this.compositeAdjustmentFlagSequencer = new CompositeAdjustmentFlagSequencer();
        }
        return this.compositeAdjustmentFlagSequencer;
    }

    @Override
    public final Navigator getNavigator() {
        return this.navigator;
    }

    public final int hashCode() {
        return Objects.hash(this.daoFactory, this.descriptionDaoFactory, this.logicProcessor, this.claimConverter, this.navigator);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OceResourceManager o = (OceResourceManager)object;
        return Objects.equals(this.daoFactory, o.daoFactory) && Objects.equals(this.descriptionDaoFactory, o.descriptionDaoFactory) && Objects.equals(this.logicProcessor, o.logicProcessor) && Objects.equals(this.claimConverter, o.claimConverter) && Objects.equals(this.navigator, o.navigator) && Objects.equals(this.compositeAdjustmentFlagSequencer, o.compositeAdjustmentFlagSequencer);
    }
}

