/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.model.internal.ValueCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class ValueCodeList {
    private final List<ValueCode> list;
    private final boolean fixed;

    ValueCodeList() {
        this(false, 0);
    }

    ValueCodeList(boolean fixed, int size) {
        this.fixed = fixed;
        if (0 < size) {
            this.list = new ArrayList<ValueCode>(size + 1);
            for (int i2 = 0; i2 < size; ++i2) {
                this.list.add(new ValueCode("", ""));
            }
        } else {
            this.list = new ArrayList<ValueCode>(36);
        }
    }

    public final List<ValueCode> getValue() {
        return this.list;
    }

    public final int getCount() {
        return this.list.size();
    }

    public final int getIndex(ValueCode valueCode) {
        return this.list.indexOf(valueCode);
    }

    public final void addValue(String code, String value) {
        if (this.fixed) {
            throw new UnsupportedOperationException("This instance of ValueCodeList is fixed and shouldn't be extended.");
        }
        this.list.add(new ValueCode(code, value));
    }

    public final boolean isValueCodeSet(int index) {
        ValueCode valueCode = this.list.get(index);
        if (valueCode == null) {
            return false;
        }
        return valueCode.getCode() != null && !"".equals(valueCode.getCode().trim());
    }

    public final void setValue(int index, String code, String value) {
        this.list.set(index, new ValueCode(code, value));
    }

    public final int hashCode() {
        return Objects.hash(this.list);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ValueCodeList o = (ValueCodeList)object;
        return Objects.equals(this.list, o.list) && Objects.equals(this.fixed, this.fixed);
    }
}

