/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.model.rsc.FlagType;
import gov.cms.oce.util.FlagSetIdentifiable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum DiagnosisFlags implements FlagSetIdentifiable<DiagnosisFlags>
{
    TEST("test", FlagType.PROGRAM),
    INPUT_EMPTY_DIAGNOSIS("input-empty-diagnosis"),
    INPUT_INVALID_DIAGNOSIS("input-invalid-diagnosis"),
    DIAGNOSIS_VALID_IN_FUTURE_VERSION("diagnosis-valid-in-future-version"),
    EXTERNAL_CAUSE("EXTERNAL_CAUSE", FlagType.TABLE_DATA_DX10),
    MENTAL_HEALTH("MENTAL_HEALTH", FlagType.TABLE_DATA_DX10),
    MANIFESTATION("MANIFESTATION", FlagType.TABLE_DATA_DX10),
    CODE_FIRST("CODE_FIRST", FlagType.TABLE_DATA_DX10),
    UNACCEPTABLE_PDX("UNACCEPTABLE_PDX", FlagType.TABLE_DATA_DX10),
    UNACCEPTABLE_PDX_EXCLUSION("UNACCEPTABLE_PDX_EXCLUSION", FlagType.TABLE_DATA_DX10);

    private static Map<String, DiagnosisFlags> internalMap;
    private final String name;
    private final FlagType flagType;

    private DiagnosisFlags(String name) {
        this.name = name;
        this.flagType = FlagType.PROGRAM;
    }

    private DiagnosisFlags(String name, FlagType flagType) {
        this.name = name;
        this.flagType = flagType;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final DiagnosisFlags[] getEnumeration() {
        return DiagnosisFlags.values();
    }

    @Override
    public final FlagType getFlagType() {
        return this.flagType;
    }

    public static final DiagnosisFlags getFlag(String name) {
        return internalMap.get(name);
    }

    static {
        HashMap<String, DiagnosisFlags> tmp = new HashMap<String, DiagnosisFlags>();
        for (DiagnosisFlags flag : DiagnosisFlags.values()) {
            tmp.put(flag.name, flag);
        }
        internalMap = Collections.unmodifiableMap(tmp);
    }
}

