/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.EditableType;

public final class Edit {
    private final EditValue editValue;
    private final EditableType editableType;
    private final OceClaimInternal claimInternal;
    private final LineItemInternal lineItemInternal;
    private final DiagnosisCode diagnosisCode;
    private final HcpcsModifier hcpcsModifier;
    private String description;

    private Edit() {
        this.editValue = EditValue.NO_EDIT;
        this.claimInternal = null;
        this.lineItemInternal = null;
        this.diagnosisCode = null;
        this.hcpcsModifier = null;
        this.editableType = EditableType.CLAIM;
    }

    public Edit(EditValue editValue, OceClaimInternal editable) {
        this.editValue = editValue;
        this.claimInternal = editable;
        this.lineItemInternal = null;
        this.diagnosisCode = null;
        this.hcpcsModifier = null;
        this.editableType = EditableType.CLAIM;
    }

    public Edit(EditValue editValue, LineItemInternal editable) {
        this.editValue = editValue;
        this.claimInternal = null;
        this.lineItemInternal = editable;
        this.diagnosisCode = null;
        this.hcpcsModifier = null;
        this.editableType = EditableType.LINE;
    }

    public Edit(EditValue editValue, DiagnosisCode editable) {
        this.editValue = editValue;
        this.claimInternal = null;
        this.lineItemInternal = null;
        this.diagnosisCode = editable;
        this.hcpcsModifier = null;
        this.editableType = EditableType.DIAGNOSIS;
    }

    public Edit(EditValue editValue, HcpcsModifier editable) {
        this.editValue = editValue;
        this.claimInternal = null;
        this.lineItemInternal = null;
        this.diagnosisCode = null;
        this.hcpcsModifier = editable;
        this.editableType = EditableType.HCPCS_MODIFIER;
    }

    public final EditValue getEditValue() {
        return this.editValue;
    }

    public final EditableType getEditableType() {
        return this.editableType;
    }

    public OceClaimInternal getEditableAsOceClaimInternal() {
        if (this.editableType == EditableType.CLAIM) {
            return this.claimInternal;
        }
        throw new ClassCastException();
    }

    public LineItemInternal getEditableAsOceLineInternal() {
        if (this.editableType == EditableType.LINE) {
            return this.lineItemInternal;
        }
        throw new ClassCastException();
    }

    public DiagnosisCode getEditableAsDiagnosis() {
        if (this.editableType == EditableType.DIAGNOSIS) {
            return this.diagnosisCode;
        }
        throw new ClassCastException();
    }

    public HcpcsModifier getEditableAsHcpcsModifier() {
        if (this.editableType == EditableType.HCPCS_MODIFIER) {
            return this.hcpcsModifier;
        }
        throw new ClassCastException();
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }
}

