/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.model.internal.BillType;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HardcodedBillTypeSet {
    PLACEHOLDER;

    private static final Logger logger;
    private static final List<String> OPPS_BILLTYPE_LIST;
    private static final List<String> NONOPPS_BILLTYPE_LIST;

    public static final boolean isOpps(BillType billtype) {
        return HardcodedBillTypeSet.isOpps(billtype.getValue());
    }

    public static final boolean isOpps(String billtype) {
        if (billtype == null || billtype.length() < 2) {
            return false;
        }
        if (2 < billtype.length()) {
            return OPPS_BILLTYPE_LIST.contains(billtype.substring(0, 2));
        }
        return OPPS_BILLTYPE_LIST.contains(billtype);
    }

    public static final boolean isNonOpps(BillType billtype) {
        return HardcodedBillTypeSet.isNonOpps(billtype.getValue());
    }

    public static final boolean isNonOpps(String billtype) {
        if (billtype == null || billtype.length() < 2) {
            return false;
        }
        if (2 < billtype.length()) {
            return NONOPPS_BILLTYPE_LIST.contains(billtype.substring(0, 2));
        }
        return NONOPPS_BILLTYPE_LIST.contains(billtype);
    }

    public static final boolean isLineBufferComplete(OceClaimInternal claim) {
        return claim.isOpps() && (claim.matchesBillType("13", "76") || claim.matchesBillType("12", "14") && !claim.isConditionCodePresent("41") || claim.matchesBillType("34") && claim.getFlags().anySet((ClaimFlags)new ClaimFlags[]{ClaimFlags.VACCINE_ADMINISTRATION, ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT, ClaimFlags.NEGATIVE_PRESSURE_WOUND_THERAPY}) || claim.matchesBillType("22", "23", "32", "72", "74", "75", "81", "82") && claim.getFlags().anySet(ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT) && claim.isConditionCodePresent("07"));
    }

    static {
        logger = LoggerFactory.getLogger(HardcodedBillTypeSet.class);
        OPPS_BILLTYPE_LIST = Arrays.asList("12", "13", "14", "22", "23", "32", "34", "43", "71", "72", "74", "75", "76", "77", "81", "82", "87");
        NONOPPS_BILLTYPE_LIST = Arrays.asList("12", "13", "14", "22", "23", "32", "34", "43", "71", "72", "73", "74", "75", "77", "78", "81", "82", "83", "84", "85", "87", "89");
    }
}

