/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public final class DateRange {
    private LocalDate dateStarted;
    private LocalDate dateEnded;

    private DateRange() {
    }

    public DateRange(LocalDate dateStarted, LocalDate dateEnded) {
        this.dateStarted = dateStarted;
        this.dateEnded = dateEnded;
    }

    public DateRange(Date dateStarted, Date dateEnded) {
        ZoneId zoneId = ZoneId.systemDefault();
        this.dateStarted = dateStarted.toInstant().atZone(zoneId).toLocalDate();
        this.dateEnded = dateEnded.toInstant().atZone(zoneId).toLocalDate();
    }

    public DateRange(Integer dateStarted, Integer dateEnded) {
        this.dateStarted = this.getDateforInteger(dateStarted);
        this.dateEnded = this.getDateforInteger(dateEnded);
    }

    public final LocalDate getDateforInteger(Integer date) {
        String dateString = String.valueOf(date);
        String year = dateString.substring(0, 4);
        String month = dateString.substring(4, 6);
        String dayOfMonth = dateString.substring(6);
        return LocalDate.of(Integer.parseInt(year, 10), Integer.parseInt(month, 10), Integer.parseInt(dayOfMonth, 10));
    }

    public final LocalDate getDateStarted() {
        return this.dateStarted;
    }

    public final LocalDate getDateEnded() {
        return this.dateEnded;
    }

    public final boolean isInvalid() {
        return this.dateEnded.isBefore(this.dateStarted);
    }

    public final long getDaySpan() {
        return ChronoUnit.DAYS.between(this.dateStarted, this.dateEnded) + 1L;
    }

    public final boolean isOutsideOfRange(LocalDate date) {
        return date.isBefore(this.dateStarted) || date.isAfter(this.dateEnded);
    }

    public final boolean isInsideOfRange(LocalDate date) {
        return !this.isOutsideOfRange(date);
    }

    public final boolean isBeforeDateStarted(LocalDate date) {
        return date.isBefore(this.dateStarted);
    }

    public final boolean isAfterDateEnded(LocalDate date) {
        return date.isAfter(this.dateEnded);
    }
}

