/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.DayFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.FlagSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class Day {
    private final FlagSet<DayFlags> flags = new FlagSet<DayFlags>(DayFlags.class);
    private final List<LineItemInternal> lineItemList;
    private final int index;
    private final LocalDate date;
    private int offsetAmount;

    private Day() {
        this(-1);
    }

    public Day(int index) {
        this(index, null);
    }

    public Day(int index, LocalDate date) {
        this.index = index;
        this.date = date;
        this.lineItemList = new ArrayList<LineItemInternal>();
    }

    public final FlagSet<DayFlags> getFlags() {
        return this.flags;
    }

    public final int getIndex() {
        return this.index;
    }

    public final LocalDate getDate() {
        return this.date;
    }

    public final boolean isEmpty() {
        return this.lineItemList.isEmpty();
    }

    public final int getCount() {
        return this.lineItemList.size();
    }

    public final List<LineItemInternal> getLineItemList() {
        return this.lineItemList;
    }

    public final int getLineIndex(LineItemInternal line) {
        return this.lineItemList.indexOf(line);
    }

    public final int getOffsetAmount() {
        return this.offsetAmount;
    }

    public final void setOffsetAmount(int offsetAmount) {
        this.offsetAmount = offsetAmount;
    }

    public final boolean isEditPresent(EditValue editValue) {
        if (editValue != null) {
            for (LineItemInternal line : this.lineItemList) {
                if (!line.isEditPresent(editValue)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isEditPresent(EditValue ... editValueList) {
        if (editValueList != null) {
            for (EditValue editValue : editValueList) {
                if (!this.isEditPresent(editValue)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isHcpcsModifierPresent(String hcpcsModifer) {
        if (hcpcsModifer != null) {
            for (LineItemInternal line : this.lineItemList) {
                if (!line.isHcpcsModifierPresent(hcpcsModifer)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isHcpcsModifierPresent(String ... hcpcsModiferList) {
        if (hcpcsModiferList != null) {
            for (String hcpcsModifer : hcpcsModiferList) {
                if (!this.isHcpcsModifierPresent(hcpcsModifer)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isStatusIndicatorPresent(String statusIndicator) {
        if (statusIndicator != null) {
            for (LineItemInternal line : this.lineItemList) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !statusIndicator.equals(line.getStatusIndicator().getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isStatusIndicatorPresent(String ... statusIndicatorList) {
        if (statusIndicatorList != null) {
            for (String statusIndicator : statusIndicatorList) {
                if (!this.isStatusIndicatorPresent(statusIndicator)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isLineFlagPresent(LineFlags flag) {
        if (flag != null) {
            for (LineItemInternal line : this.lineItemList) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.getFlags().isSet(flag)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isLineFlagPresent(LineFlags ... flagList) {
        if (flagList != null) {
            for (LineFlags flag : flagList) {
                if (!this.isLineFlagPresent(flag)) continue;
                return true;
            }
        }
        return false;
    }
}

