/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import gov.cms.oce.util.FileProcessor;
import gov.cms.oce.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileProcessExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FileProcessExecutor.class);

    /*
     * Enabled aggressive block sorting
     */
    public final void processFile(FileProcessor fileProcessor, String inputFilePath, String outputFilePath) throws IOException {
        String outputPath;
        File inputFile = new File(inputFilePath);
        if (!inputFile.exists()) {
            logger.error("Input file/directory does not exist \"{}\".", (Object)inputFile.getAbsolutePath());
            return;
        }
        File outputFile = new File(outputFilePath);
        String inputPath = inputFile.getAbsolutePath().toLowerCase(Locale.US);
        if (inputPath.contains(outputPath = outputFile.getAbsolutePath().toLowerCase(Locale.US))) {
            logger.error("Output file parameter matches or is a parent path of the input file parameter. This would result in the deletion of the input data.");
            logger.error("Input file parameter \"{}\".", (Object)inputFile.getAbsolutePath());
            logger.error("Output file parameter \"{}\".", (Object)outputFile.getAbsolutePath());
            throw new IOException("Output file parameter matches or is a parent path of the input file parameter. This would result in the deletion of the input data.");
        }
        if (inputFile.isDirectory()) {
            if (outputFile.exists()) {
                if (!outputFile.isDirectory()) {
                    logger.error("Output file parameter must be a directory if the input file parameter is a directory. Parameter \"{}\".", (Object)outputFile);
                    throw new IOException("Output file parameter must be a directory if the input file parameter is a directory.");
                }
                logger.info("Deleting files from output directory \"{}\".", (Object)outputFile);
                for (File file : outputFile.listFiles()) {
                    FileUtility fileUtility = new FileUtility();
                    fileUtility.rm(file);
                }
            } else {
                if (!outputFile.mkdirs()) {
                    logger.error("Could not create output directory \"{}\".", (Object)outputFile);
                    throw new IOException("Could not create output directory.");
                }
                logger.info("Created output directory \"{}\".", (Object)outputFile);
            }
            File[] fileArray = inputFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File input = fileArray[n2];
                File output = new File(outputFile, input.getName());
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing input file:  \"{}\"", (Object)input.getAbsolutePath());
                    logger.debug("Generating output file: \"{}\"", (Object)output.getAbsolutePath());
                }
                fileProcessor.process(input, output);
                ++n2;
            }
            return;
        }
        if (outputFile.exists()) {
            if (outputFile.isDirectory()) {
                File newOutputFile = new File(outputFile, inputFile.getName());
                if (newOutputFile.exists()) {
                    if (!newOutputFile.delete()) {
                        logger.error("Could not delete existing output file \"{}\".", (Object)newOutputFile.getAbsolutePath());
                        throw new IOException("Could not delete existing output file.");
                    }
                    logger.info("Deleted existing output file \"{}\".", (Object)newOutputFile.getAbsolutePath());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing input file:  \"{}\"", (Object)inputFile.getAbsolutePath());
                    logger.debug("Generating output file: \"{}\"", (Object)newOutputFile.getAbsolutePath());
                }
                fileProcessor.process(inputFile, newOutputFile);
                return;
            }
            if (!outputFile.delete()) {
                logger.error("Could not delete existing output file \"{}\".", (Object)outputFile.getAbsolutePath());
                throw new IOException("Could not delete existing output file.");
            }
            logger.info("Deleted existing output file \"{}\".", (Object)outputFile);
            if (logger.isDebugEnabled()) {
                logger.debug("Processing input file:  \"{}\"", (Object)inputFile.getAbsolutePath());
                logger.debug("Generating output file: \"{}\"", (Object)outputFile.getAbsolutePath());
            }
            fileProcessor.process(inputFile, outputFile);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Processing input file:  \"{}\"", (Object)inputFile.getAbsolutePath());
            logger.debug("Generating output file: \"{}\"", (Object)outputFile.getAbsolutePath());
        }
        fileProcessor.process(inputFile, outputFile);
    }
}

