/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import gov.cms.oce.util.converter.rsc.DataTruncationException;
import gov.cms.oce.util.converter.rsc.FieldBoundaryException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtilities {
    private static final Logger logger = LoggerFactory.getLogger(StringUtilities.class);
    public static final String EMPTY_STRING = "";
    public static final String COMMA_SEPARATOR = ", ";
    public static final String EQUAL_SEPARATOR = "=";

    private StringUtilities() {
        throw new AssertionError();
    }

    public static final Set<String> parseArray(String value) {
        return StringUtilities.parseArray(value, ",");
    }

    public static final Set<String> parseArray(String value, String parseToken) {
        if (value == null || EMPTY_STRING.equals(value.trim())) {
            return Collections.emptySet();
        }
        String[] tmp = value.split(parseToken, 0);
        int i2 = tmp.length;
        HashSet<String> set = new HashSet<String>(i2);
        while (-1 < --i2) {
            if (EMPTY_STRING.equals(tmp[i2].trim())) continue;
            set.add(tmp[i2].trim());
        }
        return Collections.unmodifiableSet(set);
    }

    public static final <T> StringBuilder concatenator(StringBuilder message, List<T> list) {
        boolean first = true;
        for (T item : list) {
            if (first) {
                first = false;
                message.append(item);
                continue;
            }
            message.append(COMMA_SEPARATOR).append(item);
        }
        return message;
    }

    public static final <T, V> StringBuilder concatenator(StringBuilder message, Map<T, V> map) {
        boolean first = true;
        for (Map.Entry<T, V> entry : map.entrySet()) {
            if (first) {
                first = false;
                message.append(entry.getKey()).append(EQUAL_SEPARATOR).append(entry.getValue());
                continue;
            }
            message.append(COMMA_SEPARATOR).append(entry.getKey()).append(EQUAL_SEPARATOR).append(entry.getValue());
        }
        return message;
    }

    public static final Set<String> parseFixedStringSet(String content, int count, int length) {
        HashSet<String> values = new HashSet<String>(count + (count >> 1));
        while (-1 < --count) {
            values.add(content.substring(count * length, count * length + length));
        }
        return values;
    }

    public static final List<String> parseFixedStringList(String content, int count, int length) {
        ArrayList<String> values = new ArrayList<String>(count + (count >> 1));
        while (-1 < --count) {
            values.add(content.substring(count * length, count * length + length));
        }
        return values;
    }

    public static final String[] parseFixedStringArray(String content, int count, int length) {
        String[] values = new String[count];
        while (-1 < --count) {
            values[count] = content.substring(count * length, count * length + length);
        }
        return values;
    }

    public static final void pad(String source, char[] destination, int position, int length, Direction direction, char fill) {
        if (source != null) {
            if (source.length() < 1) {
                if (fill != ' ') {
                    for (int i2 = position; i2 < position + length; ++i2) {
                        destination[i2] = fill;
                    }
                }
            } else {
                if (position < 0 || destination.length < position + length) {
                    throw new FieldBoundaryException("Data position exceeds field length. Source:" + source + ", Source-Length:" + source.length() + ", Position:" + position + ", Length:" + length + ".");
                }
                int d = length - source.length();
                if (0 < d) {
                    if (direction == Direction.LEFT) {
                        source.getChars(0, source.length(), destination, position + d);
                        if (fill != ' ') {
                            for (int i3 = position; i3 < position + d; ++i3) {
                                destination[i3] = fill;
                            }
                        }
                    } else if (direction == Direction.RIGHT) {
                        source.getChars(0, source.length(), destination, position);
                        if (fill != ' ') {
                            for (int i4 = position + source.length(); i4 < position + length; ++i4) {
                                destination[i4] = fill;
                            }
                        }
                    }
                } else {
                    if (d < 0) {
                        throw new DataTruncationException("Data length exceeds field length. Source:" + source + ", Source-Length:" + source.length() + ", Position:" + position + ", Length:" + length + ".");
                    }
                    source.getChars(0, source.length(), destination, position);
                }
            }
        }
    }

    public static final void pad(Direction direction, StringBuilder buffer, int length, char fill) {
        if (buffer.length() < length) {
            if (direction == Direction.LEFT) {
                int i2 = length - buffer.length();
                char[] c = new char[i2];
                while (-1 < --i2) {
                    c[i2] = fill;
                }
                buffer.insert(0, c);
            } else {
                while (buffer.length() < length) {
                    buffer.append(fill);
                }
            }
        }
    }

    public static final int padLeft(StringBuilder buffer, int length, char fill) {
        int d = length - buffer.length();
        if (0 < d) {
            char[] c = new char[d];
            int i2 = d;
            while (-1 < --i2) {
                c[i2] = fill;
            }
            buffer.insert(0, c);
        }
        return d;
    }

    public static final String padLeft(String buffer, int length, char fill) {
        StringBuilder tmp = buffer == null ? new StringBuilder() : new StringBuilder(buffer);
        StringUtilities.padLeft(tmp, length, fill);
        return tmp.toString();
    }

    public static final int padRight(StringBuilder buffer, int length, char fill) {
        int d = length - buffer.length();
        while (buffer.length() < length) {
            buffer.append(fill);
        }
        return d;
    }

    public static final String padRight(String buffer, int length, char fill) {
        StringBuilder tmp = buffer == null ? new StringBuilder() : new StringBuilder(buffer);
        StringUtilities.padRight(tmp, length, fill);
        return tmp.toString();
    }

    public static final void pad(StringBuilder buffer, int length, char fill) {
        if (buffer == null) {
            return;
        }
        int i2 = length - buffer.length();
        if (0 < i2) {
            char[] c = new char[i2];
            while (-1 < --i2) {
                c[i2] = fill;
            }
            buffer.insert(0, c);
        }
    }

    public static final String pad(String buffer, int length, char fill) {
        StringBuilder tmp = new StringBuilder(buffer == null ? EMPTY_STRING : buffer);
        StringUtilities.pad(tmp, length, fill);
        return tmp.toString();
    }

    public static final StringBuilder pad(int length, char fill) {
        StringBuilder buffer = new StringBuilder();
        StringUtilities.pad(buffer, length, fill);
        return buffer;
    }

    public static final void zeroPad(StringBuilder buffer, int length) {
        StringUtilities.pad(buffer == null ? new StringBuilder() : buffer, length, '0');
    }

    public static final StringBuilder zeroPad(String sz, int length) {
        StringBuilder buffer = new StringBuilder(sz == null ? EMPTY_STRING : sz);
        StringUtilities.pad(buffer, length, '0');
        return buffer;
    }

    public static final String toNonNullTrimmedString(String value) {
        return value == null ? EMPTY_STRING : value.trim();
    }

    public static final String toNonNullString(String value) {
        return value == null ? EMPTY_STRING : value;
    }

    public static final String toNonNullString(Boolean value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final String toNonNullString(Byte value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final String toNonNullString(Short value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final String toNonNullString(Integer value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final String toNonNullString(Long value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final String toNonNullString(BigInteger value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final String toNonNullString(Float value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final String toNonNullString(BigDecimal value) {
        return value == null ? EMPTY_STRING : String.valueOf(value);
    }

    public static final boolean isEmpty(String sz) {
        return sz == null || EMPTY_STRING.equals(sz.trim());
    }

    public static final boolean isEmpty(char[] ch) {
        if (ch == null || ch.length < 1) {
            return true;
        }
        int i2 = ch.length;
        while (-1 < --i2 && (ch[i2] == ' ' || ch[i2] == '\u0000')) {
        }
        return i2 < 0;
    }

    public static final boolean isEmpty(StringBuilder s) {
        if (s == null) {
            return true;
        }
        int i2 = s.length();
        while (-1 < --i2 && s.charAt(i2) == ' ') {
        }
        return i2 < 0;
    }

    public static final boolean isEmpty(StringBuffer s) {
        if (s == null) {
            return true;
        }
        int i2 = s.length();
        while (-1 < --i2 && s.charAt(i2) == ' ') {
        }
        return i2 < 0;
    }

    public static final boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        int i2 = s.length();
        while (-1 < --i2 && Character.isDigit(s.charAt(i2))) {
        }
        return i2 < 0;
    }

    public static final boolean isAlphaNumericEqual(String baseSz, String compareSz) {
        if (baseSz == null) {
            return compareSz == null;
        }
        if (compareSz == null) {
            return false;
        }
        CharSequence cs1 = baseSz.subSequence(0, baseSz.length());
        CharSequence cs2 = compareSz.subSequence(0, compareSz.length());
        int l = cs1.length();
        int p = cs2.length();
        int x = -1;
        while (-1 < --l) {
            int c = Character.codePointAt(cs1, l);
            if (Character.isLetter(c)) {
                while (-1 < --p && !Character.isLetter(x = Character.codePointAt(cs2, p))) {
                    if (!Character.isDigit(x)) continue;
                    return false;
                }
                if (p < 0) {
                    return false;
                }
                if (!(Character.isLowerCase(c) ? (Character.isLowerCase(x) ? c != x : c != Character.toLowerCase(x)) : Character.isUpperCase(c) && (Character.isUpperCase(x) ? c != x : c != Character.toUpperCase(x)))) continue;
                return false;
            }
            if (!Character.isDigit(c)) continue;
            while (-1 < --p && !Character.isDigit(x = Character.codePointAt(cs2, p))) {
                if (!Character.isLetter(x)) continue;
                return false;
            }
            if (p >= 0 && c == x) continue;
            return false;
        }
        while (-1 < --p && !Character.isLetterOrDigit(Character.codePointAt(cs2, p))) {
        }
        return p < 0;
    }

    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

